/*
 * Decompiled with CFR 0.152.
 */
package com.rayo.core.xml.providers;

import com.rayo.core.validation.ValidationException;
import com.rayo.core.validation.Validator;
import com.rayo.core.verb.InputMode;
import com.rayo.core.verb.Ssml;
import com.rayo.core.verb.VerbCompleteEvent;
import com.rayo.core.verb.VerbCompleteReason;
import com.rayo.core.xml.XmlProvider;
import com.rayo.core.xml.XmlProviderManager;
import com.voxeo.utils.Enums;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.Node;
import org.dom4j.QName;
import org.dom4j.Text;
import org.joda.time.Duration;

public abstract class BaseProvider
implements XmlProvider {
    protected static final Namespace RAYO_NAMESPACE = new Namespace("", "urn:xmpp:rayo:1");
    protected static final Namespace RAYO_COMPONENT_NAMESPACE = new Namespace("", "urn:xmpp:rayo:ext:1");
    protected static final Namespace RAYO_COMPLETE_NAMESPACE = new Namespace("", "urn:xmpp:rayo:ext:complete:1");
    private Validator validator;
    private XmlProviderManager manager;
    private List<String> namespaces;
    private List<Class<?>> classes;

    public Object fromXML(Element element) {
        Object returnValue = null;
        try {
            returnValue = this.processElement(element);
            if (returnValue == null) {
                return null;
            }
        }
        catch (ValidationException ve) {
            throw ve;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        this.validator.validate(returnValue);
        return returnValue;
    }

    @Override
    public Element toXML(Object object) {
        try {
            Document document = DocumentHelper.createDocument();
            this.generateDocument(object, document);
            return document.getRootElement();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    protected abstract Object processElement(Element var1) throws Exception;

    protected abstract void generateDocument(Object var1, Document var2) throws Exception;

    protected VerbCompleteEvent toVerbCompleteEvent(Element element) {
        String reasonValue = element.getName().toUpperCase();
        VerbCompleteEvent.Reason reason = VerbCompleteEvent.Reason.valueOf(reasonValue);
        VerbCompleteEvent event = new VerbCompleteEvent(reason);
        if (reason == VerbCompleteEvent.Reason.ERROR) {
            event.setErrorText(element.getText());
        }
        return event;
    }

    protected Map<String, String> grabHeaders(Element node) {
        HashMap<String, String> headers = new HashMap<String, String>();
        List elements = node.elements("header");
        for (Element element : elements) {
            headers.put(element.attributeValue("name"), element.attributeValue("value"));
        }
        return headers;
    }

    protected Ssml extractSsml(Element node) throws URISyntaxException {
        StringBuilder builder = new StringBuilder();
        List elements = node.content();
        for (Node element : elements) {
            if (!(element instanceof Text) && !(element instanceof Element)) continue;
            String xml = element.asXML();
            xml = xml.replaceAll(" xmlns=\"[^\"]*\"", "");
            xml = xml.replaceAll(" xmlns:xml=\"[^\"]*\"", "");
            xml = xml.replaceAll(" xml:xml", " xml");
            builder.append(xml);
        }
        Ssml ssml = new Ssml(builder.toString());
        ssml.setVoice(node.attributeValue("voice"));
        return ssml;
    }

    protected void addHeaders(Map<String, String> map, Element node) {
        if (map != null) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                Element header = node.addElement("header");
                header.addAttribute("name", entry.getKey());
                header.addAttribute("value", entry.getValue());
            }
        }
    }

    protected void addSsml(Ssml item, Element root) throws DocumentException {
        if (item != null) {
            if (item.getVoice() != null) {
                root.addAttribute("voice", item.getVoice());
            }
            StringBuilder builder = new StringBuilder("<wrapper>");
            builder.append(item.getText());
            builder.append("</wrapper>");
            Document ssmlDoc = DocumentHelper.parseText((String)builder.toString());
            for (Object element : ssmlDoc.getRootElement().content()) {
                if (element instanceof Text) {
                    root.addText(((Text)element).asXML());
                    continue;
                }
                if (!(element instanceof Element)) continue;
                root.add(((Element)element).createCopy());
            }
        }
    }

    protected InputMode loadInputMode(Element element) {
        try {
            return InputMode.valueOf(element.attributeValue("mode").toUpperCase());
        }
        catch (Exception e) {
            throw new ValidationException("Invalid input mode.");
        }
    }

    protected URI toURI(String string) {
        if (string == null || string.trim().equals("")) {
            return null;
        }
        string = string.trim();
        try {
            return new URI(string);
        }
        catch (URISyntaxException e) {
            throw new ValidationException("You have submitted an invalid URI.");
        }
    }

    protected Boolean toBoolean(String attribute, Element element) {
        String string = element.attributeValue(attribute);
        if (string == null) {
            throw new ValidationException(String.format("You have submitted an invalid boolean value for '%s'", attribute));
        }
        if ((string = string.toLowerCase()).equals("false") || string.equals("true")) {
            return Boolean.valueOf(string);
        }
        throw new ValidationException(String.format("You have submitted an invalid boolean value for '%s'", attribute));
    }

    protected int toInteger(String attribute, Element element) {
        String string = element.attributeValue(attribute);
        if (string == null) {
            throw new ValidationException(String.format("You have submitted an invalid integer value for '%s'", attribute));
        }
        string = string.toLowerCase();
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException nfe) {
            throw new ValidationException(String.format("You have submitted an invalid integer value for '%s'", attribute));
        }
    }

    protected long toLong(String attribute, Element element) {
        String string = element.attributeValue(attribute);
        if (string == null) {
            throw new ValidationException(String.format("You have submitted an invalid long value for '%s'", attribute));
        }
        string = string.toLowerCase();
        try {
            return Long.parseLong(string);
        }
        catch (NumberFormatException nfe) {
            throw new ValidationException(String.format("You have submitted an invalid long value for '%s'", attribute));
        }
    }

    protected float toFloat(String attribute, Element element) {
        String string = element.attributeValue(attribute);
        if (string == null) {
            throw new ValidationException(String.format("You have submitted an invalid float value for '%s'", attribute));
        }
        string = string.toLowerCase();
        try {
            return Float.parseFloat(string);
        }
        catch (NumberFormatException nfe) {
            throw new ValidationException(String.format("You have submitted an invalid float value for '%s'", attribute));
        }
    }

    protected Duration toDuration(String name, Element element) {
        try {
            return new Duration(Long.parseLong(element.attributeValue(name)));
        }
        catch (IllegalArgumentException iae) {
            throw new ValidationException(String.format("Invalid duration for '%s'", name));
        }
    }

    protected Duration toTimeout(String value) {
        try {
            return new Duration(Long.parseLong(value));
        }
        catch (IllegalArgumentException iae) {
            throw new ValidationException("Invalid timeout specified.");
        }
    }

    protected Float toFloatConfidence(String value) {
        try {
            return Float.valueOf(value);
        }
        catch (NumberFormatException nfe) {
            throw new ValidationException("Invalid confidence specified.");
        }
    }

    protected Character toTerminator(String value) {
        if (value == null || value.length() != 1) {
            throw new ValidationException("Invalid terminator character.");
        }
        return new Character(value.charAt(0));
    }

    protected <T extends Enum<T>> T toEnum(Class<T> enumClass, String name, Element element) {
        try {
            return Enum.valueOf(enumClass, element.attributeValue(name).toUpperCase());
        }
        catch (IllegalArgumentException iae) {
            throw new ValidationException(String.format("Unsupported value for '%s'", name));
        }
    }

    protected List<Element> children(Element element) {
        return element.elements();
    }

    protected VerbCompleteEvent fillCompleteEvent(Element completeElement, VerbCompleteEvent event, Class<? extends Enum> reasonClazz) {
        VerbCompleteReason reason = null;
        List<Element> children = this.children(completeElement);
        if (!children.isEmpty()) {
            Element reasonElement = children.get(0);
            String reasonName = reasonElement.getName().toUpperCase();
            reason = (VerbCompleteReason)((Object)Enums.valueOf(VerbCompleteEvent.Reason.class, (String)reasonName, null));
            if (reason == null) {
                reason = (VerbCompleteReason)((Object)Enum.valueOf(reasonClazz, reasonName));
            }
            if (reason == VerbCompleteEvent.Reason.ERROR) {
                event.setErrorText(reasonElement.getText());
            }
        }
        event.setReason(reason);
        return event;
    }

    protected Element addCompleteElement(Document document, VerbCompleteEvent event, Namespace completeNamespace) {
        Element reasonElement = null;
        Element completeElement = document.addElement(new QName("complete", RAYO_COMPONENT_NAMESPACE));
        VerbCompleteReason reason = event.getReason();
        if (reason instanceof VerbCompleteEvent.Reason) {
            VerbCompleteEvent.Reason globalReason = (VerbCompleteEvent.Reason)reason;
            String reasonValue = globalReason.name().toLowerCase();
            reasonElement = completeElement.addElement(new QName(reasonValue, RAYO_COMPLETE_NAMESPACE));
            if (globalReason == VerbCompleteEvent.Reason.ERROR && event.getErrorText() != null) {
                reasonElement.setText(event.getErrorText());
            }
        } else {
            Enum reasonEnum = (Enum)((Object)reason);
            reasonElement = completeElement.addElement(new QName(reasonEnum.name().toLowerCase(), completeNamespace));
        }
        return reasonElement;
    }

    public void setValidator(Validator validator) {
        this.validator = validator;
    }

    protected Validator getValidator() {
        return this.validator;
    }

    @Override
    public boolean handles(Element element) {
        return this.handles(element.getNamespace());
    }

    @Override
    public boolean handles(Namespace ns) {
        for (String namespace : this.namespaces) {
            if (!namespace.equals(ns.getURI())) continue;
            return true;
        }
        return false;
    }

    @Override
    public XmlProviderManager getManager() {
        return this.manager;
    }

    @Override
    public void setManager(XmlProviderManager manager) {
        this.manager = manager;
    }

    public List<String> getNamespaces() {
        return this.namespaces;
    }

    public void setNamespaces(List<String> namespaces) {
        this.namespaces = namespaces;
    }

    @Override
    public boolean handles(Class<?> clazz) {
        return this.classes.contains(clazz);
    }

    public void setClasses(List<Class<?>> classes) {
        this.classes = classes;
    }

    public List<Class<?>> getClasses() {
        return this.classes;
    }
}

