/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.aws.security;

import com.hazelcast.aws.utility.AwsURLEncoder;
import com.hazelcast.config.AwsConfig;
import com.hazelcast.util.QuickMath;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class EC2RequestSigner {
    private static final String API_TERMINATOR = "aws4_request";
    private static final int LAST_INDEX = 8;
    private final AwsConfig config;
    private final String timestamp;
    private String service;
    private String signature;
    private Map<String, String> attributes;
    private String canonicalRequest;
    private String stringToSign;
    private byte[] signingKey;

    public EC2RequestSigner(AwsConfig config, String timeStamp) {
        if (config == null) {
            throw new IllegalArgumentException("config cannot be null");
        }
        if (timeStamp == null) {
            throw new IllegalArgumentException("timeStamp cannot be null");
        }
        this.config = config;
        this.timestamp = timeStamp;
        this.service = null;
    }

    public String getCredentialScope() {
        String dateStamp = this.timestamp.substring(0, 8);
        return String.format("%s/%s/%s/%s", dateStamp, this.config.getRegion(), this.service, API_TERMINATOR);
    }

    public String getSignedHeaders() {
        return "host";
    }

    public String sign(String service, Map<String, String> attributes) {
        if (service == null) {
            throw new IllegalArgumentException("service cannot be null");
        }
        if (attributes == null) {
            throw new IllegalArgumentException("attributes cannot be null");
        }
        this.service = service;
        this.attributes = attributes;
        this.canonicalRequest = this.getCanonicalizedRequest();
        this.stringToSign = this.createStringToSign(this.canonicalRequest);
        this.signingKey = this.deriveSigningKey();
        this.signature = this.createSignature(this.stringToSign, this.signingKey);
        return this.signature;
    }

    private String getCanonicalizedRequest() {
        StringBuilder sb = new StringBuilder();
        sb.append("GET").append("\n");
        sb.append("/").append("\n");
        sb.append(this.getCanonicalizedQueryString(this.attributes)).append("\n");
        sb.append(this.getCanonicalHeaders()).append("\n");
        sb.append(this.getSignedHeaders()).append("\n");
        sb.append(this.sha256Hashhex(""));
        return sb.toString();
    }

    private String createStringToSign(String canonicalRequest) {
        StringBuilder sb = new StringBuilder();
        sb.append("AWS4-HMAC-SHA256").append("\n");
        sb.append(this.timestamp).append("\n");
        sb.append(this.getCredentialScope()).append("\n");
        sb.append(this.sha256Hashhex(canonicalRequest));
        return sb.toString();
    }

    private byte[] deriveSigningKey() {
        String signKey = this.config.getSecretKey();
        String dateStamp = this.timestamp.substring(0, 8);
        try {
            String key = "AWS4" + signKey;
            Mac mDate = Mac.getInstance("HmacSHA256");
            SecretKeySpec skDate = new SecretKeySpec(key.getBytes("UTF-8"), "HmacSHA256");
            mDate.init(skDate);
            byte[] kDate = mDate.doFinal(dateStamp.getBytes("UTF-8"));
            Mac mRegion = Mac.getInstance("HmacSHA256");
            SecretKeySpec skRegion = new SecretKeySpec(kDate, "HmacSHA256");
            mRegion.init(skRegion);
            byte[] kRegion = mRegion.doFinal(this.config.getRegion().getBytes("UTF-8"));
            Mac mService = Mac.getInstance("HmacSHA256");
            SecretKeySpec skService = new SecretKeySpec(kRegion, "HmacSHA256");
            mService.init(skService);
            byte[] kService = mService.doFinal(this.service.getBytes("UTF-8"));
            Mac mSigning = Mac.getInstance("HmacSHA256");
            SecretKeySpec skSigning = new SecretKeySpec(kService, "HmacSHA256");
            mSigning.init(skSigning);
            byte[] kSigning = mSigning.doFinal(API_TERMINATOR.getBytes("UTF-8"));
            return kSigning;
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
        catch (InvalidKeyException e) {
            return null;
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    private String createSignature(String stringToSign, byte[] signingKey) {
        byte[] signature = null;
        try {
            Mac signMac = Mac.getInstance("HmacSHA256");
            SecretKeySpec signKS = new SecretKeySpec(signingKey, "HmacSHA256");
            signMac.init(signKS);
            signature = signMac.doFinal(stringToSign.getBytes("UTF-8"));
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
        catch (InvalidKeyException e) {
            return null;
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
        return QuickMath.bytesToHex((byte[])signature);
    }

    protected String getCanonicalHeaders() {
        return String.format("host:%s", this.config.getHostHeader()) + "\n";
    }

    public String getCanonicalizedQueryString(Map<String, String> attributes) {
        List<String> components = this.getListOfEntries(attributes);
        Collections.sort(components);
        return this.getCanonicalizedQueryString(components);
    }

    protected String getCanonicalizedQueryString(List<String> list) {
        Iterator<String> it = list.iterator();
        StringBuilder result = new StringBuilder(it.next());
        while (it.hasNext()) {
            result.append("&").append(it.next());
        }
        return result.toString();
    }

    protected void addComponents(List<String> components, Map<String, String> attributes, String key) {
        components.add(AwsURLEncoder.urlEncode(key) + "=" + AwsURLEncoder.urlEncode(attributes.get(key)));
    }

    protected List<String> getListOfEntries(Map<String, String> entries) {
        ArrayList<String> components = new ArrayList<String>();
        for (String key : entries.keySet()) {
            this.addComponents(components, entries, key);
        }
        return components;
    }

    private String sha256Hashhex(String in) {
        String payloadHash = "";
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(in.getBytes("UTF-8"));
            byte[] digest = md.digest();
            payloadHash = QuickMath.bytesToHex((byte[])digest);
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
        return payloadHash;
    }

    public String createFormattedCredential() {
        return this.config.getAccessKey() + "/" + this.timestamp.substring(0, 8) + "/" + this.config.getRegion() + "/" + "ec2/aws4_request";
    }
}

