/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.multimap.impl.client;

import com.hazelcast.client.impl.client.RetryableRequest;
import com.hazelcast.multimap.impl.client.MultiMapKeyBasedRequest;
import com.hazelcast.multimap.impl.operations.CountOperation;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.spi.Operation;
import java.io.IOException;

public class CountRequest
extends MultiMapKeyBasedRequest
implements RetryableRequest {
    private long threadId;

    public CountRequest() {
    }

    public CountRequest(String name, Data key, long threadId) {
        super(name, key);
        this.threadId = threadId;
    }

    @Override
    protected Operation prepareOperation() {
        CountOperation operation = new CountOperation(this.name, this.key);
        operation.setThreadId(this.threadId);
        return operation;
    }

    @Override
    public int getClassId() {
        return 3;
    }

    @Override
    public String getMethodName() {
        return "valueCount";
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{this.key};
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        writer.writeLong("threadId", this.threadId);
        super.write(writer);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        this.threadId = reader.readLong("threadId");
        super.read(reader);
    }
}

