/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.collection.impl.txnqueue.operations;

import com.hazelcast.collection.impl.queue.QueueContainer;
import com.hazelcast.collection.impl.queue.operations.QueueBackupAwareOperation;
import com.hazelcast.collection.impl.txnqueue.operations.TxnRollbackBackupOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.Notifier;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.WaitNotifyKey;
import java.io.IOException;

public class TxnRollbackOperation
extends QueueBackupAwareOperation
implements Notifier {
    private long itemId;
    private boolean pollOperation;

    public TxnRollbackOperation() {
    }

    public TxnRollbackOperation(String name, long itemId, boolean pollOperation) {
        super(name);
        this.itemId = itemId;
        this.pollOperation = pollOperation;
    }

    @Override
    public void run() throws Exception {
        QueueContainer queueContainer = this.getOrCreateContainer();
        this.response = this.pollOperation ? Boolean.valueOf(queueContainer.txnRollbackPoll(this.itemId, false)) : Boolean.valueOf(queueContainer.txnRollbackOffer(this.itemId));
    }

    @Override
    public boolean shouldBackup() {
        return true;
    }

    @Override
    public Operation getBackupOperation() {
        return new TxnRollbackBackupOperation(this.name, this.itemId, this.pollOperation);
    }

    @Override
    public boolean shouldNotify() {
        return true;
    }

    @Override
    public WaitNotifyKey getNotifiedKey() {
        QueueContainer queueContainer = this.getOrCreateContainer();
        if (this.pollOperation) {
            return queueContainer.getPollWaitNotifyKey();
        }
        return queueContainer.getOfferWaitNotifyKey();
    }

    @Override
    public int getId() {
        return 34;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeLong(this.itemId);
        out.writeBoolean(this.pollOperation);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.itemId = in.readLong();
        this.pollOperation = in.readBoolean();
    }
}

