/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.splashscreen;

import com.exe4j.runtime.LauncherEngine;
import com.exe4j.runtime.util.ArgumentStack;
import com.install4j.runtime.LauncherConstants;
import java.awt.Color;
import java.awt.Point;
import java.util.StringTokenizer;

public class TextLineConfig
implements LauncherConstants {
    private String text;
    private String fontName;
    private int fontSize;
    private int fontWeight;
    private int fontColorR;
    private int fontColorG;
    private int fontColorB;
    private int positionX;
    private int positionY;

    TextLineConfig(ArgumentStack argumentStack) {
        this.text = argumentStack.popString();
        this.positionX = argumentStack.popInt();
        this.positionY = argumentStack.popInt();
        this.fontName = argumentStack.popString();
        StringTokenizer stringTokenizer = new StringTokenizer(argumentStack.popString(), ",");
        this.fontColorR = Integer.parseInt(stringTokenizer.nextToken());
        this.fontColorG = Integer.parseInt(stringTokenizer.nextToken());
        this.fontColorB = Integer.parseInt(stringTokenizer.nextToken());
        this.fontSize = argumentStack.popInt();
        this.fontWeight = argumentStack.popInt();
    }

    public TextLineConfig(int n) {
        this.text = LauncherEngine.getProperty(n + 2);
        this.positionX = LauncherEngine.getIntProperty(n + 0);
        this.positionY = LauncherEngine.getIntProperty(n + 1);
        this.fontName = LauncherEngine.getProperty(n + 3);
        StringTokenizer stringTokenizer = new StringTokenizer(LauncherEngine.getProperty(n + 5), ",");
        this.fontColorR = Integer.parseInt(stringTokenizer.nextToken());
        this.fontColorG = Integer.parseInt(stringTokenizer.nextToken());
        this.fontColorB = Integer.parseInt(stringTokenizer.nextToken());
        this.fontSize = LauncherEngine.getIntProperty(n + 4);
        this.fontWeight = LauncherEngine.getIntProperty(n + 6);
    }

    public Color getFontColor() {
        return new Color(this.fontColorR, this.fontColorG, this.fontColorB);
    }

    public String getFontName() {
        return this.fontName;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public int getFontWeight() {
        return this.fontWeight;
    }

    public String getText() {
        return this.text;
    }

    public Point getPosition() {
        return new Point(this.positionX, this.positionY);
    }

    public int getFontStyle() {
        return this.fontWeight > 500 ? 1 : 0;
    }
}

