/*
 * Decompiled with CFR 0.152.
 */
package uk.ltd.getahead.junit;

import junit.framework.TestCase;
import uk.ltd.getahead.dwr.util.JavascriptUtil;

public class JavascriptUtilTest
extends TestCase {
    private JavascriptUtil jsutil = new JavascriptUtil();

    public void testCompress() {
        JavascriptUtilTest.assertEquals((String)this.jsutil.compress(" aaa \n aa \n", 4), (String)"aaa\naa\n");
        JavascriptUtilTest.assertEquals((String)this.jsutil.compress("//aaa//bbbb\nxx //aaa\n", 1), (String)"\nxx \n");
        JavascriptUtilTest.assertEquals((String)this.jsutil.compress("a/*\n*/a\n", 2), (String)"a \na\n");
        JavascriptUtilTest.assertEquals((String)this.jsutil.compress("a\n\na\n", 8), (String)"a\na\n");
        JavascriptUtilTest.assertEquals((String)this.jsutil.compress("a\nb\n", 32), (String)"a b \n");
    }

    public void testStripSpaces() {
        JavascriptUtilTest.assertEquals((String)this.jsutil.trimLines("\n"), (String)"\n");
        JavascriptUtilTest.assertEquals((String)this.jsutil.trimLines(null), null);
        JavascriptUtilTest.assertEquals((String)this.jsutil.trimLines("a a\n"), (String)"a a\n");
        JavascriptUtilTest.assertEquals((String)this.jsutil.trimLines("aaa\n"), (String)"aaa\n");
        JavascriptUtilTest.assertEquals((String)this.jsutil.trimLines(" a a \n"), (String)"a a\n");
        JavascriptUtilTest.assertEquals((String)this.jsutil.trimLines(" aaa \n"), (String)"aaa\n");
        JavascriptUtilTest.assertEquals((String)this.jsutil.trimLines(" aaa \n aa \n"), (String)"aaa\naa\n");
    }

    public void testStripSingleLineComments() {
        JavascriptUtilTest.assertEquals((String)this.jsutil.stripSingleLineComments("\n"), (String)"\n");
        JavascriptUtilTest.assertEquals((String)this.jsutil.stripSingleLineComments(null), null);
        JavascriptUtilTest.assertEquals((String)this.jsutil.stripSingleLineComments("a\n"), (String)"a\n");
        JavascriptUtilTest.assertEquals((String)this.jsutil.stripSingleLineComments("/a\n"), (String)"/a\n");
        JavascriptUtilTest.assertEquals((String)this.jsutil.stripSingleLineComments("/a/a\n"), (String)"/a/a\n");
        JavascriptUtilTest.assertEquals((String)this.jsutil.stripSingleLineComments("/ /\n"), (String)"/ /\n");
        JavascriptUtilTest.assertEquals((String)this.jsutil.stripSingleLineComments("//\n"), (String)"\n");
        JavascriptUtilTest.assertEquals((String)this.jsutil.stripSingleLineComments("//aaa\n"), (String)"\n");
        JavascriptUtilTest.assertEquals((String)this.jsutil.stripSingleLineComments("//aaa\naaa\n"), (String)"\naaa\n");
        JavascriptUtilTest.assertEquals((String)this.jsutil.stripSingleLineComments("//aaa//bbbb\naaa\n"), (String)"\naaa\n");
        JavascriptUtilTest.assertEquals((String)this.jsutil.stripSingleLineComments("//aaa//bbbb\nxx //aaa\n"), (String)"\nxx \n");
    }

    public void testStripMultiLineComments() {
        JavascriptUtilTest.assertEquals((String)this.jsutil.stripMultiLineComments("\n"), (String)"\n");
        JavascriptUtilTest.assertEquals((String)this.jsutil.stripMultiLineComments(null), null);
        JavascriptUtilTest.assertEquals((String)this.jsutil.stripMultiLineComments("a\n"), (String)"a\n");
        JavascriptUtilTest.assertEquals((String)this.jsutil.stripMultiLineComments("/a\n"), (String)"/a\n");
        JavascriptUtilTest.assertEquals((String)this.jsutil.stripMultiLineComments("/a*a\n"), (String)"/a*a\n");
        JavascriptUtilTest.assertEquals((String)this.jsutil.stripMultiLineComments("/ */ *\n"), (String)"/ */ *\n");
        JavascriptUtilTest.assertEquals((String)this.jsutil.stripMultiLineComments("/**/\n"), (String)" \n");
        JavascriptUtilTest.assertEquals((String)this.jsutil.stripMultiLineComments("/***/\n"), (String)" \n");
        JavascriptUtilTest.assertEquals((String)this.jsutil.stripMultiLineComments("/*a*/\n"), (String)" \n");
        JavascriptUtilTest.assertEquals((String)this.jsutil.stripMultiLineComments("a/**/a\n"), (String)"a a\n");
        JavascriptUtilTest.assertEquals((String)this.jsutil.stripMultiLineComments("a/*\n*/a\n"), (String)"a \na\n");
    }

    public void testStripBlankLines() {
        JavascriptUtilTest.assertEquals((String)this.jsutil.stripBlankLines("\n"), (String)"\n");
        JavascriptUtilTest.assertEquals((String)this.jsutil.stripBlankLines("\n\n"), (String)"\n");
        JavascriptUtilTest.assertEquals((String)this.jsutil.stripBlankLines(null), null);
        JavascriptUtilTest.assertEquals((String)this.jsutil.stripBlankLines("a\n"), (String)"a\n");
        JavascriptUtilTest.assertEquals((String)this.jsutil.stripBlankLines("a\na\n"), (String)"a\na\n");
        JavascriptUtilTest.assertEquals((String)this.jsutil.stripBlankLines(" \n \n"), (String)"\n");
        JavascriptUtilTest.assertEquals((String)this.jsutil.stripBlankLines(" \n\t\n#\n"), (String)"#\n");
        JavascriptUtilTest.assertEquals((String)this.jsutil.stripBlankLines("\n\n\n"), (String)"\n");
        JavascriptUtilTest.assertEquals((String)this.jsutil.stripBlankLines("a\n\na\n"), (String)"a\na\n");
    }

    public void testStripNewlines() {
        JavascriptUtilTest.assertEquals((String)this.jsutil.stripNewlines(""), (String)"\n");
        JavascriptUtilTest.assertEquals((String)this.jsutil.stripNewlines("\n"), (String)" \n");
        JavascriptUtilTest.assertEquals((String)this.jsutil.stripNewlines(null), null);
        JavascriptUtilTest.assertEquals((String)this.jsutil.stripNewlines("a\nb\n"), (String)"a b \n");
    }

    public void testShrinkVariableNames() {
    }

    public void testEscapeJavaScript() {
    }

    public void testUnescapeJavaScript() {
    }

    public void testIsReservedWord() {
    }
}

