/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.loc;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.loc.LocCommand;

public class SetInterestsAck
extends LocCommand {
    public static final int CODE_SUCCESS = 1;
    private final int code;

    protected SetInterestsAck(SnacPacket snacPacket) {
        super(16);
        DefensiveTools.checkNull(snacPacket, "packet");
        ByteBlock byteBlock = snacPacket.getData();
        this.code = BinaryTools.getUShort(byteBlock, 0);
    }

    public SetInterestsAck() {
        this(1);
    }

    public SetInterestsAck(int n) {
        super(16);
        DefensiveTools.checkRange(n, "code", 0);
        this.code = n;
    }

    public final int getResultCode() {
        return this.code;
    }

    public void writeData(OutputStream outputStream) throws IOException {
        BinaryTools.writeUShort(outputStream, this.code);
    }

    public String toString() {
        return "SetInterestsAck: code=" + this.code;
    }
}

