/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snac;

import net.kano.joscar.DefensiveTools;
import net.kano.joscar.flapcmd.SnacCommand;

public final class CmdType {
    public static final int ALL = -1;
    public static final CmdType CMDTYPE_ALL = new CmdType(-1, -1);
    private final int family;
    private final int command;

    public static CmdType ofCmd(SnacCommand snacCommand) {
        DefensiveTools.checkNull(snacCommand, "command");
        return new CmdType(snacCommand.getFamily(), snacCommand.getCommand());
    }

    public CmdType(int n) {
        this(n, -1);
    }

    public CmdType(int n, int n2) throws IllegalArgumentException {
        if (n == -1 && n2 != -1) {
            throw new IllegalArgumentException("if family is CmdType.ALL (-1),, command type must be as well (instead it is " + n2 + ")");
        }
        if (n != -1 && n < 0) {
            throw new IllegalArgumentException("family must be CmdType.ALL or a positive number (was " + n + ")");
        }
        if (n2 != -1 && n2 < 0) {
            throw new IllegalArgumentException("command type must be CmdType.ALL or a positive number");
        }
        this.family = n;
        this.command = n2;
    }

    public final int getFamily() {
        return this.family;
    }

    public final int getCommand() {
        return this.command;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof CmdType)) {
            return false;
        }
        CmdType cmdType = (CmdType)object;
        return this.family == cmdType.family && this.command == cmdType.command;
    }

    public int hashCode() {
        return this.family << 16 ^ this.command;
    }

    public String toString() {
        if (this.family == -1) {
            return "CmdType: all commands";
        }
        if (this.command == -1) {
            return "CmdType: all commands in family 0x" + Integer.toHexString(this.family);
        }
        return "CmdType: 0x" + Integer.toHexString(this.family) + "/0x" + Integer.toHexString(this.command);
    }
}

