/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.monitor.impl;

import com.hazelcast.com.eclipsesource.json.JsonArray;
import com.hazelcast.com.eclipsesource.json.JsonObject;
import com.hazelcast.com.eclipsesource.json.JsonValue;
import com.hazelcast.monitor.MemberPartitionState;
import com.hazelcast.util.JsonUtil;
import java.util.ArrayList;
import java.util.List;

public class MemberPartitionStateImpl
implements MemberPartitionState {
    public static final int DEFAULT_PARTITION_COUNT = 271;
    List<Integer> partitions = new ArrayList<Integer>(271);
    boolean memberStateSafe;
    long migrationQueueSize;

    @Override
    public JsonObject toJson() {
        JsonObject root = new JsonObject();
        JsonArray partitionsArray = new JsonArray();
        for (Integer lsPartition : this.partitions) {
            partitionsArray.add(lsPartition);
        }
        root.add("partitions", partitionsArray);
        root.add("memberStateSafe", this.memberStateSafe);
        root.add("migrationQueueSize", this.migrationQueueSize);
        return root;
    }

    @Override
    public void fromJson(JsonObject json) {
        JsonArray jsonPartitions = JsonUtil.getArray(json, "partitions");
        for (JsonValue jsonPartition : jsonPartitions) {
            this.partitions.add(jsonPartition.asInt());
        }
        this.memberStateSafe = JsonUtil.getBoolean(json, "memberStateSafe");
        this.migrationQueueSize = JsonUtil.getInt(json, "migrationQueueSize");
    }

    @Override
    public List<Integer> getPartitions() {
        return this.partitions;
    }

    @Override
    public boolean isMemberStateSafe() {
        return this.memberStateSafe;
    }

    public void setMemberStateSafe(boolean memberStateSafe) {
        this.memberStateSafe = memberStateSafe;
    }

    @Override
    public long getMigrationQueueSize() {
        return this.migrationQueueSize;
    }

    public void setMigrationQueueSize(long migrationQueueSize) {
        this.migrationQueueSize = migrationQueueSize;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MemberPartitionStateImpl)) {
            return false;
        }
        MemberPartitionStateImpl that = (MemberPartitionStateImpl)o;
        if (this.memberStateSafe != that.memberStateSafe) {
            return false;
        }
        if (this.migrationQueueSize != that.migrationQueueSize) {
            return false;
        }
        return !(this.partitions != null ? !this.partitions.equals(that.partitions) : that.partitions != null);
    }

    public int hashCode() {
        int result = this.partitions != null ? this.partitions.hashCode() : 0;
        result = 31 * result + (this.memberStateSafe ? 1 : 0);
        result = 31 * result + (int)(this.migrationQueueSize ^ this.migrationQueueSize >>> 32);
        return result;
    }

    public String toString() {
        return "MemberPartitionStateImpl{partitions=" + this.partitions + ", memberStateSafe=" + this.memberStateSafe + ", migrationQueueSize=" + this.migrationQueueSize + '}';
    }
}

