/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.bouncycastle.bcpg.PublicSubkeyPacket;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyPair;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.PGPSignatureSubpacketVector;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.PBESecretKeyEncryptor;
import org.bouncycastle.openpgp.operator.PGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPDigestCalculatorProviderBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePBESecretKeyEncryptorBuilder;

public class PGPKeyRingGenerator {
    List keys = new ArrayList();
    private PBESecretKeyEncryptor keyEncryptor;
    private PGPDigestCalculator checksumCalculator;
    private PGPKeyPair masterKey;
    private PGPSignatureSubpacketVector hashedPcks;
    private PGPSignatureSubpacketVector unhashedPcks;
    private PGPContentSignerBuilder keySignerBuilder;

    public PGPKeyRingGenerator(int n, PGPKeyPair pGPKeyPair, String string, int n2, char[] cArray, PGPSignatureSubpacketVector pGPSignatureSubpacketVector, PGPSignatureSubpacketVector pGPSignatureSubpacketVector2, SecureRandom secureRandom, String string2) throws PGPException, NoSuchProviderException {
        this(n, pGPKeyPair, string, n2, cArray, false, pGPSignatureSubpacketVector, pGPSignatureSubpacketVector2, secureRandom, string2);
    }

    public PGPKeyRingGenerator(int n, PGPKeyPair pGPKeyPair, String string, int n2, char[] cArray, boolean bl, PGPSignatureSubpacketVector pGPSignatureSubpacketVector, PGPSignatureSubpacketVector pGPSignatureSubpacketVector2, SecureRandom secureRandom, String string2) throws PGPException, NoSuchProviderException {
        this(n, pGPKeyPair, string, n2, cArray, bl, pGPSignatureSubpacketVector, pGPSignatureSubpacketVector2, secureRandom, PGPUtil.getProvider(string2));
    }

    public PGPKeyRingGenerator(int n, PGPKeyPair pGPKeyPair, String string, int n2, char[] cArray, boolean bl, PGPSignatureSubpacketVector pGPSignatureSubpacketVector, PGPSignatureSubpacketVector pGPSignatureSubpacketVector2, SecureRandom secureRandom, Provider provider) throws PGPException, NoSuchProviderException {
        this.masterKey = pGPKeyPair;
        this.hashedPcks = pGPSignatureSubpacketVector;
        this.unhashedPcks = pGPSignatureSubpacketVector2;
        this.keyEncryptor = new JcePBESecretKeyEncryptorBuilder(n2).setProvider(provider).setSecureRandom(secureRandom).build(cArray);
        this.checksumCalculator = PGPKeyRingGenerator.convertSHA1Flag(bl);
        this.keySignerBuilder = new JcaPGPContentSignerBuilder(pGPKeyPair.getPublicKey().getAlgorithm(), 2);
        this.keys.add(new PGPSecretKey(n, pGPKeyPair, string, this.checksumCalculator, pGPSignatureSubpacketVector, pGPSignatureSubpacketVector2, this.keySignerBuilder, this.keyEncryptor));
    }

    public PGPKeyRingGenerator(int n, PGPKeyPair pGPKeyPair, String string, PGPDigestCalculator pGPDigestCalculator, PGPSignatureSubpacketVector pGPSignatureSubpacketVector, PGPSignatureSubpacketVector pGPSignatureSubpacketVector2, PGPContentSignerBuilder pGPContentSignerBuilder, PBESecretKeyEncryptor pBESecretKeyEncryptor) throws PGPException {
        this.masterKey = pGPKeyPair;
        this.keyEncryptor = pBESecretKeyEncryptor;
        this.checksumCalculator = pGPDigestCalculator;
        this.keySignerBuilder = pGPContentSignerBuilder;
        this.hashedPcks = pGPSignatureSubpacketVector;
        this.unhashedPcks = pGPSignatureSubpacketVector2;
        this.keys.add(new PGPSecretKey(n, pGPKeyPair, string, pGPDigestCalculator, pGPSignatureSubpacketVector, pGPSignatureSubpacketVector2, pGPContentSignerBuilder, pBESecretKeyEncryptor));
    }

    public void addSubKey(PGPKeyPair pGPKeyPair) throws PGPException {
        this.addSubKey(pGPKeyPair, this.hashedPcks, this.unhashedPcks);
    }

    public void addSubKey(PGPKeyPair pGPKeyPair, PGPSignatureSubpacketVector pGPSignatureSubpacketVector, PGPSignatureSubpacketVector pGPSignatureSubpacketVector2) throws PGPException {
        try {
            PGPSignatureGenerator pGPSignatureGenerator = new PGPSignatureGenerator(this.keySignerBuilder);
            pGPSignatureGenerator.init(24, this.masterKey.getPrivateKey());
            pGPSignatureGenerator.setHashedSubpackets(pGPSignatureSubpacketVector);
            pGPSignatureGenerator.setUnhashedSubpackets(pGPSignatureSubpacketVector2);
            ArrayList<PGPSignature> arrayList = new ArrayList<PGPSignature>();
            arrayList.add(pGPSignatureGenerator.generateCertification(this.masterKey.getPublicKey(), pGPKeyPair.getPublicKey()));
            this.keys.add(new PGPSecretKey(pGPKeyPair.getPrivateKey(), new PGPPublicKey(pGPKeyPair.getPublicKey(), null, arrayList), this.checksumCalculator, this.keyEncryptor));
        }
        catch (PGPException pGPException) {
            throw pGPException;
        }
        catch (Exception exception) {
            throw new PGPException("exception adding subkey: ", exception);
        }
    }

    public PGPSecretKeyRing generateSecretKeyRing() {
        return new PGPSecretKeyRing(this.keys);
    }

    public PGPPublicKeyRing generatePublicKeyRing() {
        Iterator iterator = this.keys.iterator();
        ArrayList<PGPPublicKey> arrayList = new ArrayList<PGPPublicKey>();
        arrayList.add(((PGPSecretKey)iterator.next()).getPublicKey());
        while (iterator.hasNext()) {
            PGPPublicKey pGPPublicKey = new PGPPublicKey(((PGPSecretKey)iterator.next()).getPublicKey());
            pGPPublicKey.publicPk = new PublicSubkeyPacket(pGPPublicKey.getAlgorithm(), pGPPublicKey.getCreationTime(), pGPPublicKey.publicPk.getKey());
            arrayList.add(pGPPublicKey);
        }
        return new PGPPublicKeyRing(arrayList);
    }

    private static PGPDigestCalculator convertSHA1Flag(boolean bl) throws PGPException {
        return bl ? new JcaPGPDigestCalculatorProviderBuilder().build().get(2) : null;
    }
}

