/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.extensions.compress;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.websocket.api.MessageTooLargeException;

public class ByteAccumulator {
    private final List<Chunk> chunks = new ArrayList<Chunk>();
    private final int maxSize;
    private int length = 0;

    public ByteAccumulator(int maxOverallBufferSize) {
        this.maxSize = maxOverallBufferSize;
    }

    public void addChunk(byte[] buf, int offset, int length) {
        if (this.length + length > this.maxSize) {
            throw new MessageTooLargeException("Frame is too large");
        }
        this.chunks.add(new Chunk(buf, offset, length));
        this.length += length;
    }

    public int getLength() {
        return this.length;
    }

    public void transferTo(ByteBuffer buffer) {
        if (buffer.remaining() < this.length) {
            throw new IllegalArgumentException();
        }
        int position = buffer.position();
        for (Chunk chunk : this.chunks) {
            buffer.put(chunk.buffer, chunk.offset, chunk.length);
        }
        BufferUtil.flipToFlush((ByteBuffer)buffer, (int)position);
    }

    private static class Chunk {
        private final byte[] buffer;
        private final int offset;
        private final int length;

        private Chunk(byte[] buffer, int offset, int length) {
            this.buffer = buffer;
            this.offset = offset;
            this.length = length;
        }
    }
}

