/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.spdy.frames;

import org.eclipse.jetty.spdy.api.StreamStatus;
import org.eclipse.jetty.spdy.frames.ControlFrame;
import org.eclipse.jetty.spdy.frames.ControlFrameType;

public class RstStreamFrame
extends ControlFrame {
    private final int streamId;
    private final int statusCode;

    public RstStreamFrame(short version, int streamId, int statusCode) {
        super(version, ControlFrameType.RST_STREAM, (byte)0);
        this.streamId = streamId;
        this.statusCode = statusCode;
    }

    public int getStreamId() {
        return this.streamId;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    @Override
    public String toString() {
        StreamStatus streamStatus = StreamStatus.from(this.getVersion(), this.getStatusCode());
        return String.format("%s stream=%d status=%s", super.toString(), this.getStreamId(), streamStatus == null ? Integer.valueOf(this.getStatusCode()) : streamStatus);
    }
}

