/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.spdy.api;

import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.spdy.api.Info;
import org.eclipse.jetty.util.Fields;

public class HeadersInfo
extends Info {
    public static final byte FLAG_CLOSE = 1;
    public static final byte FLAG_RESET_COMPRESSION = 2;
    private final boolean close;
    private final boolean resetCompression;
    private final Fields headers;

    public HeadersInfo(Fields headers, boolean close) {
        this(headers, close, false);
    }

    public HeadersInfo(Fields headers, boolean close, boolean resetCompression) {
        this.headers = headers;
        this.close = close;
        this.resetCompression = resetCompression;
    }

    public HeadersInfo(long timeout, TimeUnit unit, boolean close, boolean resetCompression, Fields headers) {
        super(timeout, unit);
        this.close = close;
        this.resetCompression = resetCompression;
        this.headers = headers;
    }

    public boolean isClose() {
        return this.close;
    }

    public boolean isResetCompression() {
        return this.resetCompression;
    }

    public Fields getHeaders() {
        return this.headers;
    }

    public byte getFlags() {
        byte flags = this.isClose() ? (byte)1 : 0;
        flags = (byte)(flags + (this.isResetCompression() ? 2 : 0));
        return flags;
    }

    public String toString() {
        return String.format("HEADER close=%b %s", this.close, this.headers);
    }
}

