/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.spdy.server;

import java.io.IOException;
import java.util.List;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public abstract class NegotiatingServerConnection
extends AbstractConnection {
    private static final Logger LOG = Log.getLogger(NegotiatingServerConnection.class);
    private final Connector connector;
    private final SSLEngine engine;
    private final List<String> protocols;
    private final String defaultProtocol;
    private String protocol;

    protected NegotiatingServerConnection(Connector connector, EndPoint endPoint, SSLEngine engine, List<String> protocols, String defaultProtocol) {
        super(endPoint, connector.getExecutor());
        this.connector = connector;
        this.protocols = protocols;
        this.defaultProtocol = defaultProtocol;
        this.engine = engine;
    }

    protected List<String> getProtocols() {
        return this.protocols;
    }

    protected String getDefaultProtocol() {
        return this.defaultProtocol;
    }

    protected SSLEngine getSSLEngine() {
        return this.engine;
    }

    protected String getProtocol() {
        return this.protocol;
    }

    protected void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public void onOpen() {
        super.onOpen();
        this.fillInterested();
    }

    public void onFillable() {
        int filled = this.fill();
        if (filled == 0) {
            if (this.protocol == null) {
                if (this.engine.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
                    LOG.debug("{} could not negotiate protocol, SSLEngine: {}", new Object[]{this, this.engine});
                    this.close();
                } else {
                    this.fillInterested();
                }
            } else {
                ConnectionFactory connectionFactory = this.connector.getConnectionFactory(this.protocol);
                if (connectionFactory == null) {
                    LOG.debug("{} application selected protocol '{}', but no correspondent {} has been configured", new Object[]{this, this.protocol, ConnectionFactory.class.getName()});
                    this.close();
                } else {
                    EndPoint endPoint = this.getEndPoint();
                    Connection oldConnection = endPoint.getConnection();
                    Connection newConnection = connectionFactory.newConnection(this.connector, endPoint);
                    LOG.debug("{} switching from {} to {}", new Object[]{this, oldConnection, newConnection});
                    oldConnection.onClose();
                    endPoint.setConnection(newConnection);
                    this.getEndPoint().getConnection().onOpen();
                }
            }
        } else if (filled < 0) {
            LOG.debug("{} closing on client close", new Object[]{this});
            this.close();
        } else {
            throw new IllegalStateException();
        }
    }

    private int fill() {
        try {
            return this.getEndPoint().fill(BufferUtil.EMPTY_BUFFER);
        }
        catch (IOException x) {
            LOG.debug((Throwable)x);
            this.close();
            return -1;
        }
    }

    public void close() {
        this.getEndPoint().shutdownOutput();
        super.close();
    }
}

