/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.conn;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.conn.ConnCommand;
import net.kano.joscar.snaccmd.conn.SnacFamilyInfo;

public class ClientReadyCmd
extends ConnCommand {
    private final SnacFamilyInfo[] infos;

    protected ClientReadyCmd(SnacPacket snacPacket) {
        super(2);
        DefensiveTools.checkNull(snacPacket, "packet");
        ByteBlock byteBlock = snacPacket.getData();
        this.infos = new SnacFamilyInfo[byteBlock.getLength() / 8];
        for (int i = 0; i < this.infos.length; ++i) {
            this.infos[i] = SnacFamilyInfo.readSnacFamilyInfo(byteBlock);
            byteBlock = byteBlock.subBlock(8);
        }
    }

    public ClientReadyCmd(SnacFamilyInfo[] snacFamilyInfoArray) {
        super(2);
        this.infos = (SnacFamilyInfo[])(snacFamilyInfoArray == null ? null : snacFamilyInfoArray.clone());
    }

    public final SnacFamilyInfo[] getSnacFamilyInfos() {
        return (SnacFamilyInfo[])(this.infos == null ? null : this.infos.clone());
    }

    public void writeData(OutputStream outputStream) throws IOException {
        if (this.infos != null) {
            for (int i = 0; i < this.infos.length; ++i) {
                this.infos[i].write(outputStream);
            }
        }
    }
}

