/*
 * Decompiled with CFR 0.152.
 */
package ymsg.network;

import java.io.IOException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import ymsg.network.HTTPConnection;
import ymsg.network.Session;
import ymsg.network.Util;
import ymsg.network.YahooChatLobby;
import ymsg.network.YahooChatRoom;

public class YahooChatCategory {
    private Session session;
    private String cookieLine;
    protected String name;
    protected long id;
    private int level;
    protected Vector categories;
    protected Vector privateRooms;
    protected Vector publicRooms;
    private static final String PUBLIC_TYPE = "yahoo";
    private static final String PRIVATE_TYPE = "user";
    private static final String PREFIX = "http://";
    private static final String TOP_URL = "insider.msg.yahoo.com/ycontent/?chatcat=0";
    private static final String CAT_URL = "insider.msg.yahoo.com/ycontent/?chatroom_";
    private static String localePrefix = "";
    private static Hashtable chatByNetName = new Hashtable();
    private static transient String inputLine;
    private static YahooChatCategory rootCategory;

    YahooChatCategory(Session ss, long i, int lv, String nm) {
        this.session = ss;
        this.id = i;
        this.level = lv;
        this.name = Util.entityDecode(nm);
        this.categories = new Vector();
        this.privateRooms = null;
        this.publicRooms = null;
        if (this.session != null) {
            String[] cookies = this.session.getCookies();
            this.cookieLine = cookies != null ? "Cookie: " + cookies[0] + "; " + cookies[1] : null;
        }
    }

    void add(YahooChatCategory ycl) {
        this.categories.addElement(ycl);
    }

    public Vector getPublicRooms() throws IOException {
        if (this.publicRooms == null) {
            this.loadRooms();
        }
        return this.publicRooms;
    }

    public Vector getPrivateRooms() throws IOException {
        if (this.privateRooms == null) {
            this.loadRooms();
        }
        return this.privateRooms;
    }

    public void refresh() throws IOException {
        this.loadRooms();
    }

    public Vector getCategories() {
        return this.categories;
    }

    public String getName() {
        return this.name;
    }

    public long getId() {
        return this.id;
    }

    private void loadRooms() throws IOException {
        this.publicRooms = new Vector();
        this.privateRooms = new Vector();
        YahooChatRoom ycr = null;
        String addr = PREFIX + localePrefix + CAT_URL;
        HTTPConnection conn = new HTTPConnection("GET", new URL(addr + this.id));
        if (this.cookieLine != null) {
            conn.println(this.cookieLine);
        }
        conn.println("");
        String in = conn.readLine();
        while (in != null && in.trim().length() > 0 && !in.startsWith("<")) {
            in = conn.readLine();
        }
        if (in.trim().length() == 0) {
            in = conn.readLine();
        }
        inputLine = in;
        in = YahooChatCategory.nextTag(conn);
        while (in != null) {
            Hashtable attrs;
            if (in.startsWith("<room ")) {
                attrs = YahooChatCategory.getAttrs(in);
                String type = (String)attrs.get("type");
                long id = Long.parseLong((String)attrs.get("id"));
                String name = (String)attrs.get("name");
                String topic = (String)attrs.get("topic");
                ycr = new YahooChatRoom(id, name, topic, type.equals(PUBLIC_TYPE));
            } else if (in.startsWith("</room>")) {
                if (ycr.isPublic()) {
                    this.publicRooms.addElement(ycr);
                } else {
                    this.privateRooms.addElement(ycr);
                }
            } else if (in.startsWith("<lobby ")) {
                attrs = YahooChatCategory.getAttrs(in);
                int count = Integer.parseInt(this._getDef(attrs, "count", "0"));
                int users = Integer.parseInt(this._getDef(attrs, "users", "0"));
                int voices = Integer.parseInt(this._getDef(attrs, "voices", "0"));
                int webcams = Integer.parseInt(this._getDef(attrs, "webcams", "0"));
                YahooChatLobby ycl = new YahooChatLobby(count, users, voices, webcams);
                ycr.addLobby(ycl);
                chatByNetName.put(ycl.getNetworkName(), ycl);
            }
            in = YahooChatCategory.nextTag(conn);
        }
        conn.close();
    }

    private String _getDef(Hashtable h, String k, String d) {
        if (h.containsKey(k)) {
            return (String)h.get(k);
        }
        return d;
    }

    public static YahooChatCategory loadCategories() throws IOException {
        return YahooChatCategory.loadCategories(null);
    }

    public static YahooChatCategory loadCategories(Session ss) throws IOException {
        if (rootCategory != null) {
            return rootCategory;
        }
        Stack<YahooChatCategory> st = new Stack<YahooChatCategory>();
        rootCategory = new YahooChatCategory(ss, 0L, 0, "<root>");
        st.push(rootCategory);
        String addr = PREFIX + localePrefix + TOP_URL;
        HTTPConnection conn = new HTTPConnection("GET", new URL(addr));
        if (YahooChatCategory.rootCategory.cookieLine != null) {
            conn.println(YahooChatCategory.rootCategory.cookieLine);
        }
        conn.println("");
        conn.flush();
        String in = conn.readLine();
        while (in != null && in.trim().length() > 0 && in.charAt(0) != '<') {
            in = conn.readLine();
        }
        inputLine = in;
        in = YahooChatCategory.nextTag(conn);
        int level = 0;
        while (in != null) {
            Hashtable attrs;
            if (in.startsWith("<content ")) {
                attrs = YahooChatCategory.getAttrs(in);
                YahooChatCategory.rootCategory.id = Long.parseLong((String)attrs.get("time"));
            } else if (in.startsWith("<category ")) {
                ++level;
                try {
                    attrs = YahooChatCategory.getAttrs(in);
                    long id = Long.parseLong((String)attrs.get("id"));
                    String name = (String)attrs.get("name");
                    YahooChatCategory ycc = new YahooChatCategory(ss, id, level, name);
                    YahooChatCategory o = (YahooChatCategory)st.peek();
                    o.add(ycc);
                    st.push(ycc);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (in.startsWith("</category>")) {
                st.pop();
            }
            in = YahooChatCategory.nextTag(conn);
        }
        conn.close();
        return rootCategory;
    }

    public static void setLocalePrefix(String l) {
        localePrefix = l == null ? "" : l + ".";
    }

    private static String nextTag(HTTPConnection c) throws IOException {
        if (inputLine == null) {
            return null;
        }
        while (inputLine.trim().length() <= 0 || inputLine.indexOf("<") < 0) {
            inputLine = c.readLine();
            if (inputLine != null) continue;
            return null;
        }
        inputLine = inputLine.substring(inputLine.indexOf("<"));
        int idx = inputLine.indexOf(">");
        String r = null;
        if (idx >= 0) {
            r = inputLine.substring(0, idx + 1);
            inputLine = inputLine.substring(idx + 1);
        } else {
            r = inputLine;
            inputLine = "";
        }
        return r;
    }

    private static Hashtable getAttrs(String s) {
        Hashtable<String, String> h = new Hashtable<String, String>();
        int idx = s.indexOf("=\"");
        while (idx >= 0) {
            int len = idx + 2;
            String a1 = s.substring(0, idx);
            String a2 = s.substring(idx + 2);
            idx = a1.indexOf(" ");
            if (idx >= 0) {
                a1 = a1.substring(idx + 1);
            }
            if ((idx = a2.indexOf("\"")) >= 0) {
                a2 = a2.substring(0, idx);
            }
            h.put(a1, a2);
            s = s.substring(len += a2.length() + 1);
            idx = s.indexOf("=\"");
        }
        return h;
    }

    static YahooChatLobby getLobby(String nn) {
        return (YahooChatLobby)chatByNetName.get(nn);
    }

    public String toString() {
        return "name=" + this.name + " id=" + this.id;
    }

    void printGraph(String tb) {
        if (this.categories.size() > 0) {
            System.out.println(tb + "<" + this.name + ">");
            for (int i = 0; i < this.categories.size(); ++i) {
                ((YahooChatCategory)this.categories.elementAt(i)).printGraph(tb + "  ");
            }
            System.out.println(tb + "</" + this.name + ">");
        } else {
            System.out.println(tb + this.name);
        }
    }

    private static void dump(Vector v) {
        for (int i = 0; i < v.size(); ++i) {
            YahooChatRoom ycr = (YahooChatRoom)v.elementAt(i);
            System.out.println(ycr.toString());
            Vector v2 = ycr.getLobbies();
            for (int j = 0; j < v2.size(); ++j) {
                System.out.println("  " + ((YahooChatLobby)v2.elementAt(j)).toString());
            }
        }
    }

    public static void main(String[] st) {
        try {
            YahooChatCategory ycc = YahooChatCategory.loadCategories();
            ycc.printGraph("");
            ycc = (YahooChatCategory)ycc.getCategories().elementAt(0);
            YahooChatCategory.dump(ycc.getPublicRooms());
            YahooChatCategory.dump(ycc.getPrivateRooms());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

