/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.rvproto.rvproxy;

import java.io.IOException;
import java.io.OutputStream;
import java.net.Inet4Address;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.rvproto.rvproxy.RvProxyCmd;
import net.kano.joscar.rvproto.rvproxy.RvProxyPacket;

public class RvProxyAckCmd
extends RvProxyCmd {
    private final Inet4Address ip;
    private final int port;

    protected RvProxyAckCmd(RvProxyPacket rvProxyPacket) {
        super(rvProxyPacket);
        ByteBlock byteBlock = rvProxyPacket.getCommandData();
        this.port = BinaryTools.getUShort(byteBlock, 0);
        this.ip = BinaryTools.getIPFromBytes(byteBlock, 2);
    }

    public RvProxyAckCmd(Inet4Address inet4Address, int n) {
        super(3);
        DefensiveTools.checkNull(inet4Address, "ip");
        DefensiveTools.checkRange(n, "port", -1);
        this.ip = inet4Address;
        this.port = n;
    }

    public final Inet4Address getProxyIpAddress() {
        return this.ip;
    }

    public final int getProxyPort() {
        return this.port;
    }

    public void writeCommandData(OutputStream outputStream) throws IOException {
        if (this.port != -1) {
            BinaryTools.writeUShort(outputStream, this.port);
            if (this.ip != null) {
                outputStream.write(this.ip.getAddress());
            }
        }
    }

    public String toString() {
        return "RvProxyAckCmd: ip=" + this.ip + ", port=" + this.port;
    }
}

