/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.html;

import java.io.IOException;
import java.io.Writer;
import java.util.Dictionary;
import java.util.Hashtable;
import org.mortbay.html.Composite;
import org.mortbay.html.FrameSet;

public class Page
extends Composite {
    public static final String Request = "Request";
    public static final String Response = "Response";
    public static final String Header = "Header";
    public static final String Title = "Title";
    public static final String Section = "Section";
    public static final String HeaderSize = "HdrSize";
    public static final String Footer = "Footer";
    public static final String FooterSize = "FtrSize";
    public static final String Content = "Content";
    public static final String ContentSize = "CntSize";
    public static final String Margin = "Margin";
    public static final String MarginSize = "MrgSize";
    public static final String LeftMargin = "Left";
    public static final String LeftMarginSize = "LMSize";
    public static final String RightMargin = "Right";
    public static final String RightMarginSize = "RMSize";
    public static final String Help = "Help";
    public static final String Home = "Home";
    public static final String Heading = "Heading";
    public static final String Up = "Up";
    public static final String Prev = "Prev";
    public static final String Next = "Next";
    public static final String Back = "Back";
    public static final String Target = "Target";
    public static final String BaseUrl = "BaseUrl";
    public static final String FgColour = "FgColour";
    public static final String BgColour = "BgColour";
    public static final String HighlightColour = "HlColour";
    public static final String PageType = "PageType";
    public static final String NoTitle = "No Title";
    protected Hashtable properties = new Hashtable(10);
    Hashtable sections = new Hashtable(10);
    private Composite head = new Composite();
    private String base = "";
    private boolean writtenHtmlHead = false;
    private boolean writtenBodyTag = false;

    public Page() {
        this(NoTitle);
    }

    public Page(String title) {
        this.title(title);
    }

    public Page(String title, String attributes) {
        this.title(title);
        this.attribute(attributes);
    }

    public Page title(String title) {
        this.properties.put(Title, title);
        String heading = (String)this.properties.get(Heading);
        if (heading == null || heading.equals(NoTitle)) {
            this.properties.put(Heading, title);
        }
        return this;
    }

    public Page addHeader(Object o) {
        this.head.add("\n");
        this.head.add(o);
        return this;
    }

    public final Page setBackGroundImage(String bg) {
        this.attribute("background", bg);
        return this;
    }

    public final Page setBackGroundColor(String color) {
        this.properties.put(BgColour, color);
        this.attribute("bgcolor", color);
        return this;
    }

    public final Page setBase(String target, String href) {
        this.base = "<base " + (target != null ? "TARGET=\"" + target + "\"" : "") + (href != null ? "HREF=\"" + href + "\"" : "") + ">";
        return this;
    }

    public void write(Writer out) throws IOException {
        this.writeHtmlHead(out);
        this.writeBodyTag(out);
        this.writeElements(out);
        this.writeHtmlEnd(out);
    }

    public void writeHtmlHead(Writer out) throws IOException {
        if (!this.writtenHtmlHead) {
            this.writtenHtmlHead = true;
            this.completeSections();
            out.write("<html><head>");
            String title = (String)this.properties.get(Title);
            if (title != null && title.length() > 0 && !title.equals(NoTitle)) {
                out.write("<title>" + title + "</title>");
            }
            this.head.write(out);
            out.write(this.base);
            out.write("\n</head>\n");
        }
    }

    public void writeBodyTag(Writer out) throws IOException {
        if (!this.writtenBodyTag) {
            this.writtenBodyTag = true;
            out.write("<body " + this.attributes() + ">\n");
        }
    }

    public void writeHtmlEnd(Writer out) throws IOException {
        out.write("\n</body>\n");
        out.write("</html>\n");
    }

    public void writeElements(Writer out) throws IOException {
        super.write(out);
    }

    public void write(Writer out, String section, boolean endHtml) throws IOException {
        this.writeHtmlHead(out);
        this.writeBodyTag(out);
        Composite s = this.getSection(section);
        if (s == null) {
            if (section.equals(Content)) {
                this.writeElements(out);
            }
        } else {
            s.write(out);
        }
        if (endHtml) {
            this.writeHtmlEnd(out);
        }
        out.flush();
    }

    public void flush(Writer out) throws IOException {
        this.writeHtmlHead(out);
        this.writeBodyTag(out);
        super.flush(out);
    }

    public void rewind() {
        this.writtenHtmlHead = false;
        this.writtenBodyTag = false;
    }

    public Dictionary properties() {
        return this.properties;
    }

    public FrameSet frameSet() {
        return null;
    }

    public void setSection(String section, Composite composite) {
        this.sections.put(section, composite);
    }

    public void addSection(String section, Composite composite) {
        this.sections.put(section, composite);
        this.add(composite);
    }

    public Composite getSection(String section) {
        return (Composite)this.sections.get(section);
    }

    public void addTo(String section, Object element) {
        Composite s = (Composite)this.sections.get(section);
        if (s == null) {
            this.add(element);
        } else {
            s.add(element);
        }
    }

    protected void completeSections() {
    }
}

