/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.graph;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import org.jrobin.core.RrdException;
import org.jrobin.core.Util;
import org.jrobin.core.XmlWriter;
import org.jrobin.graph.Comment;

public class TimeText
extends Comment {
    private static final String TIME_MARKER = "@t";
    private Date textDate = null;
    private DateFormat dateFormat;
    private ArrayList parsedList;

    TimeText(String text, String pattern) throws RrdException {
        this(text, new SimpleDateFormat(pattern));
    }

    TimeText(String text, DateFormat dateFormat) throws RrdException {
        super(text);
        this.dateFormat = dateFormat;
        if (text.indexOf(TIME_MARKER) < 0) {
            throw new RrdException("Could not find where to place timestamp. No @t placeholder found.");
        }
    }

    TimeText(String text, String pattern, long timestamp) throws RrdException {
        this(text, (DateFormat)new SimpleDateFormat(pattern), new Date(timestamp * 1000L));
    }

    TimeText(String text, DateFormat dateFormat, long timestamp) throws RrdException {
        this(text, dateFormat, new Date(timestamp * 1000L));
    }

    TimeText(String text, String pattern, Date date) throws RrdException {
        this(text, (DateFormat)new SimpleDateFormat(pattern), date);
    }

    TimeText(String text, DateFormat dateFormat, Date date) throws RrdException {
        super(text);
        this.textDate = date;
        this.dateFormat = dateFormat;
        if (text.indexOf(TIME_MARKER) < 0) {
            throw new RrdException("Could not find where to place timestamp. No @t placeholder found.");
        }
    }

    TimeText(String text, String pattern, Calendar cal) throws RrdException {
        this(text, (DateFormat)new SimpleDateFormat(pattern), cal.getTime());
    }

    TimeText(String text, DateFormat dateFormat, Calendar cal) throws RrdException {
        this(text, dateFormat, cal.getTime());
    }

    ArrayList getTokens() {
        this.parsedList = new ArrayList(this.oList);
        String timeStr = this.dateFormat.format(this.textDate != null ? this.textDate : new Date());
        for (int i = 0; i < this.oList.size(); i += 2) {
            String str = (String)this.oList.get(i);
            str = str.replaceAll(TIME_MARKER, timeStr);
            this.parsedList.set(i, str);
        }
        return this.parsedList;
    }

    void exportXmlTemplate(XmlWriter xml) {
        xml.startTag("time");
        xml.writeTag("format", this.text);
        if (this.dateFormat instanceof SimpleDateFormat) {
            xml.writeTag("pattern", ((SimpleDateFormat)this.dateFormat).toPattern());
        } else {
            xml.writeTag("pattern", "");
        }
        if (this.textDate != null) {
            xml.writeTag("value", Util.getTimestamp(this.textDate));
        }
        xml.closeTag();
    }
}

