/*
 * Decompiled with CFR 0.152.
 */
package de.javawi.jstun.test.demo.ice;

import de.javawi.jstun.util.Address;

public class Candidate {
    private Address address;
    private CandidateType type;
    private short componentId;
    private int priority;
    private Candidate base;

    public Candidate(Address address, short componentId) {
        this.address = address;
        this.type = CandidateType.Local;
        this.componentId = componentId;
        this.priority = 0;
        this.base = this;
    }

    public Candidate(Address address, CandidateType type, short componentId, Candidate base) {
        this.address = address;
        this.type = type;
        this.setComponentId(componentId);
        this.priority = 0;
        this.base = base;
    }

    public void setBase(Candidate base) {
        this.base = base;
    }

    public Candidate getBase() {
        return this.base;
    }

    public CandidateType getCandidateType() {
        return this.type;
    }

    public void setComponentId(short componentId) {
        if (componentId < 1 || componentId > 256) {
            throw new IllegalArgumentException(componentId + " is not between 1 and 256 inclusive.");
        }
        this.componentId = componentId;
    }

    public short getComponentId() {
        return this.componentId;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public int getPriority() {
        return this.priority;
    }

    public Address getAddress() {
        return this.address;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CandidateType {
        Local,
        ServerReflexive,
        PeerReflexive,
        Relayed;

    }
}

