/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.module.sitemesh.filter;

import com.opensymphony.module.sitemesh.Factory;
import com.opensymphony.module.sitemesh.Page;
import com.opensymphony.module.sitemesh.filter.Buffer;
import com.opensymphony.module.sitemesh.filter.RoutablePrintWriter;
import com.opensymphony.module.sitemesh.filter.RoutableServletOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public final class PageResponseWrapper
extends HttpServletResponseWrapper {
    private final RoutablePrintWriter routablePrintWriter;
    private final RoutableServletOutputStream routableServletOutputStream;
    private final Factory factory;
    private Buffer buffer;
    private boolean aborted = false;
    private boolean parseablePage = false;

    public PageResponseWrapper(final HttpServletResponse response, Factory factory) {
        super(response);
        this.factory = factory;
        this.routablePrintWriter = new RoutablePrintWriter(new RoutablePrintWriter.DestinationFactory(){

            public PrintWriter activateDestination() throws IOException {
                return response.getWriter();
            }
        });
        this.routableServletOutputStream = new RoutableServletOutputStream(new RoutableServletOutputStream.DestinationFactory(){

            public ServletOutputStream create() throws IOException {
                return response.getOutputStream();
            }
        });
    }

    public void setContentType(String type) {
        super.setContentType(type);
        if (type != null) {
            String contentType;
            int offset = type.lastIndexOf("charset=");
            String encoding = null;
            if (offset != -1) {
                encoding = this.extractContentTypeValue(type, offset + 8);
            }
            if (this.factory.shouldParsePage(contentType = this.extractContentTypeValue(type, 0))) {
                this.activateSiteMesh(contentType, encoding);
            }
        }
    }

    private void activateSiteMesh(String contentType, String encoding) {
        if (this.parseablePage) {
            return;
        }
        this.parseablePage = true;
        this.buffer = new Buffer(this.factory, contentType, encoding);
        this.routablePrintWriter.updateDestination(new RoutablePrintWriter.DestinationFactory(){

            public PrintWriter activateDestination() {
                return PageResponseWrapper.this.buffer.getWriter();
            }
        });
        this.routableServletOutputStream.updateDestination(new RoutableServletOutputStream.DestinationFactory(){

            public ServletOutputStream create() {
                return PageResponseWrapper.this.buffer.getOutputStream();
            }
        });
    }

    private String extractContentTypeValue(String type, int startIndex) {
        int endIndex;
        if (startIndex < 0) {
            return null;
        }
        while (startIndex < type.length() && type.charAt(startIndex) == ' ') {
            ++startIndex;
        }
        if (startIndex >= type.length()) {
            return null;
        }
        if (type.charAt(startIndex) == '\"') {
            if ((endIndex = type.indexOf(34, ++startIndex)) == -1) {
                endIndex = type.length();
            }
        } else {
            char ch;
            for (endIndex = startIndex; endIndex < type.length() && (ch = type.charAt(endIndex)) != ' ' && ch != ';' && ch != '(' && ch != ')' && ch != '[' && ch != ']' && ch != '<' && ch != '>' && ch != ':' && ch != ',' && ch != '=' && ch != '?' && ch != '@' && ch != '\"' && ch != '\\'; ++endIndex) {
            }
        }
        return type.substring(startIndex, endIndex);
    }

    public void setContentLength(int contentLength) {
        if (!this.parseablePage) {
            super.setContentLength(contentLength);
        }
    }

    public void setHeader(String name, String value) {
        if (name.toLowerCase().equals("content-type")) {
            this.setContentType(value);
        } else if (!this.parseablePage || !name.toLowerCase().equals("content-length")) {
            super.setHeader(name, value);
        }
    }

    public void addHeader(String name, String value) {
        if (name.toLowerCase().equals("content-type")) {
            this.setContentType(value);
        } else if (!this.parseablePage || !name.toLowerCase().equals("content-length")) {
            super.addHeader(name, value);
        }
    }

    public void setStatus(int sc) {
        if (!this.parseablePage || sc != 304) {
            super.setStatus(sc);
        }
    }

    public ServletOutputStream getOutputStream() {
        return this.routableServletOutputStream;
    }

    public PrintWriter getWriter() {
        return this.routablePrintWriter;
    }

    public Page getPage() throws IOException {
        if (this.aborted || !this.parseablePage) {
            return null;
        }
        return this.buffer.parse();
    }

    public void sendError(int sc) throws IOException {
        this.aborted = true;
        super.sendError(sc);
    }

    public void sendError(int sc, String msg) throws IOException {
        this.aborted = true;
        super.sendError(sc, msg);
    }

    public void sendRedirect(String location) throws IOException {
        this.aborted = true;
        super.sendRedirect(location);
    }

    public boolean isUsingStream() {
        return this.buffer != null && this.buffer.isUsingStream();
    }
}

