/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.graph;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.jrobin.core.RrdDb;
import org.jrobin.core.RrdException;
import org.jrobin.core.RrdOpener;
import org.jrobin.graph.FetchSource;

public class FetchSourceList {
    private HashMap map;
    private ArrayList list;
    private int defCount;
    private boolean persistent;
    private boolean openerLocked;
    private boolean opened;
    private RrdOpener rrdOpener;

    public FetchSourceList(int defaultSize) {
        this(defaultSize, false, false);
    }

    public FetchSourceList(int defaultSize, boolean persistent, boolean lockOpener) {
        this.map = new HashMap(defaultSize);
        this.list = new ArrayList(defaultSize);
        this.opened = false;
        this.persistent = persistent;
        this.openerLocked = lockOpener;
    }

    public FetchSourceList(int defaultSize, boolean persistent, boolean lockOpener, RrdOpener rrdOpener) {
        this(defaultSize, persistent, lockOpener);
        this.rrdOpener = rrdOpener;
    }

    public void setRrdOpener(RrdOpener rrdOpener) {
        if (!this.persistent && !this.openerLocked) {
            this.rrdOpener = rrdOpener;
        }
    }

    public RrdOpener getRrdOpener() {
        return this.rrdOpener;
    }

    public void setPersistent(boolean persistent) {
        this.persistent = persistent;
    }

    public void lockOpener() {
        this.openerLocked = true;
    }

    public void unlockOpener() {
        this.openerLocked = false;
    }

    public int size() {
        return this.list.size();
    }

    public int defCount() {
        return this.defCount;
    }

    public void openAll() throws RrdException, IOException {
        if (this.opened) {
            return;
        }
        for (int i = 0; i < this.size(); ++i) {
            this.get(i).openRrd();
        }
        this.opened = true;
    }

    public void releaseAll() throws RrdException, IOException {
        if (this.persistent) {
            return;
        }
        for (int i = 0; i < this.size(); ++i) {
            this.get(i).release();
        }
        this.opened = false;
    }

    public void clear() throws RrdException, IOException {
        this.persistent = false;
        this.releaseAll();
        this.map.clear();
        this.list.clear();
    }

    public long getLastUpdateTime() throws RrdException, IOException {
        long maxUpdateTime = 0L;
        long lastUpdateTime = 0L;
        for (int i = 0; i < this.size(); ++i) {
            RrdDb rrd = this.get(i).getRrd();
            lastUpdateTime = rrd.getLastUpdateTime();
            if (lastUpdateTime <= maxUpdateTime) continue;
            maxUpdateTime = lastUpdateTime;
        }
        return maxUpdateTime;
    }

    public void add(String name, String file, String dsName, String consolFunc, String backend) throws RrdException {
        if (this.map.containsKey(file)) {
            FetchSource rf = (FetchSource)this.map.get(file);
            rf.addSource(consolFunc, dsName, name);
        } else {
            FetchSource fs = new FetchSource(file, consolFunc, dsName, name, backend, this);
            this.map.put(file, fs);
            this.list.add(fs);
        }
        ++this.defCount;
    }

    public void add(String name, String file, String dsName, String consolFunc) throws RrdException {
        if (this.map.containsKey(file)) {
            FetchSource rf = (FetchSource)this.map.get(file);
            rf.addSource(consolFunc, dsName, name);
        } else {
            FetchSource fs = new FetchSource(file, consolFunc, dsName, name, this);
            this.map.put(file, fs);
            this.list.add(fs);
        }
        ++this.defCount;
    }

    protected FetchSource get(int index) {
        return (FetchSource)this.list.get(index);
    }
}

