/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.core.jrrd;

import java.io.IOException;
import org.jrobin.core.jrrd.RRDFile;

public class PDPStatusBlock {
    long offset;
    long size;
    String lastReading;
    int unknownSeconds;
    double value;

    PDPStatusBlock(RRDFile file) throws IOException {
        this.offset = file.getFilePointer();
        this.lastReading = file.readString(30);
        file.align(4);
        this.unknownSeconds = file.readInt();
        file.skipBytes(4);
        this.value = file.readDouble();
        file.skipBytes(64);
        this.size = file.getFilePointer() - this.offset;
    }

    public String getLastReading() {
        return this.lastReading;
    }

    public double getValue() {
        return this.value;
    }

    public int getUnknownSeconds() {
        return this.unknownSeconds;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("[PDPStatus: OFFSET=0x");
        sb.append(Long.toHexString(this.offset));
        sb.append(", SIZE=0x");
        sb.append(Long.toHexString(this.size));
        sb.append(", lastReading=");
        sb.append(this.lastReading);
        sb.append(", unknownSeconds=");
        sb.append(this.unknownSeconds);
        sb.append(", value=");
        sb.append(this.value);
        sb.append("]");
        return sb.toString();
    }
}

