/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.core;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;
import org.jrobin.core.ArcDef;
import org.jrobin.core.DsDef;
import org.jrobin.core.RrdException;
import org.jrobin.core.Util;
import org.jrobin.core.XmlWriter;

public class RrdDef {
    public static final long DEFAULT_STEP = 300L;
    public static final long DEFAULT_INITIAL_SHIFT = -10L;
    private String path;
    private long startTime = Util.getTime() + -10L;
    private long step = 300L;
    private ArrayList dsDefs = new ArrayList();
    private ArrayList arcDefs = new ArrayList();

    public RrdDef(String path) throws RrdException {
        if (path == null || path.length() == 0) {
            throw new RrdException("No path specified");
        }
        this.path = path;
    }

    public RrdDef(String path, long step) throws RrdException {
        this(path);
        if (step <= 0L) {
            throw new RrdException("Invalid RRD step specified: " + step);
        }
        this.step = step;
    }

    public RrdDef(String path, long startTime, long step) throws RrdException {
        this(path, step);
        if (startTime < 0L) {
            throw new RrdException("Invalid RRD start time specified: " + startTime);
        }
        this.startTime = startTime;
    }

    public String getPath() {
        return this.path;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getStep() {
        return this.step;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public void setStartTime(Date date) {
        this.startTime = Util.getTimestamp(date);
    }

    public void setStartTime(GregorianCalendar gc) {
        this.startTime = Util.getTimestamp(gc);
    }

    public void setStep(long step) {
        this.step = step;
    }

    public void addDatasource(DsDef dsDef) throws RrdException {
        if (this.dsDefs.contains(dsDef)) {
            throw new RrdException("Datasource already defined: " + dsDef.dump());
        }
        this.dsDefs.add(dsDef);
    }

    public void addDatasource(String dsName, String dsType, long heartbeat, double minValue, double maxValue) throws RrdException {
        this.addDatasource(new DsDef(dsName, dsType, heartbeat, minValue, maxValue));
    }

    public void addDatasource(String rrdToolDsDef) throws RrdException {
        long dsHeartbeat;
        RrdException rrdException = new RrdException("Wrong rrdtool-like datasource definition: " + rrdToolDsDef);
        StringTokenizer tokenizer = new StringTokenizer(rrdToolDsDef, ":");
        if (tokenizer.countTokens() != 6) {
            throw rrdException;
        }
        String[] tokens = new String[6];
        int curTok = 0;
        while (tokenizer.hasMoreTokens()) {
            tokens[curTok] = tokenizer.nextToken();
            ++curTok;
        }
        if (!tokens[0].equalsIgnoreCase("DS")) {
            throw rrdException;
        }
        String dsName = tokens[1];
        String dsType = tokens[2];
        try {
            dsHeartbeat = Long.parseLong(tokens[3]);
        }
        catch (NumberFormatException nfe) {
            throw rrdException;
        }
        double minValue = Double.NaN;
        if (!tokens[4].equalsIgnoreCase("U")) {
            try {
                minValue = Double.parseDouble(tokens[4]);
            }
            catch (NumberFormatException nfe) {
                throw rrdException;
            }
        }
        double maxValue = Double.NaN;
        if (!tokens[5].equalsIgnoreCase("U")) {
            try {
                maxValue = Double.parseDouble(tokens[5]);
            }
            catch (NumberFormatException nfe) {
                throw rrdException;
            }
        }
        this.addDatasource(new DsDef(dsName, dsType, dsHeartbeat, minValue, maxValue));
    }

    public void addDatasource(DsDef[] dsDefs) throws RrdException {
        for (int i = 0; i < dsDefs.length; ++i) {
            this.addDatasource(dsDefs[i]);
        }
    }

    public void addArchive(ArcDef arcDef) throws RrdException {
        if (this.arcDefs.contains(arcDef)) {
            throw new RrdException("Archive already defined: " + arcDef.dump());
        }
        this.arcDefs.add(arcDef);
    }

    public void addArchive(ArcDef[] arcDefs) throws RrdException {
        for (int i = 0; i < arcDefs.length; ++i) {
            this.addArchive(arcDefs[i]);
        }
    }

    public void addArchive(String consolFun, double xff, int steps, int rows) throws RrdException {
        this.addArchive(new ArcDef(consolFun, xff, steps, rows));
    }

    public void addArchive(String rrdToolArcDef) throws RrdException {
        int rows;
        int steps;
        double xff;
        RrdException rrdException = new RrdException("Wrong rrdtool-like archive definition: " + rrdToolArcDef);
        StringTokenizer tokenizer = new StringTokenizer(rrdToolArcDef, ":");
        if (tokenizer.countTokens() != 5) {
            throw rrdException;
        }
        String[] tokens = new String[5];
        int curTok = 0;
        while (tokenizer.hasMoreTokens()) {
            tokens[curTok] = tokenizer.nextToken();
            ++curTok;
        }
        if (!tokens[0].equalsIgnoreCase("RRA")) {
            throw rrdException;
        }
        String consolFun = tokens[1];
        try {
            xff = Double.parseDouble(tokens[2]);
        }
        catch (NumberFormatException nfe) {
            throw rrdException;
        }
        try {
            steps = Integer.parseInt(tokens[3]);
        }
        catch (NumberFormatException nfe) {
            throw rrdException;
        }
        try {
            rows = Integer.parseInt(tokens[4]);
        }
        catch (NumberFormatException nfe) {
            throw rrdException;
        }
        this.addArchive(new ArcDef(consolFun, xff, steps, rows));
    }

    void validate() throws RrdException {
        if (this.dsDefs.size() == 0) {
            throw new RrdException("No RRD datasource specified. At least one is needed.");
        }
        if (this.arcDefs.size() == 0) {
            throw new RrdException("No RRD archive specified. At least one is needed.");
        }
    }

    public DsDef[] getDsDefs() {
        return this.dsDefs.toArray(new DsDef[0]);
    }

    public ArcDef[] getArcDefs() {
        return this.arcDefs.toArray(new ArcDef[0]);
    }

    public int getDsCount() {
        return this.dsDefs.size();
    }

    public int getArcCount() {
        return this.arcDefs.size();
    }

    public String dump() {
        int i;
        StringBuffer buffer = new StringBuffer("create \"");
        buffer.append(this.path + "\"");
        buffer.append(" --start " + this.getStartTime());
        buffer.append(" --step " + this.getStep() + " ");
        for (i = 0; i < this.dsDefs.size(); ++i) {
            DsDef dsDef = (DsDef)this.dsDefs.get(i);
            buffer.append(dsDef.dump() + " ");
        }
        for (i = 0; i < this.arcDefs.size(); ++i) {
            ArcDef arcDef = (ArcDef)this.arcDefs.get(i);
            buffer.append(arcDef.dump() + " ");
        }
        return buffer.toString().trim();
    }

    String getRrdToolCommand() {
        return this.dump();
    }

    void removeDatasource(String dsName) throws RrdException {
        for (int i = 0; i < this.dsDefs.size(); ++i) {
            DsDef dsDef = (DsDef)this.dsDefs.get(i);
            if (!dsDef.getDsName().equals(dsName)) continue;
            this.dsDefs.remove(i);
            return;
        }
        throw new RrdException("Could not find datasource named '" + dsName + "'");
    }

    void removeArchive(String consolFun, int steps) throws RrdException {
        ArcDef arcDef = this.findArchive(consolFun, steps);
        if (!this.arcDefs.remove(arcDef)) {
            throw new RrdException("Could not remove archive " + consolFun + "/" + steps);
        }
    }

    ArcDef findArchive(String consolFun, int steps) throws RrdException {
        for (int i = 0; i < this.arcDefs.size(); ++i) {
            ArcDef arcDef = (ArcDef)this.arcDefs.get(i);
            if (!arcDef.getConsolFun().equals(consolFun) || arcDef.getSteps() != steps) continue;
            return arcDef;
        }
        throw new RrdException("Could not find archive " + consolFun + "/" + steps);
    }

    public void exportXmlTemplate(OutputStream out) {
        XmlWriter xml = new XmlWriter(out);
        xml.startTag("rrd_def");
        xml.writeTag("path", this.getPath());
        xml.writeTag("step", this.getStep());
        xml.writeTag("start", this.getStartTime());
        DsDef[] dsDefs = this.getDsDefs();
        for (int i = 0; i < dsDefs.length; ++i) {
            xml.startTag("datasource");
            xml.writeTag("name", dsDefs[i].getDsName());
            xml.writeTag("type", dsDefs[i].getDsType());
            xml.writeTag("heartbeat", dsDefs[i].getHeartbeat());
            xml.writeTag("min", dsDefs[i].getMinValue(), "U");
            xml.writeTag("max", dsDefs[i].getMaxValue(), "U");
            xml.closeTag();
        }
        ArcDef[] arcDefs = this.getArcDefs();
        for (int i = 0; i < arcDefs.length; ++i) {
            xml.startTag("archive");
            xml.writeTag("cf", arcDefs[i].getConsolFun());
            xml.writeTag("xff", arcDefs[i].getXff());
            xml.writeTag("steps", arcDefs[i].getSteps());
            xml.writeTag("rows", arcDefs[i].getRows());
            xml.closeTag();
        }
        xml.closeTag();
        xml.flush();
    }

    public String exportXmlTemplate() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.exportXmlTemplate(out);
        return out.toString();
    }

    public void exportXmlTemplate(String filePath) throws IOException {
        FileOutputStream out = new FileOutputStream(filePath, false);
        this.exportXmlTemplate(out);
        out.close();
    }

    public long getEstimatedSize() {
        int dsCount = this.dsDefs.size();
        int arcCount = this.arcDefs.size();
        int rowsCount = 0;
        for (int i = 0; i < this.arcDefs.size(); ++i) {
            ArcDef arcDef = (ArcDef)this.arcDefs.get(i);
            rowsCount += arcDef.getRows();
        }
        return RrdDef.calculateSize(dsCount, arcCount, rowsCount);
    }

    static long calculateSize(int dsCount, int arcCount, int rowsCount) {
        return 64L + 128L * (long)dsCount + 56L * (long)arcCount + 20L * (long)dsCount * (long)arcCount + 8L * (long)dsCount * (long)rowsCount;
    }

    public boolean equals(Object obj) {
        ArcDef[] arcDefs2;
        DsDef[] dsDefs2;
        if (obj == null || !(obj instanceof RrdDef)) {
            return false;
        }
        RrdDef rrdDef2 = (RrdDef)obj;
        if (this.step != rrdDef2.step) {
            return false;
        }
        DsDef[] dsDefs = this.getDsDefs();
        if (dsDefs.length != (dsDefs2 = rrdDef2.getDsDefs()).length) {
            return false;
        }
        for (int i = 0; i < dsDefs.length; ++i) {
            boolean matched = false;
            for (int j = 0; j < dsDefs2.length; ++j) {
                if (!dsDefs[i].exactlyEqual(dsDefs2[j])) continue;
                matched = true;
                break;
            }
            if (matched) continue;
            return false;
        }
        ArcDef[] arcDefs = this.getArcDefs();
        if (arcDefs.length != (arcDefs2 = rrdDef2.getArcDefs()).length) {
            return false;
        }
        for (int i = 0; i < arcDefs.length; ++i) {
            boolean matched = false;
            for (int j = 0; j < arcDefs2.length; ++j) {
                if (!arcDefs[i].exactlyEqual(arcDefs2[j])) continue;
                matched = true;
                break;
            }
            if (matched) continue;
            return false;
        }
        return true;
    }
}

