/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.core;

import java.util.StringTokenizer;
import org.jrobin.core.RrdException;

class RpnCalculator {
    static final String VAR_PLACEHOLDER = "value";
    private static final byte TOK_VAR = 0;
    private static final byte TOK_NUM = 1;
    private static final byte TOK_PLUS = 2;
    private static final byte TOK_MINUS = 3;
    private static final byte TOK_MULT = 4;
    private static final byte TOK_DIV = 5;
    private static final byte TOK_MOD = 6;
    private static final byte TOK_SIN = 7;
    private static final byte TOK_COS = 8;
    private static final byte TOK_LOG = 9;
    private static final byte TOK_EXP = 10;
    private static final byte TOK_FLOOR = 11;
    private static final byte TOK_CEIL = 12;
    private static final byte TOK_ROUND = 13;
    private static final byte TOK_POW = 14;
    private static final byte TOK_ABS = 15;
    private static final byte TOK_SQRT = 16;
    private static final byte TOK_RANDOM = 17;
    private static final byte TOK_LT = 18;
    private static final byte TOK_LE = 19;
    private static final byte TOK_GT = 20;
    private static final byte TOK_GE = 21;
    private static final byte TOK_EQ = 22;
    private static final byte TOK_IF = 23;
    private static final byte TOK_MIN = 24;
    private static final byte TOK_MAX = 25;
    private static final byte TOK_LIMIT = 26;
    private static final byte TOK_DUP = 27;
    private static final byte TOK_EXC = 28;
    private static final byte TOK_POP = 29;
    private static final byte TOK_UN = 30;
    private static final byte TOK_UNKN = 31;
    private static final byte TOK_PI = 34;
    private static final byte TOK_E = 35;
    private static final byte TOK_AND = 36;
    private static final byte TOK_OR = 37;
    private static final byte TOK_XOR = 38;
    private String[] tokens;
    private byte[] tokenCodes;
    private double[] parsedDoubles;
    private RpnStack stack = new RpnStack();
    private String rpnExpression;
    private double value;

    RpnCalculator(String rpnExpression) throws RrdException {
        this.rpnExpression = rpnExpression;
        this.createTokens();
    }

    void setValue(double value) {
        this.value = value;
    }

    private void createTokens() throws RrdException {
        StringTokenizer st = new StringTokenizer(this.rpnExpression, ",");
        int count = st.countTokens();
        this.tokens = new String[count];
        this.tokenCodes = new byte[count];
        this.parsedDoubles = new double[count];
        int i = 0;
        while (st.hasMoreTokens()) {
            byte tokenCode;
            String token;
            this.tokens[i] = token = st.nextToken();
            this.tokenCodes[i] = tokenCode = this.findTokenCode(token);
            if (tokenCode == 1) {
                this.parsedDoubles[i] = Double.parseDouble(token);
            }
            ++i;
        }
    }

    private byte findTokenCode(String token) throws RrdException {
        if (RpnCalculator.isVariable(token)) {
            return 0;
        }
        if (RpnCalculator.isNumber(token)) {
            return 1;
        }
        if (token.equals("+")) {
            return 2;
        }
        if (token.equals("-")) {
            return 3;
        }
        if (token.equals("*")) {
            return 4;
        }
        if (token.equals("/")) {
            return 5;
        }
        if (token.equals("%")) {
            return 6;
        }
        if (token.equals("SIN")) {
            return 7;
        }
        if (token.equals("COS")) {
            return 8;
        }
        if (token.equals("LOG")) {
            return 9;
        }
        if (token.equals("EXP")) {
            return 10;
        }
        if (token.equals("FLOOR")) {
            return 11;
        }
        if (token.equals("CEIL")) {
            return 12;
        }
        if (token.equals("ROUND")) {
            return 13;
        }
        if (token.equals("POW")) {
            return 14;
        }
        if (token.equals("ABS")) {
            return 15;
        }
        if (token.equals("SQRT")) {
            return 16;
        }
        if (token.equals("RANDOM")) {
            return 17;
        }
        if (token.equals("LT")) {
            return 18;
        }
        if (token.equals("LE")) {
            return 19;
        }
        if (token.equals("GT")) {
            return 20;
        }
        if (token.equals("GE")) {
            return 21;
        }
        if (token.equals("EQ")) {
            return 22;
        }
        if (token.equals("IF")) {
            return 23;
        }
        if (token.equals("MIN")) {
            return 24;
        }
        if (token.equals("MAX")) {
            return 25;
        }
        if (token.equals("LIMIT")) {
            return 26;
        }
        if (token.equals("DUP")) {
            return 27;
        }
        if (token.equals("EXC")) {
            return 28;
        }
        if (token.equals("POP")) {
            return 29;
        }
        if (token.equals("UN")) {
            return 30;
        }
        if (token.equals("UNKN")) {
            return 31;
        }
        if (token.equals("PI")) {
            return 34;
        }
        if (token.equals("E")) {
            return 35;
        }
        if (token.equals("AND")) {
            return 36;
        }
        if (token.equals("OR")) {
            return 37;
        }
        if (token.equals("XOR")) {
            return 38;
        }
        throw new RrdException("Unknown RPN token encountered: " + token);
    }

    private static boolean isNumber(String token) {
        try {
            Double.parseDouble(token);
            return true;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    private static boolean isVariable(String token) {
        return token.equals(VAR_PLACEHOLDER);
    }

    double calculate() throws RrdException {
        this.resetCalculator();
        block39: for (int i = 0; i < this.tokenCodes.length; ++i) {
            byte tokenCode = this.tokenCodes[i];
            switch (tokenCode) {
                case 1: {
                    this.push(this.parsedDoubles[i]);
                    continue block39;
                }
                case 0: {
                    this.push(this.value);
                    continue block39;
                }
                case 2: {
                    this.push(this.pop() + this.pop());
                    continue block39;
                }
                case 3: {
                    double x2 = this.pop();
                    double x1 = this.pop();
                    this.push(x1 - x2);
                    continue block39;
                }
                case 4: {
                    this.push(this.pop() * this.pop());
                    continue block39;
                }
                case 5: {
                    double x2 = this.pop();
                    double x1 = this.pop();
                    this.push(x1 / x2);
                    continue block39;
                }
                case 6: {
                    double x2 = this.pop();
                    double x1 = this.pop();
                    this.push(x1 % x2);
                    continue block39;
                }
                case 7: {
                    this.push(Math.sin(this.pop()));
                    continue block39;
                }
                case 8: {
                    this.push(Math.cos(this.pop()));
                    continue block39;
                }
                case 9: {
                    this.push(Math.log(this.pop()));
                    continue block39;
                }
                case 10: {
                    this.push(Math.exp(this.pop()));
                    continue block39;
                }
                case 11: {
                    this.push(Math.floor(this.pop()));
                    continue block39;
                }
                case 12: {
                    this.push(Math.ceil(this.pop()));
                    continue block39;
                }
                case 13: {
                    this.push(Math.round(this.pop()));
                    continue block39;
                }
                case 14: {
                    double x2 = this.pop();
                    double x1 = this.pop();
                    this.push(Math.pow(x1, x2));
                    continue block39;
                }
                case 15: {
                    this.push(Math.abs(this.pop()));
                    continue block39;
                }
                case 16: {
                    this.push(Math.sqrt(this.pop()));
                    continue block39;
                }
                case 17: {
                    this.push(Math.random());
                    continue block39;
                }
                case 18: {
                    double x2 = this.pop();
                    double x1 = this.pop();
                    this.push(x1 < x2 ? 1.0 : 0.0);
                    continue block39;
                }
                case 19: {
                    double x2 = this.pop();
                    double x1 = this.pop();
                    this.push(x1 <= x2 ? 1.0 : 0.0);
                    continue block39;
                }
                case 20: {
                    double x2 = this.pop();
                    double x1 = this.pop();
                    this.push(x1 > x2 ? 1.0 : 0.0);
                    continue block39;
                }
                case 21: {
                    double x2 = this.pop();
                    double x1 = this.pop();
                    this.push(x1 >= x2 ? 1.0 : 0.0);
                    continue block39;
                }
                case 22: {
                    double x2 = this.pop();
                    double x1 = this.pop();
                    this.push(x1 == x2 ? 1.0 : 0.0);
                    continue block39;
                }
                case 23: {
                    double x3 = this.pop();
                    double x2 = this.pop();
                    double x1 = this.pop();
                    this.push(x1 != 0.0 ? x2 : x3);
                    continue block39;
                }
                case 24: {
                    this.push(Math.min(this.pop(), this.pop()));
                    continue block39;
                }
                case 25: {
                    this.push(Math.max(this.pop(), this.pop()));
                    continue block39;
                }
                case 26: {
                    double x3 = this.pop();
                    double x2 = this.pop();
                    double x1 = this.pop();
                    this.push(x1 < x2 || x1 > x3 ? Double.NaN : x1);
                    continue block39;
                }
                case 27: {
                    double x1 = this.pop();
                    this.push(x1);
                    this.push(x1);
                    continue block39;
                }
                case 28: {
                    double x2 = this.pop();
                    double x1 = this.pop();
                    this.push(x2);
                    this.push(x1);
                    continue block39;
                }
                case 29: {
                    this.pop();
                    continue block39;
                }
                case 30: {
                    this.push(Double.isNaN(this.pop()) ? 1.0 : 0.0);
                    continue block39;
                }
                case 31: {
                    this.push(Double.NaN);
                    continue block39;
                }
                case 34: {
                    this.push(Math.PI);
                    continue block39;
                }
                case 35: {
                    this.push(Math.E);
                    continue block39;
                }
                case 36: {
                    double x2 = this.pop();
                    double x1 = this.pop();
                    this.push(x1 != 0.0 && x2 != 0.0 ? 1.0 : 0.0);
                    continue block39;
                }
                case 37: {
                    double x2 = this.pop();
                    double x1 = this.pop();
                    this.push(x1 != 0.0 || x2 != 0.0 ? 1.0 : 0.0);
                    continue block39;
                }
                case 38: {
                    double x2 = this.pop();
                    double x1 = this.pop();
                    this.push(x1 != 0.0 && x2 == 0.0 || x1 == 0.0 && x2 != 0.0 ? 1.0 : 0.0);
                    continue block39;
                }
                default: {
                    throw new RrdException("Unexpected RPN token encountered [" + tokenCode + "]");
                }
            }
        }
        double retVal = this.pop();
        if (!this.isStackEmpty()) {
            throw new RrdException("Stack not empty at the end of calculation. Probably bad RPN expression");
        }
        return retVal;
    }

    void push(double x) throws RrdException {
        this.stack.push(x);
    }

    double pop() throws RrdException {
        return this.stack.pop();
    }

    void resetCalculator() {
        this.stack.reset();
    }

    boolean isStackEmpty() {
        return this.stack.isEmpty();
    }

    class RpnStack {
        static final int MAX_STACK_SIZE = 1000;
        private double[] stack = new double[1000];
        private int pos = 0;

        RpnStack() {
        }

        void push(double x) throws RrdException {
            if (this.pos >= 1000) {
                throw new RrdException("PUSH failed, RPN stack full [1000]");
            }
            this.stack[this.pos++] = x;
        }

        double pop() throws RrdException {
            if (this.pos <= 0) {
                throw new RrdException("POP failed, RPN stack is empty ");
            }
            return this.stack[--this.pos];
        }

        void reset() {
            this.pos = 0;
        }

        boolean isEmpty() {
            return this.pos == 0;
        }
    }
}

