/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.core;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DecimalFormat;
import org.jrobin.core.Archive;
import org.jrobin.core.FetchPoint;
import org.jrobin.core.FetchRequest;
import org.jrobin.core.RpnCalculator;
import org.jrobin.core.RrdDataSet;
import org.jrobin.core.RrdException;
import org.jrobin.core.Util;
import org.jrobin.core.XmlWriter;

public class FetchData
implements RrdDataSet {
    private FetchRequest request;
    private Archive matchingArchive;
    private String[] dsNames;
    private long[] timestamps;
    private double[][] values;

    FetchData(Archive matchingArchive, FetchRequest request) throws IOException {
        this.matchingArchive = matchingArchive;
        this.dsNames = request.getFilter();
        if (this.dsNames == null) {
            this.dsNames = matchingArchive.getParentDb().getDsNames();
        }
        this.request = request;
    }

    void setTimestamps(long[] timestamps) {
        this.timestamps = timestamps;
    }

    void setValues(double[][] values) {
        this.values = values;
    }

    public int getRowCount() {
        return this.timestamps.length;
    }

    public int getColumnCount() {
        return this.dsNames.length;
    }

    public FetchPoint getRow(int rowIndex) {
        int numCols = this.getColumnCount();
        FetchPoint point = new FetchPoint(this.timestamps[rowIndex], this.getColumnCount());
        for (int dsIndex = 0; dsIndex < numCols; ++dsIndex) {
            point.setValue(dsIndex, this.values[dsIndex][rowIndex]);
        }
        return point;
    }

    public long[] getTimestamps() {
        return this.timestamps;
    }

    public long getStep() {
        return this.timestamps[1] - this.timestamps[0];
    }

    public double[] getValues(int dsIndex) {
        return this.values[dsIndex];
    }

    public double[][] getValues() {
        return this.values;
    }

    public double[] getValues(String dsName) throws RrdException {
        for (int dsIndex = 0; dsIndex < this.getColumnCount(); ++dsIndex) {
            if (!dsName.equals(this.dsNames[dsIndex])) continue;
            return this.getValues(dsIndex);
        }
        throw new RrdException("Datasource [" + dsName + "] not found");
    }

    public FetchRequest getRequest() {
        return this.request;
    }

    public long getFirstTimestamp() {
        return this.timestamps[0];
    }

    public long getLastTimestamp() {
        return this.timestamps[this.timestamps.length - 1];
    }

    public Archive getMatchingArchive() {
        return this.matchingArchive;
    }

    public String[] getDsNames() {
        return this.dsNames;
    }

    public int getDsIndex(String dsName) {
        for (int i = 0; i < this.dsNames.length; ++i) {
            if (!this.dsNames[i].equals(dsName)) continue;
            return i;
        }
        return -1;
    }

    public void dump() {
        for (int i = 0; i < this.getRowCount(); ++i) {
            System.out.println(this.getRow(i).dump());
        }
    }

    public String toString() {
        int i;
        DecimalFormat df = new DecimalFormat("+0.0000000000E00");
        StringBuffer buff = new StringBuffer();
        buff.append(FetchData.padWithBlanks("", 10));
        buff.append(" ");
        for (i = 0; i < this.dsNames.length; ++i) {
            buff.append(FetchData.padWithBlanks(this.dsNames[i], 18));
        }
        buff.append("\n \n");
        for (i = 0; i < this.timestamps.length; ++i) {
            buff.append(FetchData.padWithBlanks("" + this.timestamps[i], 10));
            buff.append(":");
            for (int j = 0; j < this.dsNames.length; ++j) {
                double value = this.values[j][i];
                String valueStr = Double.isNaN(value) ? "nan" : df.format(value);
                buff.append(FetchData.padWithBlanks(valueStr, 18));
            }
            buff.append("\n");
        }
        return buff.toString();
    }

    private static String padWithBlanks(String input, int width) {
        StringBuffer buff = new StringBuffer("");
        int diff = width - input.length();
        while (diff-- > 0) {
            buff.append(' ');
        }
        buff.append(input);
        return buff.toString();
    }

    public double getAggregate(String dsName, String consolFun) throws RrdException {
        return this.getAggregate(dsName, consolFun, null);
    }

    public double getAggregate(String dsName, String consolFun, String rpnExpression) throws RrdException {
        if (consolFun.equals("MAX")) {
            return this.getMax(dsName, rpnExpression);
        }
        if (consolFun.equals("MIN")) {
            return this.getMin(dsName, rpnExpression);
        }
        if (consolFun.equals("LAST")) {
            return this.getLast(dsName, rpnExpression);
        }
        if (consolFun.equals("AVERAGE")) {
            return this.getAverage(dsName, rpnExpression);
        }
        throw new RrdException("Unsupported consolidation function [" + consolFun + "]");
    }

    private double getMax(String dsName, String rpnExpression) throws RrdException {
        RpnCalculator rpnCalculator = null;
        if (rpnExpression != null) {
            rpnCalculator = new RpnCalculator(rpnExpression);
        }
        double[] vals = this.getValues(dsName);
        double max = Double.NaN;
        for (int i = 0; i < vals.length - 1; ++i) {
            double value = vals[i + 1];
            if (rpnCalculator != null) {
                rpnCalculator.setValue(value);
                value = rpnCalculator.calculate();
            }
            max = Util.max(max, value);
        }
        return max;
    }

    private double getMin(String dsName, String rpnExpression) throws RrdException {
        RpnCalculator rpnCalculator = null;
        if (rpnExpression != null) {
            rpnCalculator = new RpnCalculator(rpnExpression);
        }
        double[] vals = this.getValues(dsName);
        double min = Double.NaN;
        for (int i = 0; i < vals.length - 1; ++i) {
            double value = vals[i + 1];
            if (rpnCalculator != null) {
                rpnCalculator.setValue(value);
                value = rpnCalculator.calculate();
            }
            min = Util.min(min, value);
        }
        return min;
    }

    private double getLast(String dsName, String rpnExpression) throws RrdException {
        RpnCalculator rpnCalculator = null;
        if (rpnExpression != null) {
            rpnCalculator = new RpnCalculator(rpnExpression);
        }
        double[] vals = this.getValues(dsName);
        double value = vals[vals.length - 1];
        if (rpnCalculator != null) {
            rpnCalculator.setValue(value);
            value = rpnCalculator.calculate();
        }
        return value;
    }

    private double getAverage(String dsName, String rpnExpression) throws RrdException {
        RpnCalculator rpnCalculator = null;
        if (rpnExpression != null) {
            rpnCalculator = new RpnCalculator(rpnExpression);
        }
        double[] vals = this.getValues(dsName);
        double totalVal = 0.0;
        long totalSecs = 0L;
        for (int i = 0; i < vals.length - 1; ++i) {
            long t1 = Math.max(this.request.getFetchStart(), this.timestamps[i]);
            long t2 = Math.min(this.request.getFetchEnd(), this.timestamps[i + 1]);
            double value = vals[i + 1];
            if (rpnCalculator != null) {
                rpnCalculator.setValue(value);
                value = rpnCalculator.calculate();
            }
            if (Double.isNaN(value)) continue;
            totalSecs += t2 - t1;
            totalVal += (double)(t2 - t1) * value;
        }
        return totalSecs > 0L ? totalVal / (double)totalSecs : Double.NaN;
    }

    public void exportXml(OutputStream outputStream) throws IOException {
        int i;
        XmlWriter writer = new XmlWriter(outputStream);
        writer.startTag("fetch_data");
        writer.startTag("request");
        writer.writeTag("file", this.request.getParentDb().getPath());
        writer.writeComment(Util.getDate(this.request.getFetchStart()));
        writer.writeTag("start", this.request.getFetchStart());
        writer.writeComment(Util.getDate(this.request.getFetchEnd()));
        writer.writeTag("end", this.request.getFetchEnd());
        writer.writeTag("resolution", this.request.getResolution());
        writer.writeTag("cf", this.request.getConsolFun());
        writer.closeTag();
        writer.startTag("datasources");
        for (i = 0; i < this.dsNames.length; ++i) {
            writer.writeTag("name", this.dsNames[i]);
        }
        writer.closeTag();
        writer.startTag("data");
        for (i = 0; i < this.timestamps.length; ++i) {
            writer.startTag("row");
            writer.writeComment(Util.getDate(this.timestamps[i]));
            writer.writeTag("timestamp", this.timestamps[i]);
            writer.startTag("values");
            for (int j = 0; j < this.dsNames.length; ++j) {
                writer.writeTag("v", this.values[j][i]);
            }
            writer.closeTag();
            writer.closeTag();
        }
        writer.closeTag();
        writer.closeTag();
        writer.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportXml(String filepath) throws IOException {
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(filepath);
            this.exportXml(outputStream);
        }
        finally {
            if (outputStream != null) {
                ((OutputStream)outputStream).close();
            }
        }
    }

    public String exportXml() throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        this.exportXml(outputStream);
        return outputStream.toString();
    }
}

