/*
 * Decompiled with CFR 0.152.
 */
package uk.ltd.getahead.dwr;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import uk.ltd.getahead.dwr.util.Logger;
import uk.ltd.getahead.dwr.util.SwallowingHttpServletResponse;

public class ExecutionContext {
    private HttpServletRequest request = null;
    private HttpServletResponse response = null;
    private ServletConfig config = null;
    private ServletContext context = null;
    private static final String FILENAME_VERSION = "/dwr-version.properties";
    private static final String KEY_VERSION = "version";
    private static final String KEY_SCCINFO = "scc-info";
    private static final String KEY_ERROR = "error";
    private static final String VALUE_UNKNOWN = "unknown";
    private static Properties props = null;
    private static final Object propLock = new Object();
    private static ThreadLocal user = new ThreadLocal();
    private static Class implementation;
    private static final Logger log;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("uk.ltd.getahead.dwr.ExecutionContext");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        implementation = clazz;
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("uk.ltd.getahead.dwr.ExecutionContext");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger(clazz2);
    }

    protected void init(HttpServletRequest newRequest, HttpServletResponse newResponse, ServletConfig newConfig, ServletContext newContext) {
        this.request = newRequest;
        this.response = newResponse;
        this.config = newConfig;
        this.context = newContext;
    }

    public HttpSession getSession() {
        return this.request.getSession();
    }

    public HttpSession getSession(boolean create) {
        return this.request.getSession(create);
    }

    public ServletConfig getServletConfig() {
        return this.config;
    }

    public ServletContext getServletContext() {
        return this.context;
    }

    public HttpServletRequest getHttpServletRequest() {
        return this.request;
    }

    public HttpServletResponse getHttpServletResponse() {
        return this.response;
    }

    public String forwardToString(String url) throws ServletException, IOException {
        StringWriter sout = new StringWriter();
        StringBuffer buffer = sout.getBuffer();
        SwallowingHttpServletResponse fakeResponse = new SwallowingHttpServletResponse(this.getHttpServletResponse(), sout);
        this.getServletContext().getRequestDispatcher(url).forward((ServletRequest)this.getHttpServletRequest(), (ServletResponse)fakeResponse);
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getVersion() {
        Object object = propLock;
        synchronized (object) {
            if (props == null) {
                this.loadProperties();
            }
            return props.getProperty(KEY_VERSION);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getSourceControlInfo() {
        Object object = propLock;
        synchronized (object) {
            if (props == null) {
                this.loadProperties();
            }
            return props.getProperty(KEY_SCCINFO);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadProperties() {
        Object object = propLock;
        synchronized (object) {
            props = new Properties();
            try {
                InputStream in = this.getClass().getResourceAsStream(FILENAME_VERSION);
                props.load(in);
            }
            catch (Exception ex) {
                props.put(KEY_VERSION, VALUE_UNKNOWN);
                props.put(KEY_SCCINFO, VALUE_UNKNOWN);
                props.put(KEY_ERROR, ex.toString());
            }
        }
    }

    public static ExecutionContext get() {
        return (ExecutionContext)user.get();
    }

    public static void setExecutionContext(HttpServletRequest request, HttpServletResponse response, ServletConfig config, ServletContext context) {
        try {
            ExecutionContext ec = (ExecutionContext)implementation.newInstance();
            ec.init(request, response, config, context);
            user.set(ec);
        }
        catch (Exception ex) {
            log.fatal("Failed to create an ExecutionContext", ex);
        }
    }

    public static void unset() {
        user.set(null);
    }

    protected static void setImplementation(Class singletonType) {
        implementation = singletonType;
    }
}

