/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.graph;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import javax.imageio.ImageIO;
import org.jrobin.core.RrdException;
import org.jrobin.graph.ChartGraphics;
import org.jrobin.graph.Comment;
import org.jrobin.graph.FetchSourceList;
import org.jrobin.graph.Gprint;
import org.jrobin.graph.GridRange;
import org.jrobin.graph.Legend;
import org.jrobin.graph.LegendMarker;
import org.jrobin.graph.PlotDef;
import org.jrobin.graph.RrdExporter;
import org.jrobin.graph.RrdGraph;
import org.jrobin.graph.RrdGraphDef;
import org.jrobin.graph.Source;
import org.jrobin.graph.TimeGrid;
import org.jrobin.graph.TimeMarker;
import org.jrobin.graph.Title;
import org.jrobin.graph.ValueFormatter;
import org.jrobin.graph.ValueGrid;
import org.jrobin.graph.ValueMarker;

class Grapher
extends RrdExporter {
    protected static final String SPACER = "  ";
    protected static final int GRAPH_RESOLUTION = 400;
    protected static final int DEFAULT_WIDTH = 400;
    protected static final int DEFAULT_HEIGHT = 100;
    protected static final int UBORDER_SPACE = 10;
    protected static final int BBORDER_SPACE = 10;
    protected static final int LBORDER_SPACE = 10;
    protected static final int RBORDER_SPACE = 13;
    protected static final int CHART_UPADDING = 5;
    protected static final int CHART_BPADDING = 25;
    protected static final int CHART_RPADDING = 10;
    protected static final int CHART_LPADDING = 50;
    protected static final int CHART_BPADDING_NM = 10;
    protected static final int CHART_LPADDING_NM = 10;
    protected static final int LINE_PADDING = 4;
    protected static final Font TITLE_FONT = new Font("Lucida Sans Typewriter", 1, 12);
    protected static final Font NORMAL_FONT = new Font("Lucida Sans Typewriter", 0, 10);
    private Font title_font = TITLE_FONT;
    private Font normal_font = NORMAL_FONT;
    private Color normalFontColor = null;
    private int numPoints = 400;
    private int chart_lpadding;
    private int chart_bpadding;
    private int imgWidth;
    private int imgHeight;
    private int chartWidth;
    private int chartHeight;
    private int nfont_width;
    private int nfont_height;
    private int tfont_width;
    private int tfont_height;
    private int commentBlock;
    private int graphOriginX;
    private int graphOriginY;
    private int x_offset;
    private int y_offset;
    private RrdGraphDef graphDef;
    private PlotDef[] plotDefs;
    private long[] tsChart;
    private ValueFormatter valueFormat;
    private BasicStroke defaultStroke;
    private ValueGrid vGrid;
    private TimeGrid tGrid;

    Grapher(RrdGraphDef graphDef, RrdGraph rrdGraph) {
        super(graphDef, rrdGraph);
        this.graphDef = graphDef;
        if (graphDef.getDefaultFont() != null) {
            this.normal_font = graphDef.getDefaultFont();
        }
        if (graphDef.getTitleFont() != null) {
            this.title_font = graphDef.getTitleFont();
        }
        this.normalFontColor = graphDef.getDefaultFontColor();
        this.nfont_height = this.normal_font.getSize();
        this.nfont_width = this.nfont_height / 2 + 1;
        this.tfont_height = this.title_font.isBold() ? this.title_font.getSize() + 2 : this.title_font.getSize();
        this.tfont_width = this.title_font.isBold() ? this.tfont_height / 2 : this.tfont_height / 2 + 1;
        this.valueFormat = new ValueFormatter(graphDef.getBaseValue(), graphDef.getScaleIndex());
        this.defaultStroke = new BasicStroke();
        this.startTime = graphDef.getStartTime();
        this.endTime = graphDef.getStartTime();
    }

    private void calculateDimensions(int cWidth, int cHeight) {
        this.chartWidth = cWidth == 0 ? 400 : cWidth;
        int n = this.chartHeight = cHeight == 0 ? 100 : cHeight;
        if (cWidth > 0) {
            this.numPoints = cWidth;
        }
        this.chart_lpadding = this.graphDef.showMajorGridY() ? this.graphDef.getChartLeftPadding() : 10;
        this.chart_bpadding = this.graphDef.showMajorGridX() ? 25 : 10;
        this.commentBlock = 0;
        if (this.graphDef.showLegend()) {
            this.commentBlock = this.graphDef.getCommentLineCount() * (this.nfont_height + 4) - 4;
        }
        this.x_offset = 10;
        if (this.graphDef.getVerticalLabel() != null) {
            this.x_offset += this.nfont_height + 4;
        }
        this.imgWidth = this.chartWidth + this.x_offset + 13 + this.chart_lpadding + 10;
        this.y_offset = 10;
        if (this.graphDef.getTitle() != null) {
            this.y_offset += (this.tfont_height + 4) * this.graphDef.getTitle().getLineCount() + this.tfont_height + 4;
        }
        this.imgHeight = this.chartHeight + this.commentBlock + this.y_offset + 10 + 5 + 25;
    }

    private void calculateDimensionsGlobal(int cWidth, int cHeight) {
        this.imgWidth = cWidth;
        this.imgHeight = cHeight;
        if (cWidth > 0) {
            this.numPoints = cWidth;
        }
        this.chart_lpadding = this.graphDef.showMajorGridY() ? this.graphDef.getChartLeftPadding() : 10;
        this.chart_bpadding = this.graphDef.showMajorGridX() ? 25 : 10;
        this.commentBlock = 0;
        if (this.graphDef.showLegend()) {
            this.commentBlock = this.graphDef.getCommentLineCount() * (this.nfont_height + 4) - 4;
        }
        this.x_offset = 10;
        if (this.graphDef.getVerticalLabel() != null) {
            this.x_offset += this.nfont_height + 4;
        }
        this.chartWidth = this.imgWidth - this.x_offset - 13 - this.chart_lpadding - 10;
        this.y_offset = 10;
        if (this.graphDef.getTitle() != null) {
            this.y_offset += (this.tfont_height + 4) * this.graphDef.getTitle().getLineCount() + this.tfont_height + 4;
        }
        this.chartHeight = this.imgHeight - this.commentBlock - this.y_offset - 10 - 5 - 25;
    }

    protected BufferedImage createImage(int cWidth, int cHeight, int colorType) throws RrdException, IOException {
        this.calculateDimensions(cWidth, cHeight);
        BufferedImage bImg = new BufferedImage(this.imgWidth, this.imgHeight, colorType);
        Graphics2D graphics = (Graphics2D)bImg.getGraphics();
        this.render(graphics);
        graphics.dispose();
        return bImg;
    }

    protected BufferedImage createImageGlobal(int cWidth, int cHeight, int colorType) throws RrdException, IOException {
        this.calculateDimensionsGlobal(cWidth, cHeight);
        BufferedImage bImg = new BufferedImage(this.imgWidth, this.imgHeight, colorType);
        Graphics2D graphics = (Graphics2D)bImg.getGraphics();
        this.render(graphics);
        graphics.dispose();
        return bImg;
    }

    protected void renderImage(int cWidth, int cHeight, Graphics2D graphics, boolean useGlobal) throws RrdException, IOException {
        if (useGlobal) {
            this.calculateDimensionsGlobal(cWidth, cHeight);
        } else {
            this.calculateDimensions(cWidth, cHeight);
        }
        this.render(graphics);
    }

    protected boolean shouldGenerate(long prevGenTime) throws RrdException, IOException {
        FetchSourceList fetchSources = this.graphDef.getFetchSources();
        fetchSources.setRrdOpener(this.getRrdOpener());
        fetchSources.openAll();
        if (this.graphDef.isLazy() && fetchSources.getLastUpdateTime() * 1000L < prevGenTime) {
            fetchSources.releaseAll();
            return false;
        }
        return true;
    }

    private void render(Graphics2D graphics) throws RrdException, IOException {
        this.calculateSeries();
        this.plotImageBackground(graphics);
        this.plotChart(graphics);
        this.plotComments(graphics);
        this.plotOverlay(graphics);
        this.plotSignature(graphics);
        graphics.dispose();
    }

    private void calculateSeries() throws RrdException, IOException {
        int i;
        super.calculateSeries(this.chartWidth);
        this.numPoints = this.numRows;
        this.tsChart = new long[this.chartWidth];
        this.plotDefs = this.graphDef.getPlotDefs();
        for (i = 0; i < this.plotDefs.length; ++i) {
            this.plotDefs[i].setSource(this.sources, this.sourceIndex);
            this.plotDefs[i].prepareValues(this.chartWidth);
        }
        for (i = 0; i < this.chartWidth; ++i) {
            long t = (long)((double)this.startTime + (double)i * ((double)(this.endTime - this.startTime) / (double)(this.chartWidth - 1)));
            for (int j = 0; j < this.plotDefs.length; ++j) {
                this.plotDefs[j].setValue(i, t, this.timestamps);
            }
            this.tsChart[i] = t;
        }
    }

    private void plotImageBackground(Graphics2D g) {
        g.setColor(this.graphDef.getBackColor());
        g.fillRect(0, 0, this.imgWidth, this.imgHeight);
        try {
            File bgImage = this.graphDef.getBackground();
            if (bgImage != null) {
                BufferedImage img = ImageIO.read(bgImage);
                g.drawRenderedImage(img, null);
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        Color bc = this.graphDef.getBorderColor();
        BasicStroke bs = this.graphDef.getBorderStroke();
        if (bs != null && bc != null) {
            g.setColor(bc);
            g.setStroke(bs);
            int w = new Float(bs.getLineWidth()).intValue();
            if (w > 0) {
                g.drawRect(w / 2, w / 2, this.imgWidth - w, this.imgHeight - w);
            }
            g.setStroke(this.defaultStroke);
        } else {
            g.setColor(new Color(220, 220, 220));
            g.fillRect(0, 0, 2, this.imgHeight - 1);
            g.fillRect(0, 0, this.imgWidth - 1, 2);
            g.setColor(Color.GRAY);
            g.drawLine(0, this.imgHeight - 1, this.imgWidth, this.imgHeight - 1);
            g.drawLine(this.imgWidth - 1, 0, this.imgWidth - 1, this.imgHeight);
            g.drawLine(1, this.imgHeight - 2, this.imgWidth, this.imgHeight - 2);
            g.drawLine(this.imgWidth - 2, 1, this.imgWidth - 2, this.imgHeight);
        }
        this.plotImageTitle(g);
        this.plotVerticalLabel(g);
    }

    private void plotChart(Graphics2D graphics) throws RrdException {
        int i;
        int lux = this.x_offset + this.chart_lpadding;
        int luy = this.y_offset + 5;
        if (this.graphDef.getBackground() == null) {
            graphics.setColor(this.graphDef.getCanvasColor());
            graphics.fillRect(lux, luy, this.chartWidth, this.chartHeight);
        }
        graphics.setColor(this.graphDef.getFrameColor());
        graphics.drawRect(lux, luy, this.chartWidth, this.chartHeight);
        double[] tmpSeries = new double[this.numPoints];
        boolean rigid = false;
        double lowerValue = Double.MAX_VALUE;
        double upperValue = Double.MIN_VALUE;
        GridRange range = this.graphDef.getGridRange();
        if (range != null) {
            rigid = range.isRigid();
            lowerValue = range.getLowerValue();
            upperValue = range.getUpperValue();
            if (Double.isNaN(lowerValue)) {
                lowerValue = Double.MAX_VALUE;
            }
            if (Double.isNaN(upperValue)) {
                upperValue = Double.MIN_VALUE;
            }
        }
        for (int i2 = 0; i2 < this.plotDefs.length; ++i2) {
            Source src = this.plotDefs[i2].getSource();
            if (rigid || src == null) continue;
            double min = src.getAggregate(0);
            double max = src.getAggregate(1);
            if (this.plotDefs[i2].plotType == 2 && i2 >= 1) {
                double val;
                int j;
                if (this.plotDefs[i2 - 1].plotType == 2) {
                    for (j = 0; j < tmpSeries.length; ++j) {
                        val = tmpSeries[j] + this.plotDefs[i2].getValue(j, this.timestamps);
                        if (val < lowerValue) {
                            lowerValue = val;
                        }
                        if (val > upperValue) {
                            upperValue = val;
                        }
                        tmpSeries[j] = val;
                    }
                    continue;
                }
                for (j = 0; j < tmpSeries.length; ++j) {
                    val = this.plotDefs[i2 - 1].getValue(j, this.timestamps) + this.plotDefs[i2].getValue(j, this.timestamps);
                    if (val < lowerValue) {
                        lowerValue = val;
                    }
                    if (val > upperValue) {
                        upperValue = val;
                    }
                    tmpSeries[j] = val;
                }
                continue;
            }
            if (min < lowerValue) {
                lowerValue = min;
            }
            if (!(max > upperValue)) continue;
            upperValue = max;
        }
        this.vGrid = new ValueGrid(range, lowerValue, upperValue, this.graphDef.getValueAxis(), this.graphDef.getBaseValue());
        this.tGrid = new TimeGrid(this.startTime, this.endTime, this.graphDef.getTimeAxis(), this.graphDef.getFirstDayOfWeek());
        lowerValue = this.vGrid.getLowerValue();
        upperValue = this.vGrid.getUpperValue();
        ChartGraphics g = new ChartGraphics(graphics);
        g.setDimensions(this.chartWidth, this.chartHeight);
        g.setXRange(this.tGrid.getStartTime(), this.tGrid.getEndTime());
        g.setYRange(lowerValue, upperValue);
        double diff = 1.0;
        if (lowerValue < 0.0) {
            diff = 1.0 - lowerValue / (-upperValue + lowerValue);
        }
        this.graphOriginX = lux;
        this.graphOriginY = new Double((double)luy + (double)this.chartHeight * diff).intValue();
        if (!this.graphDef.isFrontGrid()) {
            this.plotChartGrid(g);
        }
        if (this.graphDef.useAntiAliasing()) {
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        graphics.setClip(lux, luy, this.chartWidth, this.chartHeight);
        graphics.translate(this.graphOriginX, this.graphOriginY);
        int lastPlotType = 0;
        double[] parentSeries = new double[this.tsChart.length];
        int[] xValues = new int[this.tsChart.length];
        for (i = 0; i < this.tsChart.length; ++i) {
            xValues[i] = g.getX(this.tsChart[i]);
        }
        for (i = 0; i < this.plotDefs.length; ++i) {
            this.plotDefs[i].draw(g, xValues, parentSeries, lastPlotType);
            if (this.plotDefs[i].plotType == 2) continue;
            lastPlotType = this.plotDefs[i].plotType;
        }
        graphics.translate(-this.graphOriginX, -this.graphOriginY);
        graphics.setClip(0, 0, this.imgWidth, this.imgHeight);
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        if (this.graphDef.isFrontGrid()) {
            this.plotChartGrid(g);
        }
    }

    private void plotChartGrid(ChartGraphics chartGraph) {
        Graphics2D g = chartGraph.getGraphics();
        g.setFont(this.normal_font);
        int lux = this.x_offset + this.chart_lpadding;
        int luy = this.y_offset + 5;
        boolean minorX = this.graphDef.showMinorGridX();
        boolean minorY = this.graphDef.showMinorGridY();
        boolean majorX = this.graphDef.showMajorGridX();
        boolean majorY = this.graphDef.showMajorGridY();
        Color minColor = this.graphDef.getMinorGridColor();
        Color majColor = this.graphDef.getMajorGridColor();
        float[] dashPattern = new float[]{1.0f, 1.0f};
        BasicStroke dStroke = new BasicStroke(1.0f, 0, 0, 10.0f, dashPattern, 0.0f);
        int tmpx = lux + this.chartWidth;
        int tmpy = luy + this.chartHeight;
        g.setColor(this.graphDef.getAxisColor());
        g.drawLine(lux - 4, tmpy, tmpx + 4, tmpy);
        g.setColor(this.graphDef.getArrowColor());
        g.drawLine(tmpx + 4, tmpy - 3, tmpx + 4, tmpy + 3);
        g.drawLine(tmpx + 4, tmpy - 3, tmpx + 9, tmpy);
        g.drawLine(tmpx + 4, tmpy + 3, tmpx + 9, tmpy);
        if (this.graphDef.showGridX()) {
            TimeMarker[] timeList = this.tGrid.getTimeMarkers();
            boolean labelCentered = this.tGrid.centerLabels();
            long labelGridWidth = this.tGrid.getMajorGridWidth();
            int pixWidth = 0;
            if (labelCentered) {
                pixWidth = chartGraph.getX(labelGridWidth) - chartGraph.getX(0L);
            }
            for (int i = 0; i < timeList.length; ++i) {
                long secTime = timeList[i].getTimestamp();
                int posRel = chartGraph.getX(secTime);
                int pos = lux + posRel;
                String label = timeList[i].getLabel();
                if (posRel < 0) continue;
                if (majorX && timeList[i].isLabel()) {
                    g.setColor(majColor);
                    g.setStroke(dStroke);
                    g.drawLine(pos, luy, pos, luy + this.chartHeight);
                    g.setStroke(this.defaultStroke);
                    g.drawLine(pos, luy - 2, pos, luy + 2);
                    g.drawLine(pos, luy + this.chartHeight - 2, pos, luy + this.chartHeight + 2);
                    int txtDistance = label.length() * this.nfont_width / 2;
                    if (labelCentered) {
                        if (pos + pixWidth > lux + this.chartWidth) continue;
                        this.graphString(g, label, pos + 2 + pixWidth / 2 - txtDistance, luy + this.chartHeight + this.nfont_height + 4);
                        continue;
                    }
                    if (pos - lux <= txtDistance + 2 || pos + txtDistance + 2 >= lux + this.chartWidth) continue;
                    this.graphString(g, label, pos - txtDistance, luy + this.chartHeight + this.nfont_height + 4);
                    continue;
                }
                if (!minorX) continue;
                g.setColor(minColor);
                g.setStroke(dStroke);
                g.drawLine(pos, luy, pos, luy + this.chartHeight);
                g.setStroke(this.defaultStroke);
                g.drawLine(pos, luy - 1, pos, luy + 1);
                g.drawLine(pos, luy + this.chartHeight - 1, pos, luy + this.chartHeight + 1);
            }
        }
        this.valueFormat.setScaling(true, false);
        if (this.graphDef.showGridY()) {
            ValueMarker[] valueList = this.vGrid.getValueMarkers();
            for (int i = 0; i < valueList.length; ++i) {
                int valRel = chartGraph.getY(valueList[i].getValue());
                this.valueFormat.setFormat(valueList[i].getValue(), 2, 0);
                String label = (this.valueFormat.getScaledValue() + " " + this.valueFormat.getPrefix()).trim();
                if (majorY && valueList[i].isMajor()) {
                    g.setColor(majColor);
                    g.setStroke(dStroke);
                    g.drawLine(this.graphOriginX, this.graphOriginY - valRel, this.graphOriginX + this.chartWidth, this.graphOriginY - valRel);
                    g.setStroke(this.defaultStroke);
                    g.drawLine(this.graphOriginX - 2, this.graphOriginY - valRel, this.graphOriginX + 2, this.graphOriginY - valRel);
                    g.drawLine(this.graphOriginX + this.chartWidth - 2, this.graphOriginY - valRel, this.graphOriginX + this.chartWidth + 2, this.graphOriginY - valRel);
                    this.graphString(g, label, this.graphOriginX - label.length() * this.nfont_width - 7, this.graphOriginY - valRel + this.nfont_height / 2 - 1);
                    continue;
                }
                if (!minorY) continue;
                g.setColor(minColor);
                g.setStroke(dStroke);
                g.drawLine(this.graphOriginX, this.graphOriginY - valRel, this.graphOriginX + this.chartWidth, this.graphOriginY - valRel);
                g.setStroke(this.defaultStroke);
                g.drawLine(this.graphOriginX - 1, this.graphOriginY - valRel, this.graphOriginX + 1, this.graphOriginY - valRel);
                g.drawLine(this.graphOriginX + this.chartWidth - 1, this.graphOriginY - valRel, this.graphOriginX + this.chartWidth + 1, this.graphOriginY - valRel);
            }
        }
    }

    private void plotComments(Graphics2D g) throws RrdException {
        if (!this.graphDef.showLegend()) {
            return;
        }
        LinkedList<LegendMarker> markerList = new LinkedList<LegendMarker>();
        int posy = this.y_offset + this.chartHeight + 5 + 25 + (this.graphDef.showMajorGridX() ? this.nfont_height : 0);
        int posx = 10;
        g.setColor(this.normalFontColor);
        g.setFont(this.normal_font);
        Comment[] clist = this.graphDef.getComments();
        StringBuffer tmpStr = new StringBuffer("");
        boolean newLine = false;
        boolean drawText = false;
        for (int i = 0; i < clist.length; ++i) {
            if (clist[i].commentType == 1) {
                markerList.addLast(new LegendMarker(tmpStr.length() * this.nfont_width, ((Legend)clist[i]).getColor()));
                tmpStr.append("   ");
            } else if (clist[i].commentType == 2) {
                ((Gprint)clist[i]).setValue(this.sources, this.sourceIndex, this.valueFormat);
            }
            ArrayList tknpairs = clist[i].getTokens();
            for (int j = 0; j < tknpairs.size(); ++j) {
                String str = (String)tknpairs.get(j++);
                Byte tkn = (Byte)tknpairs.get(j);
                if (clist[i].trimString()) {
                    tmpStr.append(str.trim());
                } else {
                    tmpStr.append(str);
                }
                if (tkn != Comment.TKN_NULL) {
                    drawText = true;
                    if (tkn == Comment.TKN_ALF) {
                        newLine = true;
                        posx = 10;
                    } else if (tkn == Comment.TKN_ARF) {
                        newLine = true;
                        posx = this.imgWidth - 13 - tmpStr.length() * this.nfont_width;
                    } else if (tkn == Comment.TKN_ACF) {
                        newLine = true;
                        posx = this.imgWidth / 2 - tmpStr.length() * this.nfont_width / 2;
                    } else if (tkn == Comment.TKN_AL) {
                        posx = 10;
                    } else if (tkn == Comment.TKN_AR) {
                        posx = this.imgWidth - 13 - tmpStr.length() * this.nfont_width;
                    } else if (tkn == Comment.TKN_AC) {
                        posx = this.imgWidth / 2 - tmpStr.length() * this.nfont_width / 2;
                    }
                }
                if (!newLine && clist[i].addSpacer()) {
                    tmpStr.append(SPACER);
                }
                if (drawText) {
                    this.graphString(g, tmpStr.toString(), posx, posy);
                    tmpStr = new StringBuffer("");
                    drawText = false;
                    while (!markerList.isEmpty()) {
                        LegendMarker lm = (LegendMarker)markerList.removeFirst();
                        g.setColor(lm.getColor());
                        g.fillRect(posx + lm.getXPosition(), posy - 9, 10, 10);
                        g.setColor(this.normalFontColor);
                        g.drawRect(posx + lm.getXPosition(), posy - 9, 10, 10);
                    }
                }
                if (!newLine) continue;
                posy += this.nfont_height + 4;
                newLine = false;
            }
        }
        if (tmpStr.length() > 0) {
            posx = 10;
            this.graphString(g, tmpStr.toString(), posx, posy);
            tmpStr = new StringBuffer("");
            drawText = false;
            while (!markerList.isEmpty()) {
                LegendMarker lm = (LegendMarker)markerList.removeFirst();
                g.setColor(lm.getColor());
                g.fillRect(posx + lm.getXPosition(), posy - 9, 10, 10);
                g.setColor(this.normalFontColor);
                g.drawRect(posx + lm.getXPosition(), posy - 9, 10, 10);
            }
        }
    }

    private void plotOverlay(Graphics2D g) {
        try {
            File overlayImg = this.graphDef.getOverlay();
            if (overlayImg != null) {
                BufferedImage img = ImageIO.read(overlayImg);
                int w = img.getWidth();
                int h = img.getHeight();
                int rgbWhite = Color.WHITE.getRGB();
                for (int i = 0; i < w; ++i) {
                    for (int j = 0; j < h; ++j) {
                        int pcolor = img.getRGB(i, j);
                        if (pcolor == rgbWhite) continue;
                        int red = pcolor >> 16 & 0xFF;
                        int green = pcolor >> 8 & 0xFF;
                        int blue = pcolor & 0xFF;
                        g.setColor(new Color(red, green, blue));
                        g.drawLine(i, j, i, j);
                    }
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void plotImageTitle(Graphics2D g) {
        Title graphTitle = this.graphDef.getTitle();
        if (graphTitle == null) {
            return;
        }
        int posy = this.tfont_height - 1 + 10;
        int posx = 10;
        g.setColor(this.graphDef.getTitleFontColor());
        g.setFont(this.title_font);
        StringBuffer tmpStr = new StringBuffer("");
        boolean newLine = false;
        ArrayList tknpairs = graphTitle.getTokens();
        for (int j = 0; j < tknpairs.size(); ++j) {
            String str = (String)tknpairs.get(j++);
            Byte tkn = (Byte)tknpairs.get(j);
            tmpStr.append(str);
            if (tkn != Comment.TKN_NULL) {
                if (tkn == Comment.TKN_ALF) {
                    newLine = true;
                    posx = 10;
                } else if (tkn == Comment.TKN_ARF) {
                    newLine = true;
                    posx = this.imgWidth - 13 - tmpStr.length() * this.tfont_width - this.tfont_width;
                } else if (tkn == Comment.TKN_ACF) {
                    newLine = true;
                    posx = this.imgWidth / 2 - tmpStr.length() * this.tfont_width / 2;
                } else if (tkn == Comment.TKN_AL) {
                    posx = 10;
                } else if (tkn == Comment.TKN_AR) {
                    posx = this.imgWidth - 13 - tmpStr.length() * this.tfont_width - this.tfont_width;
                } else if (tkn == Comment.TKN_AC) {
                    posx = this.imgWidth / 2 - tmpStr.length() * this.tfont_width / 2;
                }
            } else {
                posx = this.imgWidth / 2 - tmpStr.length() * this.tfont_width / 2;
            }
            g.drawString(tmpStr.toString(), posx, posy);
            tmpStr = new StringBuffer("");
            if (!newLine) continue;
            posy += this.tfont_height + 4;
            newLine = false;
        }
    }

    private void plotVerticalLabel(Graphics2D g) {
        String valueAxisLabel = this.graphDef.getVerticalLabel();
        if (valueAxisLabel == null) {
            return;
        }
        g.setColor(this.normalFontColor);
        int labelWidth = valueAxisLabel.length() * this.nfont_width;
        g.setFont(this.normal_font);
        g.rotate(-1.5707963267948966);
        this.graphString(g, valueAxisLabel, -this.y_offset - 5 - this.chartHeight / 2 - labelWidth / 2, 10 + this.nfont_height);
        g.rotate(1.5707963267948966);
    }

    private void plotSignature(Graphics2D g) {
        if (!this.graphDef.showSignature()) {
            return;
        }
        String sig = "www.jrobin.org";
        g.setColor(Color.GRAY);
        g.setFont(new Font("Courier", 0, 10));
        g.rotate(1.5707963267948966);
        g.drawString(sig, 5, -this.imgWidth + 9);
        g.rotate(-1.5707963267948966);
    }

    private void graphString(Graphics2D g, String str, int x, int y) {
        Color oc = g.getColor();
        g.setColor(this.normalFontColor);
        g.drawString(str, x, y);
        g.setColor(oc);
    }
}

