/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.graph;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import org.jrobin.core.RrdDataSet;
import org.jrobin.core.RrdException;
import org.jrobin.core.Util;
import org.jrobin.graph.Def;
import org.jrobin.graph.Print;
import org.jrobin.graph.Source;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ExportData
implements RrdDataSet {
    private int arraySize;
    private long[] timestamps;
    private HashMap sourceByName;
    private HashMap legends;
    private Source[] sources;
    private Print printer;

    ExportData() {
        this.sourceByName = new HashMap();
        this.legends = new HashMap();
    }

    ExportData(long[] timestamps, Source[] sources, HashMap legends) {
        this.timestamps = timestamps;
        this.sources = sources;
        this.legends = legends;
        this.arraySize = timestamps.length;
        this.sourceByName = new HashMap(sources.length);
        for (int i = 0; i < sources.length; ++i) {
            this.sourceByName.put(sources[i].getName(), sources[i]);
        }
    }

    public ExportData(String xportXml) throws RrdException, IOException {
        this();
        this.importXml(xportXml);
    }

    public ExportData(String xportXml, boolean useLegendNames) throws RrdException, IOException {
        this();
        this.importXml(xportXml, useLegendNames);
    }

    public ExportData(String xportXml, String dsNamePrefix) throws RrdException, IOException {
        this();
        this.importXml(xportXml, dsNamePrefix);
    }

    public ExportData(File xmlFile) throws RrdException, IOException {
        this();
        this.importXml(xmlFile);
    }

    public ExportData(File xmlFile, boolean useLegendNames) throws RrdException, IOException {
        this();
        this.importXml(xmlFile, useLegendNames);
    }

    public ExportData(File xmlFile, String dsNamePrefix) throws RrdException, IOException {
        this();
        this.importXml(xmlFile, dsNamePrefix);
    }

    public int getRowCount() {
        return this.sources.length;
    }

    public int getColumnCount() {
        return this.arraySize;
    }

    public long[] getTimestamps() {
        return this.timestamps;
    }

    public long getStep() {
        return this.timestamps[1] - this.timestamps[0];
    }

    public double[] getValues(int dsIndex) {
        return this.sources[dsIndex].getValues();
    }

    public double[][] getValues() {
        double[][] values = new double[this.sources.length][this.arraySize];
        for (int i = 0; i < this.sources.length; ++i) {
            values[i] = this.sources[i].getValues();
        }
        return values;
    }

    public double[] getValues(String dsName) throws RrdException {
        Source src = this.getSource(dsName);
        return src.getValues();
    }

    public long getFirstTimestamp() {
        return this.timestamps[0];
    }

    public long getLastTimestamp() {
        return this.timestamps[this.arraySize - 1];
    }

    public String[] getDsNames() {
        String[] names = new String[this.sources.length];
        for (int i = 0; i < this.sources.length; ++i) {
            names[i] = this.sources[i].getName();
        }
        return names;
    }

    public int getDsIndex(String dsName) throws RrdException {
        for (int i = 0; i < this.sources.length; ++i) {
            if (!this.sources[i].getName().equals(dsName)) continue;
            return i;
        }
        throw new RrdException("No such datasource: " + dsName);
    }

    public double getAggregate(String dsName, String consolFun) throws RrdException {
        Source src = this.getSource(dsName);
        if (consolFun.equalsIgnoreCase("MAX")) {
            return src.getAggregate(1);
        }
        if (consolFun.equalsIgnoreCase("MIN")) {
            return src.getAggregate(0);
        }
        if (consolFun.equalsIgnoreCase("LAST")) {
            return src.getAggregate(4);
        }
        if (consolFun.equalsIgnoreCase("FIRST")) {
            return src.getAggregate(3);
        }
        if (consolFun.equalsIgnoreCase("TOTAL")) {
            return src.getAggregate(5);
        }
        if (consolFun.equalsIgnoreCase("AVERAGE")) {
            return src.getAggregate(2);
        }
        throw new RrdException("Unsupported consolidation function [" + consolFun + "]");
    }

    public String print(String sourceName, String consolFun, String format) throws RrdException {
        return this.print(sourceName, consolFun, format, 1000.0);
    }

    public String print(String sourceName, String consolFun, String format, double base) throws RrdException {
        double value = this.getAggregate(sourceName, consolFun);
        if (this.printer == null) {
            this.printer = new Print(base, -1);
        }
        return this.printer.getFormattedString(value, format, base);
    }

    public void importXml(String xportXml) throws RrdException, IOException {
        this.importXml(xportXml, true);
    }

    public void importXml(File xmlFile) throws RrdException, IOException {
        this.importXml(xmlFile, true);
    }

    public void importXml(File xmlFile, boolean useLegendNames) throws RrdException, IOException {
        Element root = Util.Xml.getRootElement(xmlFile);
        this.importXml(root, useLegendNames, "d");
    }

    public void importXml(String xportXml, String dsNamePrefix) throws RrdException, IOException {
        Element root = Util.Xml.getRootElement(xportXml);
        this.importXml(root, false, dsNamePrefix);
    }

    public void importXml(File xmlFile, String dsNamePrefix) throws RrdException, IOException {
        Element root = Util.Xml.getRootElement(xmlFile);
        this.importXml(root, false, dsNamePrefix);
    }

    public void importXml(String xportXml, boolean useLegendNames) throws RrdException, IOException {
        Element root = Util.Xml.getRootElement(xportXml);
        this.importXml(root, useLegendNames, "d");
    }

    public void exportXml(OutputStream outputStream) throws RrdException, IOException {
        PrintWriter pw = new PrintWriter(outputStream);
        pw.write(this.exportXml());
        pw.flush();
    }

    public void exportXml(String filepath) throws RrdException, IOException {
        FileWriter fw = new FileWriter(filepath);
        fw.write(this.exportXml());
        fw.close();
    }

    public String exportXml() throws RrdException, IOException {
        int i;
        StringBuffer xml = new StringBuffer("<xport>\n");
        xml.append("\t<meta>\n");
        xml.append("\t\t<start>" + this.timestamps[0] + "</start>\n");
        xml.append("\t\t<step>" + (this.timestamps[1] - this.timestamps[0]) + "</step>\n");
        xml.append("\t\t<end>" + this.timestamps[this.arraySize - 1] + "</end>\n");
        xml.append("\t\t<rows>" + this.arraySize + "</rows>\n");
        xml.append("\t\t<columns>" + this.sources.length + "</columns>\n");
        xml.append("\t\t<legend>\n");
        for (i = 0; i < this.sources.length; ++i) {
            xml.append("\t\t\t<entry>" + this.getExportLegend(this.sources[i].getName()) + "</entry>\n");
        }
        xml.append("\t\t</legend>\n");
        xml.append("\t</meta>\n");
        xml.append("\t<data>\n");
        for (i = 0; i < this.arraySize; ++i) {
            xml.append("\t\t<row>");
            xml.append("<t>" + this.timestamps[i] + "</t>");
            for (int j = 0; j < this.sources.length; ++j) {
                xml.append("<v>" + this.sources[j].get(i) + "</v>");
            }
            xml.append("</row>\n");
        }
        xml.append("\t</data>\n");
        xml.append("</xport>\n");
        return xml.toString();
    }

    protected Source[] getSources() {
        return this.sources;
    }

    private String getExportLegend(String name) {
        if (!this.legends.containsKey(name)) {
            return "";
        }
        return (String)this.legends.get(name);
    }

    private Source getSource(String name) throws RrdException {
        if (!this.sourceByName.containsKey(name)) {
            throw new RrdException("No such datasource: " + name);
        }
        return (Source)this.sourceByName.get(name);
    }

    private void importXml(Element root, boolean useLegendNames, String dsNamePrefix) throws RrdException {
        int i;
        Node meta = Util.Xml.getFirstChildNode(root, "meta");
        Node[] dataRows = Util.Xml.getChildNodes(Util.Xml.getFirstChildNode(root, "data"), "row");
        this.sourceByName.clear();
        this.legends.clear();
        int columns = Util.Xml.getChildValueAsInt(meta, "columns");
        long step = Util.Xml.getChildValueAsLong(meta, "step");
        String[] dsNames = new String[columns];
        Node[] legendNodes = Util.Xml.getChildNodes(Util.Xml.getFirstChildNode(meta, "legend"), "entry");
        for (i = 0; i < legendNodes.length; ++i) {
            String legend = Util.Xml.getValue(legendNodes[i]);
            dsNames[i] = useLegendNames ? legend : dsNamePrefix + (i + 1);
            this.legends.put(dsNames[i], legend);
        }
        this.timestamps = new long[dataRows.length];
        this.sources = new Source[columns];
        this.arraySize = this.timestamps.length;
        for (i = 0; i < this.sources.length; ++i) {
            this.sources[i] = new Def(dsNames[i], this.arraySize, this.arraySize);
            this.sources[i].setFetchedStep(step);
        }
        for (i = 0; i < dataRows.length; ++i) {
            this.timestamps[i] = Util.Xml.getChildValueAsLong(dataRows[i], "t");
            Node[] data = Util.Xml.getChildNodes(dataRows[i], "v");
            for (int j = 0; j < data.length; ++j) {
                this.sources[j].set(i, this.timestamps[i], Util.Xml.getValueAsDouble(data[j]));
            }
        }
        for (i = 0; i < this.sources.length; ++i) {
            this.sourceByName.put(this.sources[i].getName(), this.sources[i]);
        }
    }
}

