/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.graph;

import java.awt.Color;
import java.util.HashMap;
import org.jrobin.core.RrdException;
import org.jrobin.core.XmlWriter;
import org.jrobin.graph.ChartGraphics;
import org.jrobin.graph.PlotDef;
import org.jrobin.graph.Source;

class CustomArea
extends PlotDef {
    private long xVal1;
    private long xVal2;
    private double yVal1;
    private double yVal2;

    CustomArea(long startTime, double startValue, long endTime, double endValue, Color color) {
        this.color = color;
        if (color == null) {
            this.visible = false;
        }
        this.xVal1 = startTime;
        this.xVal2 = endTime;
        this.yVal1 = startValue;
        this.yVal2 = endValue;
    }

    void draw(ChartGraphics g, int[] xValues, double[] stackValues, int lastPlotType) throws RrdException {
        g.setColor(this.color);
        int ax = this.xVal1 == Long.MIN_VALUE ? g.getMinX() : (this.xVal1 == Long.MAX_VALUE ? g.getMaxX() : g.getX(this.xVal1));
        int nx = this.xVal2 == Long.MIN_VALUE ? g.getMinX() : (this.xVal2 == Long.MAX_VALUE ? g.getMaxX() : g.getX(this.xVal2));
        int ay = this.yVal1 == Double.MIN_VALUE ? g.getMinY() : (this.yVal1 == Double.MAX_VALUE ? g.getMaxY() : g.getY(this.yVal1));
        int ny = this.yVal2 == Double.MIN_VALUE ? g.getMinY() : (this.yVal2 == Double.MAX_VALUE ? g.getMaxY() : g.getY(this.yVal2));
        if (this.visible) {
            if (ny > ay) {
                g.fillRect(ax, ay, nx, ny);
            } else {
                g.fillRect(ax, ny, nx, ay);
            }
        }
        if (this.yVal2 != Double.MAX_VALUE) {
            for (int i = 0; i < stackValues.length; ++i) {
                stackValues[i] = xValues[i] < ax || xValues[i] > nx ? g.getInverseY(0) : g.getInverseY(ny);
            }
        }
    }

    double getValue(int tblPos, long[] timestamps) {
        long time = timestamps[tblPos];
        if (time > this.xVal2 || time < this.xVal1) {
            return Double.NaN;
        }
        if (this.yVal2 == Double.MAX_VALUE) {
            return Double.NaN;
        }
        return this.yVal2;
    }

    void setSource(Source[] sources, HashMap sourceIndex) throws RrdException {
    }

    void setValue(int tableRow, long preciseTime, long[] reducedTimestamps) {
    }

    void exportXmlTemplate(XmlWriter xml, String legend) {
        xml.startTag("area");
        xml.writeTag("time1", this.xVal1);
        xml.writeTag("value1", this.yVal1);
        xml.writeTag("time2", this.xVal2);
        xml.writeTag("value2", this.yVal2);
        xml.writeTag("color", this.color);
        xml.writeTag("legend", legend);
        xml.closeTag();
    }
}

