/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.graph;

import java.awt.Color;
import org.jrobin.core.XmlWriter;
import org.jrobin.graph.ChartGraphics;
import org.jrobin.graph.PlotDef;
import org.jrobin.graph.Source;

class Area
extends PlotDef {
    Area(String sourceName, Color color) {
        super(sourceName, color);
        this.plotType = 1;
    }

    Area(Source source, double[] values, Color color, boolean stacked, boolean visible) {
        super(source, values, color, stacked, visible);
    }

    void draw(ChartGraphics g, int[] xValues, double[] stackValues, int lastPlotType) {
        g.setColor(this.color);
        int len = this.values.length;
        int ax = 0;
        int ay = 0;
        int nx = 0;
        int ny = 0;
        for (int i = 0; i < len; ++i) {
            int py = 0;
            nx = xValues[i];
            double value = this.values[i];
            if (!Double.isNaN(value)) {
                if (this.stacked) {
                    py = g.getY(stackValues[i]);
                    value += stackValues[i];
                }
                ny = g.getY(value);
                if (this.visible) {
                    if (nx > ax + 1) {
                        int co = (ny - ay) / (nx - ax);
                        int j = ax > 0 ? ax : 1;
                        for (j = ax; j <= nx; ++j) {
                            if (ay == Integer.MIN_VALUE || ny == Integer.MIN_VALUE) continue;
                            g.drawLine(j, py, j, co * (j - ax) + ay);
                        }
                    } else if (nx != 0 && py != Integer.MIN_VALUE && ny != Integer.MIN_VALUE) {
                        g.drawLine(nx, py, nx, ny);
                    }
                }
            }
            stackValues[i] = value;
            ax = nx;
            ay = ny;
        }
    }

    void exportXmlTemplate(XmlWriter xml, String legend) {
        xml.startTag("area");
        xml.writeTag("datasource", this.sourceName);
        xml.writeTag("color", this.color);
        xml.writeTag("legend", legend);
        xml.closeTag();
    }
}

