/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.core;

import java.io.IOException;
import java.util.StringTokenizer;
import org.jrobin.core.RrdDb;
import org.jrobin.core.RrdException;
import org.jrobin.core.Util;

public class Sample {
    private RrdDb parentDb;
    private long time;
    private String[] dsNames;
    private double[] values;

    Sample(RrdDb parentDb, long time) throws IOException {
        this.parentDb = parentDb;
        this.time = time;
        this.dsNames = parentDb.getDsNames();
        this.values = new double[this.dsNames.length];
        this.clearCurrentValues();
    }

    private void clearCurrentValues() {
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = Double.NaN;
        }
    }

    public void setValue(String dsName, double value) throws RrdException {
        for (int i = 0; i < this.values.length; ++i) {
            if (!this.dsNames[i].equals(dsName)) continue;
            this.values[i] = value;
            return;
        }
        throw new RrdException("Datasource " + dsName + " not found");
    }

    public void setValue(int i, double value) throws RrdException {
        if (i < this.values.length) {
            this.values[i] = value;
            return;
        }
        throw new RrdException("Sample datasource index " + i + " out of bounds");
    }

    public void setValues(double[] values) throws RrdException {
        if (values.length <= this.values.length) {
            for (int i = 0; i < values.length; ++i) {
                this.values[i] = values[i];
            }
        } else {
            throw new RrdException("Invalid number of values specified (found " + values.length + ", only " + this.dsNames.length + " allowed)");
        }
    }

    public double[] getValues() {
        return this.values;
    }

    public long getTime() {
        return this.time;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public String[] getDsNames() {
        return this.dsNames;
    }

    public void set(String timeAndValues) throws RrdException {
        StringTokenizer tokenizer = new StringTokenizer(timeAndValues, ":", false);
        int n = tokenizer.countTokens();
        if (n > this.values.length + 1) {
            throw new RrdException("Invalid number of values specified (found " + this.values.length + ", " + this.dsNames.length + " allowed)");
        }
        String timeToken = tokenizer.nextToken();
        try {
            this.time = Long.parseLong(timeToken);
        }
        catch (NumberFormatException nfe) {
            if (timeToken.equalsIgnoreCase("N") || timeToken.equalsIgnoreCase("NOW")) {
                this.time = Util.getTime();
            }
            throw new RrdException("Invalid sample timestamp: " + timeToken);
        }
        int i = 0;
        while (tokenizer.hasMoreTokens()) {
            try {
                this.values[i] = Double.parseDouble(tokenizer.nextToken());
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            ++i;
        }
    }

    public void update() throws IOException, RrdException {
        this.parentDb.store(this);
        this.clearCurrentValues();
    }

    public void setAndUpdate(String timeAndValues) throws IOException, RrdException {
        this.set(timeAndValues);
        this.update();
    }

    public String dump() {
        StringBuffer buffer = new StringBuffer("update \"");
        buffer.append(this.parentDb.getRrdBackend().getPath() + "\" " + this.time);
        for (int i = 0; i < this.values.length; ++i) {
            buffer.append(":");
            buffer.append(Util.formatDouble(this.values[i], "U", false));
        }
        return buffer.toString();
    }

    String getRrdToolCommand() {
        return this.dump();
    }
}

