/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.core;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.jrobin.core.ArcDef;
import org.jrobin.core.Archive;
import org.jrobin.core.DataImporter;
import org.jrobin.core.Datasource;
import org.jrobin.core.DsDef;
import org.jrobin.core.FetchData;
import org.jrobin.core.FetchPoint;
import org.jrobin.core.FetchRequest;
import org.jrobin.core.Header;
import org.jrobin.core.RrdAllocator;
import org.jrobin.core.RrdBackend;
import org.jrobin.core.RrdBackendFactory;
import org.jrobin.core.RrdDef;
import org.jrobin.core.RrdException;
import org.jrobin.core.RrdFileBackend;
import org.jrobin.core.RrdFileBackendFactory;
import org.jrobin.core.RrdToolReader;
import org.jrobin.core.RrdUpdater;
import org.jrobin.core.Sample;
import org.jrobin.core.Util;
import org.jrobin.core.XmlReader;
import org.jrobin.core.XmlWriter;

public class RrdDb
implements RrdUpdater {
    public static final int NO_LOCKS = 0;
    public static final int WAIT_IF_LOCKED = 1;
    public static final int EXCEPTION_IF_LOCKED = 2;
    static final int XML_INITIAL_BUFFER_CAPACITY = 100000;
    private static int lockMode = 0;
    private RrdBackend backend;
    private RrdAllocator allocator = new RrdAllocator();
    private Header header;
    private Datasource[] datasources;
    private Archive[] archives;
    private boolean closed = false;

    public RrdDb(RrdDef rrdDef) throws RrdException, IOException {
        this(rrdDef, RrdFileBackendFactory.getDefaultFactory());
    }

    public RrdDb(RrdDef rrdDef, RrdBackendFactory factory) throws RrdException, IOException {
        rrdDef.validate();
        String path = rrdDef.getPath();
        this.backend = factory.open(path, false, lockMode);
        this.backend.setLength(rrdDef.getEstimatedSize());
        this.header = new Header(this, rrdDef);
        DsDef[] dsDefs = rrdDef.getDsDefs();
        this.datasources = new Datasource[dsDefs.length];
        for (int i = 0; i < dsDefs.length; ++i) {
            this.datasources[i] = new Datasource(this, dsDefs[i]);
        }
        ArcDef[] arcDefs = rrdDef.getArcDefs();
        this.archives = new Archive[arcDefs.length];
        for (int i = 0; i < arcDefs.length; ++i) {
            this.archives[i] = new Archive(this, arcDefs[i]);
        }
        this.backend.afterCreate();
    }

    public RrdDb(String path, boolean readOnly) throws IOException, RrdException {
        this(path, readOnly, RrdBackendFactory.getDefaultFactory());
    }

    public RrdDb(String path, boolean readOnly, RrdBackendFactory factory) throws IOException, RrdException {
        if (!factory.exists(path)) {
            throw new IOException("Could not open " + path + " [non existent]");
        }
        this.backend = factory.open(path, readOnly, lockMode);
        this.header = new Header(this, (RrdDef)null);
        this.header.validateHeader();
        int dsCount = this.header.getDsCount();
        this.datasources = new Datasource[dsCount];
        for (int i = 0; i < dsCount; ++i) {
            this.datasources[i] = new Datasource(this, null);
        }
        int arcCount = this.header.getArcCount();
        this.archives = new Archive[arcCount];
        for (int i = 0; i < arcCount; ++i) {
            this.archives[i] = new Archive(this, null);
        }
    }

    public RrdDb(String path) throws IOException, RrdException {
        this(path, false);
    }

    public RrdDb(String path, RrdBackendFactory factory) throws IOException, RrdException {
        this(path, false, factory);
    }

    public RrdDb(String rrdPath, String xmlPath) throws IOException, RrdException {
        this(rrdPath, xmlPath, RrdBackendFactory.getDefaultFactory());
    }

    public RrdDb(String rrdPath, String xmlPath, RrdBackendFactory factory) throws IOException, RrdException {
        int i;
        DataImporter reader;
        this.backend = factory.open(rrdPath, false, lockMode);
        if (xmlPath.startsWith("rrdtool:/")) {
            String rrdToolPath = xmlPath.substring("rrdtool:/".length());
            reader = new RrdToolReader(rrdToolPath);
        } else if (xmlPath.startsWith("xml:/")) {
            xmlPath = xmlPath.substring("xml:/".length());
            reader = new XmlReader(xmlPath);
        } else {
            reader = new XmlReader(xmlPath);
        }
        this.backend.setLength(reader.getEstimatedSize());
        this.header = new Header(this, reader);
        this.datasources = new Datasource[reader.getDsCount()];
        for (i = 0; i < this.datasources.length; ++i) {
            this.datasources[i] = new Datasource(this, reader, i);
        }
        this.archives = new Archive[reader.getArcCount()];
        for (i = 0; i < this.archives.length; ++i) {
            this.archives[i] = new Archive(this, reader, i);
        }
        reader.release();
        reader = null;
        this.backend.afterCreate();
    }

    public synchronized void close() throws IOException {
        if (!this.closed) {
            this.backend.close();
            this.closed = true;
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public Header getHeader() {
        return this.header;
    }

    public Datasource getDatasource(int dsIndex) {
        return this.datasources[dsIndex];
    }

    public Archive getArchive(int arcIndex) {
        return this.archives[arcIndex];
    }

    public String[] getDsNames() throws IOException {
        int n = this.datasources.length;
        String[] dsNames = new String[n];
        for (int i = 0; i < n; ++i) {
            dsNames[i] = this.datasources[i].getDsName();
        }
        return dsNames;
    }

    public Sample createSample(long time) throws IOException {
        return new Sample(this, time);
    }

    public Sample createSample() throws IOException {
        return this.createSample(Util.getTime());
    }

    public FetchRequest createFetchRequest(String consolFun, long fetchStart, long fetchEnd, long resolution) throws RrdException {
        return new FetchRequest(this, consolFun, fetchStart, fetchEnd, resolution);
    }

    public FetchRequest createFetchRequest(String consolFun, long fetchStart, long fetchEnd) throws RrdException {
        return this.createFetchRequest(consolFun, fetchStart, fetchEnd, 1L);
    }

    synchronized void store(Sample sample) throws IOException, RrdException {
        if (this.closed) {
            throw new RrdException("RRD already closed, cannot store this  sample");
        }
        this.backend.beforeUpdate();
        long newTime = sample.getTime();
        long lastTime = this.header.getLastUpdateTime();
        if (lastTime >= newTime) {
            throw new RrdException("Bad sample timestamp " + newTime + ". Last update time was " + lastTime + ", at least one second step is required");
        }
        double[] newValues = sample.getValues();
        for (int i = 0; i < this.datasources.length; ++i) {
            double newValue = newValues[i];
            this.datasources[i].process(newTime, newValue);
        }
        this.header.setLastUpdateTime(newTime);
        this.backend.afterUpdate();
    }

    synchronized FetchPoint[] fetch(FetchRequest request) throws IOException, RrdException {
        if (this.closed) {
            throw new RrdException("RRD already closed, cannot fetch data");
        }
        this.backend.beforeFetch();
        Archive archive = this.findMatchingArchive(request);
        FetchPoint[] points = archive.fetch(request);
        this.backend.afterFetch();
        return points;
    }

    synchronized FetchData fetchData(FetchRequest request) throws IOException, RrdException {
        if (this.closed) {
            throw new RrdException("RRD already closed, cannot fetch data");
        }
        this.backend.beforeFetch();
        Archive archive = this.findMatchingArchive(request);
        FetchData fetchData = archive.fetchData(request);
        this.backend.afterFetch();
        return fetchData;
    }

    public Archive findMatchingArchive(FetchRequest request) throws RrdException, IOException {
        String consolFun = request.getConsolFun();
        long fetchStart = request.getFetchStart();
        long fetchEnd = request.getFetchEnd();
        long resolution = request.getResolution();
        Archive bestFullMatch = null;
        Archive bestPartialMatch = null;
        long bestStepDiff = 0L;
        long bestMatch = 0L;
        for (int i = 0; i < this.archives.length; ++i) {
            if (!this.archives[i].getConsolFun().equals(consolFun)) continue;
            long arcStep = this.archives[i].getArcStep();
            long arcStart = this.archives[i].getStartTime() - arcStep;
            long arcEnd = this.archives[i].getEndTime();
            long fullMatch = fetchEnd - fetchStart;
            if (arcEnd >= fetchEnd && arcStart <= fetchStart) {
                long tmpStepDiff = Math.abs(this.archives[i].getArcStep() - resolution);
                if (tmpStepDiff >= bestStepDiff && bestFullMatch != null) continue;
                bestStepDiff = tmpStepDiff;
                bestFullMatch = this.archives[i];
                continue;
            }
            long tmpMatch = fullMatch;
            if (arcStart > fetchStart) {
                tmpMatch -= arcStart - fetchStart;
            }
            if (arcEnd < fetchEnd) {
                tmpMatch -= fetchEnd - arcEnd;
            }
            if (bestPartialMatch != null && bestMatch >= tmpMatch) continue;
            bestPartialMatch = this.archives[i];
            bestMatch = tmpMatch;
        }
        if (bestFullMatch != null) {
            return bestFullMatch;
        }
        if (bestPartialMatch != null) {
            return bestPartialMatch;
        }
        throw new RrdException("RRD file does not contain RRA:" + consolFun + " archive");
    }

    public Archive findStartMatchArchive(String consolFun, long startTime, long resolution) throws IOException {
        int fallBackIndex = 0;
        int arcIndex = -1;
        long minDiff = Long.MAX_VALUE;
        long fallBackDiff = Long.MAX_VALUE;
        for (int i = 0; i < this.archives.length; ++i) {
            if (!this.archives[i].getConsolFun().equals(consolFun)) continue;
            long arcStep = this.archives[i].getArcStep();
            long diff = Math.abs(resolution - arcStep);
            if (startTime >= this.archives[i].getStartTime()) {
                if (diff == 0L) {
                    return this.archives[i];
                }
                if (diff >= minDiff) continue;
                minDiff = diff;
                arcIndex = i;
                continue;
            }
            if (diff >= fallBackDiff) continue;
            fallBackDiff = diff;
            fallBackIndex = i;
        }
        return arcIndex >= 0 ? this.archives[arcIndex] : this.archives[fallBackIndex];
    }

    public synchronized String dump() throws IOException {
        int i;
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.header.dump());
        for (i = 0; i < this.datasources.length; ++i) {
            buffer.append(this.datasources[i].dump());
        }
        for (i = 0; i < this.archives.length; ++i) {
            buffer.append(this.archives[i].dump());
        }
        return buffer.toString();
    }

    void archive(Datasource datasource, double value, long numUpdates) throws IOException, RrdException {
        int dsIndex = this.getDsIndex(datasource.getDsName());
        for (int i = 0; i < this.archives.length; ++i) {
            this.archives[i].archive(dsIndex, value, numUpdates);
        }
    }

    public int getDsIndex(String dsName) throws RrdException, IOException {
        for (int i = 0; i < this.datasources.length; ++i) {
            if (!this.datasources[i].getDsName().equals(dsName)) continue;
            return i;
        }
        throw new RrdException("Unknown datasource name: " + dsName);
    }

    Datasource[] getDatasources() {
        return this.datasources;
    }

    Archive[] getArchives() {
        return this.archives;
    }

    public synchronized void dumpXml(OutputStream destination) throws IOException {
        int i;
        XmlWriter writer = new XmlWriter(destination);
        writer.startTag("rrd");
        this.header.appendXml(writer);
        for (i = 0; i < this.datasources.length; ++i) {
            this.datasources[i].appendXml(writer);
        }
        for (i = 0; i < this.archives.length; ++i) {
            this.archives[i].appendXml(writer);
        }
        writer.closeTag();
        writer.flush();
    }

    public synchronized void exportXml(OutputStream destination) throws IOException {
        this.dumpXml(destination);
    }

    public synchronized String getXml() throws IOException, RrdException {
        ByteArrayOutputStream destination = new ByteArrayOutputStream(100000);
        this.dumpXml(destination);
        return destination.toString();
    }

    public synchronized String exportXml() throws IOException, RrdException {
        return this.getXml();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void dumpXml(String filename) throws IOException, RrdException {
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(filename, false);
            this.dumpXml(outputStream);
        }
        finally {
            if (outputStream != null) {
                ((OutputStream)outputStream).close();
            }
        }
    }

    public synchronized void exportXml(String filename) throws IOException, RrdException {
        this.dumpXml(filename);
    }

    public synchronized long getLastUpdateTime() throws IOException {
        return this.header.getLastUpdateTime();
    }

    public synchronized RrdDef getRrdDef() throws RrdException, IOException {
        int i;
        long startTime = this.header.getLastUpdateTime();
        long step = this.header.getStep();
        String path = this.backend.getPath();
        RrdDef rrdDef = new RrdDef(path, startTime, step);
        for (i = 0; i < this.datasources.length; ++i) {
            DsDef dsDef = new DsDef(this.datasources[i].getDsName(), this.datasources[i].getDsType(), this.datasources[i].getHeartbeat(), this.datasources[i].getMinValue(), this.datasources[i].getMaxValue());
            rrdDef.addDatasource(dsDef);
        }
        for (i = 0; i < this.archives.length; ++i) {
            ArcDef arcDef = new ArcDef(this.archives[i].getConsolFun(), this.archives[i].getXff(), this.archives[i].getSteps(), this.archives[i].getRows());
            rrdDef.addArchive(arcDef);
        }
        return rrdDef;
    }

    public static int getLockMode() {
        return lockMode;
    }

    public static void setLockMode(int lockMode) {
        RrdDb.lockMode = lockMode;
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    public synchronized void copyStateTo(RrdUpdater other) throws IOException, RrdException {
        int j;
        int i;
        if (!(other instanceof RrdDb)) {
            throw new RrdException("Cannot copy RrdDb object to " + other.getClass().getName());
        }
        RrdDb otherRrd = (RrdDb)other;
        this.header.copyStateTo(otherRrd.header);
        for (i = 0; i < this.datasources.length; ++i) {
            j = Util.getMatchingDatasourceIndex(this, i, otherRrd);
            if (j < 0) continue;
            this.datasources[i].copyStateTo(otherRrd.datasources[j]);
        }
        for (i = 0; i < this.archives.length; ++i) {
            j = Util.getMatchingArchiveIndex(this, i, otherRrd);
            if (j < 0) continue;
            this.archives[i].copyStateTo(otherRrd.archives[j]);
        }
    }

    public Datasource getDatasource(String dsName) throws IOException {
        try {
            return this.getDatasource(this.getDsIndex(dsName));
        }
        catch (RrdException e) {
            return null;
        }
    }

    public int getArcIndex(String consolFun, int steps) throws RrdException, IOException {
        for (int i = 0; i < this.archives.length; ++i) {
            if (!this.archives[i].getConsolFun().equals(consolFun) || this.archives[i].getSteps() != steps) continue;
            return i;
        }
        throw new RrdException("Could not find archive " + consolFun + "/" + steps);
    }

    public Archive getArchive(String consolFun, int steps) throws IOException {
        try {
            return this.getArchive(this.getArcIndex(consolFun, steps));
        }
        catch (RrdException e) {
            return null;
        }
    }

    public String getCanonicalPath() throws IOException {
        if (this.backend instanceof RrdFileBackend) {
            return ((RrdFileBackend)this.backend).getCanonicalPath();
        }
        throw new IOException("The underlying backend has no canonical path");
    }

    public String getPath() {
        return this.backend.getPath();
    }

    public RrdBackend getRrdBackend() {
        return this.backend;
    }

    public RrdAllocator getRrdAllocator() {
        return this.allocator;
    }

    public synchronized byte[] getBytes() throws IOException {
        return this.backend.readAll();
    }

    public synchronized void sync() throws IOException {
        this.backend.sync();
    }

    public static void setDefaultFactory(String factoryName) throws RrdException {
        RrdBackendFactory.setDefaultFactory(factoryName);
    }

    public static void main(String[] args) {
        System.out.println("JRobin base directory: " + Util.getJRobinHomeDirectory());
        System.out.println("JRobin Java Library :: RRDTool choice for the Java world");
        System.out.println("http://www.jrobin.org");
        System.out.println("(C) 2004 Sasa Markovic & Arne Vandamme");
    }
}

