/*
 * Decompiled with CFR 0.152.
 */
package uk.ltd.getahead.dwr.convert;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import uk.ltd.getahead.dwr.ConversionException;
import uk.ltd.getahead.dwr.Converter;
import uk.ltd.getahead.dwr.ConverterManager;
import uk.ltd.getahead.dwr.InboundContext;
import uk.ltd.getahead.dwr.InboundVariable;
import uk.ltd.getahead.dwr.Messages;
import uk.ltd.getahead.dwr.OutboundContext;
import uk.ltd.getahead.dwr.OutboundVariable;
import uk.ltd.getahead.dwr.util.JavascriptUtil;
import uk.ltd.getahead.dwr.util.LocalUtil;
import uk.ltd.getahead.dwr.util.Logger;

public class MapConverter
implements Converter {
    private JavascriptUtil jsutil = new JavascriptUtil();
    private ConverterManager config = null;
    private static final Logger log;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("uk.ltd.getahead.dwr.convert.MapConverter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger(clazz);
    }

    public void setConverterManager(ConverterManager newConfig) {
        this.config = newConfig;
    }

    public Object convertInbound(Class paramType, InboundVariable iv, InboundContext inctx) throws ConversionException {
        String value = iv.getValue();
        if (value.trim().equals("null")) {
            return null;
        }
        if (!value.startsWith("{")) {
            throw new IllegalArgumentException(Messages.getString("MapConverter.MissingOpener", "{"));
        }
        if (!value.endsWith("}")) {
            throw new IllegalArgumentException(Messages.getString("MapConverter.MissingCloser", "{"));
        }
        value = value.substring(1, value.length() - 1);
        try {
            Map map = null;
            map = !paramType.isInterface() && !Modifier.isAbstract(paramType.getModifiers()) ? (Map)paramType.newInstance() : new HashMap();
            Method method = inctx.getCurrentMethod();
            int paramNum = inctx.getCurrentParameterNum();
            Class keyType = this.config.getExtraTypeInfo(method, paramNum, 0);
            if (keyType == null) {
                log.warn("Missing type info for " + method.getName() + "(), param=" + paramNum + ". Assuming this is a map with String keys. Please add to <signatures> in dwr.xml");
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                keyType = clazz;
            } else {
                log.debug("Using extra type info for " + method.getName() + "(), param=" + paramNum + " of " + keyType);
            }
            Class valType = this.config.getExtraTypeInfo(method, paramNum, 1);
            if (valType == null) {
                log.warn("Missing type info for " + method.getName() + "(), param=" + paramNum + ". Assuming this is a map with String values. Please add to <signatures> in dwr.xml");
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                valType = clazz;
            } else {
                log.debug("Using extra type info for " + method.getName() + "(), param=" + paramNum + " of " + valType);
            }
            inctx.addConverted(iv, map);
            InboundContext incx = iv.getLookup();
            StringTokenizer st = new StringTokenizer(value, ",");
            int size = st.countTokens();
            int i = 0;
            while (i < size) {
                String token = st.nextToken();
                if (token.trim().length() != 0) {
                    int colonpos = token.indexOf(":");
                    if (colonpos == -1) {
                        throw new ConversionException(Messages.getString("MapConverter.MissingSeparator", ":", token));
                    }
                    String valStr = token.substring(colonpos + 1).trim();
                    String[] splitIv = LocalUtil.splitInbound(valStr);
                    InboundVariable valIv = new InboundVariable(incx, splitIv[0], splitIv[1]);
                    Object val = this.config.convertInbound(valType, valIv, inctx);
                    String keyStr = token.substring(0, colonpos).trim();
                    InboundVariable keyIv = new InboundVariable(incx, "string", keyStr);
                    Object key = this.config.convertInbound(keyType, keyIv, inctx);
                    map.put(key, val);
                }
                ++i;
            }
            return map;
        }
        catch (ConversionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ConversionException(ex);
        }
    }

    public String convertOutbound(Object data, String varname, OutboundContext outctx) throws ConversionException {
        Map map = (Map)data;
        StringBuffer buffer = new StringBuffer();
        buffer.append("var ");
        buffer.append(varname);
        buffer.append(" = new Object();");
        Iterator it = map.keySet().iterator();
        while (it.hasNext()) {
            String outkey;
            Object key = it.next();
            if (key instanceof String) {
                outkey = String.valueOf('\'') + this.jsutil.escapeJavaScript((String)key) + '\'';
            } else {
                OutboundVariable ovkey = this.config.convertOutbound(key, outctx);
                buffer.append(ovkey.getInitCode());
                outkey = ovkey.getAssignCode();
            }
            Object value = map.get(key);
            OutboundVariable nested = this.config.convertOutbound(value, outctx);
            buffer.append(nested.getInitCode());
            buffer.append(varname);
            buffer.append('[');
            buffer.append(outkey);
            buffer.append("] = ");
            buffer.append(nested.getAssignCode());
            buffer.append(';');
        }
        return buffer.toString();
    }
}

