/*
 * Decompiled with CFR 0.152.
 */
package uk.ltd.getahead.dwr;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import uk.ltd.getahead.dwr.Configuration;
import uk.ltd.getahead.dwr.CreatorManager;
import uk.ltd.getahead.dwr.ExecutionContext;
import uk.ltd.getahead.dwr.Factory;
import uk.ltd.getahead.dwr.Messages;
import uk.ltd.getahead.dwr.Processor;
import uk.ltd.getahead.dwr.util.Logger;
import uk.ltd.getahead.dwr.util.ServletLoggingOutput;

public class DWRServlet
extends HttpServlet {
    protected Processor processor;
    public static final String PACKAGE = "/uk/ltd/getahead/dwr/";
    protected static final String INIT_SKIP_DEFAULT = "skipDefaultConfig";
    protected static final String INIT_CONFIG = "config";
    protected static final String INIT_DEBUG = "debug";
    protected static final String INIT_LOGLEVEL = "logLevel";
    protected static final String INIT_IMPL_PREFIX = "uk.ltd.getahead.dwr";
    protected static final String FILE_DWR_XML = "dwr.xml";
    protected static final String DEFAULT_DWR_XML = "/WEB-INF/dwr.xml";
    private static final Logger log;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("uk.ltd.getahead.dwr.DWRServlet");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger(clazz);
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        try {
            Class<?> clazz;
            String skip;
            String execCxName;
            ExecutionContext.setExecutionContext(null, null, this.getServletConfig(), this.getServletContext());
            ServletLoggingOutput.setExecutionContext(this);
            String logLevel = config.getInitParameter(INIT_LOGLEVEL);
            if (logLevel != null) {
                ServletLoggingOutput.setLevel(logLevel);
            }
            Factory factory = new Factory();
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("uk.ltd.getahead.dwr.AccessControl");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            factory.setImplementation(clazz2.getName(), "uk.ltd.getahead.dwr.impl.DefaultAccessControl");
            Class<?> clazz3 = class$2;
            if (clazz3 == null) {
                try {
                    clazz3 = class$2 = Class.forName("uk.ltd.getahead.dwr.Configuration");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            factory.setImplementation(clazz3.getName(), "uk.ltd.getahead.dwr.impl.DefaultConfiguration");
            Class<?> clazz4 = class$3;
            if (clazz4 == null) {
                try {
                    clazz4 = class$3 = Class.forName("uk.ltd.getahead.dwr.ConverterManager");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            factory.setImplementation(clazz4.getName(), "uk.ltd.getahead.dwr.impl.DefaultConverterManager");
            Class<?> clazz5 = class$4;
            if (clazz5 == null) {
                try {
                    clazz5 = class$4 = Class.forName("uk.ltd.getahead.dwr.CreatorManager");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            factory.setImplementation(clazz5.getName(), "uk.ltd.getahead.dwr.impl.DefaultCreatorManager");
            Class<?> clazz6 = class$5;
            if (clazz6 == null) {
                try {
                    clazz6 = class$5 = Class.forName("uk.ltd.getahead.dwr.Processor");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            factory.setImplementation(clazz6.getName(), "uk.ltd.getahead.dwr.impl.DefaultProcessor");
            Enumeration en = config.getInitParameterNames();
            while (en.hasMoreElements()) {
                String name = (String)en.nextElement();
                if (!name.startsWith(INIT_IMPL_PREFIX)) continue;
                String value = config.getInitParameter(name);
                try {
                    factory.setImplementation(name, value);
                }
                catch (Exception ex) {
                    log.fatal("Invalid implmentation parameter: " + name + "=" + value, ex);
                    throw new ServletException(Messages.getString("DWRServlet.ExecutionContextInit", name, value), (Throwable)ex);
                }
            }
            factory.configurationFinished();
            Class<?> clazz7 = class$6;
            if (clazz7 == null) {
                try {
                    clazz7 = class$6 = Class.forName("uk.ltd.getahead.dwr.ExecutionContext");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((execCxName = config.getInitParameter(clazz7.getName())) != null) {
                try {
                    Class<?> type = Class.forName(execCxName);
                    ExecutionContext.setImplementation(type);
                }
                catch (Exception ex) {
                    log.fatal("Invalid executionContext parameter", ex);
                    throw new ServletException(Messages.getString("DWRServlet.ExecutionContextInit", execCxName, ex), (Throwable)ex);
                }
            }
            String debugStr = config.getInitParameter(INIT_DEBUG);
            boolean debug = Boolean.valueOf(debugStr);
            Class<?> clazz8 = class$4;
            if (clazz8 == null) {
                try {
                    clazz8 = class$4 = Class.forName("uk.ltd.getahead.dwr.CreatorManager");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            CreatorManager creatorManager = (CreatorManager)factory.getBean(clazz8);
            creatorManager.setDebug(debug);
            Class<?> clazz9 = class$2;
            if (clazz9 == null) {
                try {
                    clazz9 = class$2 = Class.forName("uk.ltd.getahead.dwr.Configuration");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Configuration configuration = (Configuration)factory.getBean(clazz9);
            InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream(FILE_DWR_XML);
            try {
                configuration.addConfig(in);
            }
            catch (Exception ex) {
                log.fatal("Failed to load system config file from dwr.jar", ex);
                throw new ServletException(Messages.getString("DWRServlet.SystemConfigError"), (Throwable)ex);
            }
            en = config.getInitParameterNames();
            boolean foundConfig = false;
            while (en.hasMoreElements()) {
                String name = (String)en.nextElement();
                if (!name.startsWith(INIT_CONFIG)) continue;
                foundConfig = true;
                String configFile = config.getInitParameter(name);
                this.readFile(configFile, configuration);
            }
            if (!foundConfig && !Boolean.valueOf(skip = config.getInitParameter(INIT_SKIP_DEFAULT)).booleanValue()) {
                this.readFile(DEFAULT_DWR_XML, configuration);
            }
            if ((clazz = class$5) == null) {
                try {
                    clazz = class$5 = Class.forName("uk.ltd.getahead.dwr.Processor");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.processor = (Processor)factory.getBean(clazz);
        }
        finally {
            ExecutionContext.unset();
            ServletLoggingOutput.unsetExecutionContext();
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        this.doPost(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        try {
            ExecutionContext.setExecutionContext(req, resp, this.getServletConfig(), this.getServletContext());
            ServletLoggingOutput.setExecutionContext(this);
            this.processor.handle(req, resp);
        }
        finally {
            ExecutionContext.unset();
            ServletLoggingOutput.unsetExecutionContext();
        }
    }

    protected void readFile(String configFile, Configuration configuration) throws ServletException {
        try {
            InputStream in = this.getServletContext().getResourceAsStream(configFile);
            if (in == null) {
                log.error("Missing config file: " + configFile);
            } else {
                configuration.addConfig(in);
            }
        }
        catch (Exception ex) {
            throw new ServletException(Messages.getString("DWRServlet.ConfigError", configFile), (Throwable)ex);
        }
    }
}

