/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.core;

import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jrobin.core.RrdException;
import org.jrobin.core.Util;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public abstract class XmlTemplate {
    private static final String PATTERN_STRING = "\\$\\{(\\w+)\\}";
    private static final Pattern PATTERN = Pattern.compile("\\$\\{(\\w+)\\}");
    protected Element root;
    private HashMap valueMap = new HashMap();
    private HashSet validatedNodes = new HashSet();

    protected XmlTemplate(InputSource xmlSource) throws IOException, RrdException {
        this.root = Util.Xml.getRootElement(xmlSource);
    }

    protected XmlTemplate(String xmlString) throws IOException, RrdException {
        this.root = Util.Xml.getRootElement(xmlString);
    }

    protected XmlTemplate(File xmlFile) throws IOException, RrdException {
        this.root = Util.Xml.getRootElement(xmlFile);
    }

    public void clearValues() {
        this.valueMap.clear();
    }

    public void setVariable(String name, String value) {
        this.valueMap.put(name, value);
    }

    public void setVariable(String name, int value) {
        this.valueMap.put(name, new Integer(value));
    }

    public void setVariable(String name, long value) {
        this.valueMap.put(name, new Long(value));
    }

    public void setVariable(String name, double value) {
        this.valueMap.put(name, new Double(value));
    }

    public void setVariable(String name, Color value) {
        this.valueMap.put(name, "#" + Integer.toHexString(value.getRGB() & 0xFFFFFF));
    }

    public void setVariable(String name, Date value) {
        this.setVariable(name, Util.getTimestamp(value));
    }

    public void setVariable(String name, GregorianCalendar value) {
        this.setVariable(name, Util.getTimestamp(value));
    }

    public void setVariable(String name, boolean value) {
        this.valueMap.put(name, "" + value);
    }

    public boolean hasVariables() {
        return PATTERN.matcher(this.root.toString()).find();
    }

    public String[] getVariables() {
        ArrayList<String> list = new ArrayList<String>();
        Matcher m = PATTERN.matcher(this.root.toString());
        while (m.find()) {
            String var = m.group(1);
            if (list.contains(var)) continue;
            list.add(var);
        }
        return list.toArray(new String[list.size()]);
    }

    protected static Node[] getChildNodes(Node parentNode, String childName) {
        return Util.Xml.getChildNodes(parentNode, childName);
    }

    protected static Node[] getChildNodes(Node parentNode) {
        return Util.Xml.getChildNodes(parentNode, null);
    }

    protected static Node getFirstChildNode(Node parentNode, String childName) throws RrdException {
        return Util.Xml.getFirstChildNode(parentNode, childName);
    }

    protected boolean hasChildNode(Node parentNode, String childName) {
        return Util.Xml.hasChildNode(parentNode, childName);
    }

    protected String getChildValue(Node parentNode, String childName) throws RrdException {
        return this.getChildValue(parentNode, childName, true);
    }

    protected String getChildValue(Node parentNode, String childName, boolean trim) throws RrdException {
        String value = Util.Xml.getChildValue(parentNode, childName, trim);
        return this.resolveMappings(value);
    }

    protected String getValue(Node parentNode) {
        return this.getValue(parentNode, true);
    }

    protected String getValue(Node parentNode, boolean trim) {
        String value = Util.Xml.getValue(parentNode, trim);
        return this.resolveMappings(value);
    }

    private String resolveMappings(String templateValue) {
        if (templateValue == null) {
            return null;
        }
        Matcher matcher = PATTERN.matcher(templateValue);
        StringBuffer result = new StringBuffer();
        int lastMatchEnd = 0;
        while (matcher.find()) {
            String var = matcher.group(1);
            if (this.valueMap.containsKey(var)) {
                result.append(templateValue.substring(lastMatchEnd, matcher.start()));
                result.append(this.valueMap.get(var).toString());
                lastMatchEnd = matcher.end();
                continue;
            }
            throw new IllegalArgumentException("No mapping found for template variable ${" + var + "}");
        }
        result.append(templateValue.substring(lastMatchEnd));
        return result.toString();
    }

    protected int getChildValueAsInt(Node parentNode, String childName) throws RrdException {
        String valueStr = this.getChildValue(parentNode, childName);
        return Integer.parseInt(valueStr);
    }

    protected int getValueAsInt(Node parentNode) {
        String valueStr = this.getValue(parentNode);
        return Integer.parseInt(valueStr);
    }

    protected long getChildValueAsLong(Node parentNode, String childName) throws RrdException {
        String valueStr = this.getChildValue(parentNode, childName);
        return Long.parseLong(valueStr);
    }

    protected long getValueAsLong(Node parentNode) {
        String valueStr = this.getValue(parentNode);
        return Long.parseLong(valueStr);
    }

    protected double getChildValueAsDouble(Node parentNode, String childName) throws RrdException {
        String valueStr = this.getChildValue(parentNode, childName);
        return Util.parseDouble(valueStr);
    }

    protected double getValueAsDouble(Node parentNode) {
        String valueStr = this.getValue(parentNode);
        return Util.parseDouble(valueStr);
    }

    protected boolean getChildValueAsBoolean(Node parentNode, String childName) throws RrdException {
        String valueStr = this.getChildValue(parentNode, childName);
        return Util.parseBoolean(valueStr);
    }

    protected boolean getValueAsBoolean(Node parentNode) {
        String valueStr = this.getValue(parentNode);
        return Util.parseBoolean(valueStr);
    }

    protected boolean isEmptyNode(Node node) {
        return node.getNodeName().equals("#comment") || node.getNodeName().equals("#text") && node.getNodeValue().trim().length() == 0;
    }

    protected void validateTagsOnlyOnce(Node parentNode, String[] allowedChildNames) throws RrdException {
        if (this.validatedNodes.contains(parentNode)) {
            return;
        }
        Node[] childs = XmlTemplate.getChildNodes(parentNode);
        block0: for (int i = 0; i < childs.length; ++i) {
            String childName = childs[i].getNodeName();
            for (int j = 0; j < allowedChildNames.length; ++j) {
                if (allowedChildNames[j].equals(childName)) {
                    allowedChildNames[j] = "<--removed-->";
                    continue block0;
                }
                if (allowedChildNames[j].equals(childName + "*")) continue block0;
            }
            if (this.isEmptyNode(childs[i])) continue;
            throw new RrdException("Unexpected tag encountered: <" + childName + ">");
        }
        this.validatedNodes.add(parentNode);
    }
}

