/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.core;

import java.io.IOException;
import org.jrobin.core.RrdBackendFactory;
import org.jrobin.core.RrdDb;
import org.jrobin.core.RrdDbPool;
import org.jrobin.core.RrdException;

public class RrdOpener {
    protected RrdDbPool pool;
    protected boolean readOnly = false;
    protected boolean usePool = false;

    public RrdOpener(boolean usePool) {
        this.usePool = usePool;
        if (usePool) {
            this.pool = RrdDbPool.getInstance();
        }
    }

    public RrdOpener(boolean usePool, boolean readOnly) {
        this(usePool);
        this.readOnly = readOnly;
    }

    public RrdDb getRrd(String rrdFile, RrdBackendFactory backendFactory) throws IOException, RrdException {
        if (this.pool != null) {
            return this.pool.requestRrdDb(rrdFile);
        }
        return new RrdDb(rrdFile, this.readOnly, backendFactory);
    }

    public void releaseRrd(RrdDb rrdDb) throws IOException, RrdException {
        if (this.pool != null) {
            this.pool.release(rrdDb);
        } else {
            rrdDb.close();
        }
    }
}

