/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.core;

import java.io.IOException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Timer;
import java.util.TimerTask;
import org.jrobin.core.RrdFileBackend;

public class RrdNioBackend
extends RrdFileBackend {
    public static final boolean SHOULD_GC = true;
    private static final Timer syncTimer;
    private int syncMode;
    MappedByteBuffer byteBuffer;
    private TimerTask syncTask;

    protected RrdNioBackend(String path, boolean readOnly, int lockMode, int syncMode, int syncPeriod) throws IOException {
        super(path, readOnly, lockMode);
        this.map(readOnly);
        this.syncMode = syncMode;
        if (syncMode == 5 && !readOnly) {
            this.createSyncTask(syncPeriod);
        }
    }

    private void map(boolean readOnly) throws IOException {
        long length = this.getLength();
        if (length > 0L) {
            FileChannel.MapMode mapMode = readOnly ? FileChannel.MapMode.READ_ONLY : FileChannel.MapMode.READ_WRITE;
            this.byteBuffer = this.channel.map(mapMode, 0L, length);
        } else {
            this.byteBuffer = null;
        }
    }

    private void createSyncTask(int syncPeriod) {
        this.syncTask = new TimerTask(){

            public void run() {
                RrdNioBackend.this.sync();
            }
        };
        syncTimer.schedule(this.syncTask, (long)syncPeriod * 1000L, (long)syncPeriod * 1000L);
    }

    protected void setLength(long newLength) throws IOException {
        if (newLength < this.getLength()) {
            this.byteBuffer = null;
            System.gc();
        }
        super.setLength(newLength);
        this.map(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void write(long offset, byte[] b) {
        MappedByteBuffer mappedByteBuffer = this.byteBuffer;
        synchronized (mappedByteBuffer) {
            this.byteBuffer.position((int)offset);
            this.byteBuffer.put(b);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void read(long offset, byte[] b) {
        MappedByteBuffer mappedByteBuffer = this.byteBuffer;
        synchronized (mappedByteBuffer) {
            this.byteBuffer.position((int)offset);
            this.byteBuffer.get(b);
        }
    }

    public void close() throws IOException {
        if (this.syncTask != null) {
            this.syncTask.cancel();
        }
        super.close();
        this.byteBuffer = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sync() {
        if (this.byteBuffer != null) {
            MappedByteBuffer mappedByteBuffer = this.byteBuffer;
            synchronized (mappedByteBuffer) {
                this.byteBuffer.force();
            }
        }
    }

    protected void beforeUpdate() {
        if (this.syncMode == 1) {
            this.sync();
        }
    }

    protected void afterUpdate() {
        if (this.syncMode == 2) {
            this.sync();
        }
    }

    protected void beforeFetch() {
        if (this.syncMode == 3) {
            this.sync();
        }
    }

    protected void afterFetch() {
        if (this.syncMode == 4) {
            this.sync();
        }
    }

    static {
        final Runtime runtime = Runtime.getRuntime();
        runtime.addShutdownHook(new Thread(){

            public void run() {
                runtime.runFinalization();
                runtime.gc();
            }
        });
        syncTimer = new Timer(true);
    }
}

