/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.graph;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.io.File;
import java.io.OutputStream;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.jrobin.core.RrdException;
import org.jrobin.core.XmlWriter;
import org.jrobin.graph.Area;
import org.jrobin.graph.Cdef;
import org.jrobin.graph.Comment;
import org.jrobin.graph.CustomArea;
import org.jrobin.graph.CustomLine;
import org.jrobin.graph.Gprint;
import org.jrobin.graph.GridRange;
import org.jrobin.graph.Legend;
import org.jrobin.graph.Line;
import org.jrobin.graph.PlotDef;
import org.jrobin.graph.RrdExportDef;
import org.jrobin.graph.Stack;
import org.jrobin.graph.TimeAxisLabel;
import org.jrobin.graph.TimeAxisUnit;
import org.jrobin.graph.TimeText;
import org.jrobin.graph.Title;
import org.jrobin.graph.ValueAxisUnit;

public class RrdGraphDef
extends RrdExportDef
implements Serializable {
    private Title title = null;
    private String valueAxisLabel = null;
    private TimeAxisLabel timeAxisLabel = null;
    private boolean lazyGeneration = false;
    private boolean gridX = true;
    private boolean gridY = true;
    private boolean minorGridX = true;
    private boolean minorGridY = true;
    private boolean majorGridX = true;
    private boolean majorGridY = true;
    private boolean frontGrid = true;
    private boolean antiAliasing = true;
    private boolean showLegend = true;
    private boolean drawSignature = true;
    private Color backColor = new Color(245, 245, 245);
    private Color canvasColor = Color.WHITE;
    private Color borderColor = Color.LIGHT_GRAY;
    private Color normalFontColor = Color.BLACK;
    private Color titleFontColor = Color.BLACK;
    private Color majorGridColor = new Color(130, 30, 30);
    private Color minorGridColor = new Color(140, 140, 140);
    private Color axisColor = new Color(130, 30, 30);
    private Color arrowColor = Color.RED;
    private Color frameColor = Color.LIGHT_GRAY;
    private Font titleFont = null;
    private Font normalFont = null;
    private File background = null;
    private File overlay = null;
    private int chart_lpadding = 50;
    private int firstDayOfWeek = 2;
    private double baseValue = 1000.0;
    private int scaleIndex = -1;
    private BasicStroke borderStroke = null;
    private TimeAxisUnit tAxis = null;
    private ValueAxisUnit vAxis = null;
    private GridRange gridRange = null;
    private int commentLines = 0;
    private int commentLineShift = 0;
    private ArrayList plotDefs = new ArrayList(10);
    private ArrayList comments = new ArrayList(10);

    public RrdGraphDef() {
    }

    public RrdGraphDef(long startTime, long endTime) throws RrdException {
        this.setTimePeriod(startTime, endTime);
    }

    public RrdGraphDef(Date start, Date end) throws RrdException {
        this.setTimePeriod(start, end);
    }

    public RrdGraphDef(GregorianCalendar start, GregorianCalendar end) throws RrdException {
        this.setTimePeriod(start, end);
    }

    public void setLazy(boolean lazyGeneration) {
        this.lazyGeneration = lazyGeneration;
    }

    public void setTitle(String title) throws RrdException {
        this.title = new Title(title);
    }

    public void setVerticalLabel(String label) {
        this.valueAxisLabel = label;
    }

    public void setTimeAxisLabel(String label) throws RrdException {
        if (label != null) {
            this.timeAxisLabel = new TimeAxisLabel(label);
            this.commentLines += this.timeAxisLabel.getLineCount();
            this.commentLineShift = this.timeAxisLabel.isCompleteLine() ? 0 : 1;
            this.comments.add(0, this.timeAxisLabel);
        }
    }

    public void setBackColor(Color backColor) {
        this.backColor = backColor;
    }

    public void setCanvasColor(Color canvasColor) {
        this.canvasColor = canvasColor;
    }

    public void setImageBorder(Color c, int w) {
        this.borderStroke = new BasicStroke(w);
        if (c != null) {
            this.borderColor = c;
        }
    }

    public void setTitleFontColor(Color c) {
        this.titleFontColor = c;
    }

    public void setDefaultFontColor(Color c) {
        this.normalFontColor = c;
    }

    public void setTitleFont(Font f) {
        this.titleFont = f;
    }

    public void setDefaultFont(Font f) {
        this.normalFont = f;
    }

    public void setMajorGridColor(Color c) {
        this.majorGridColor = c;
    }

    public void setMinorGridColor(Color c) {
        this.minorGridColor = c;
    }

    public void setFrameColor(Color c) {
        this.frameColor = c;
    }

    public void setAxisColor(Color c) {
        this.axisColor = c;
    }

    public void setArrowColor(Color c) {
        this.arrowColor = c;
    }

    public void setMinorGridX(boolean visible) {
        this.minorGridX = visible;
    }

    public void setMinorGridY(boolean visible) {
        this.minorGridY = visible;
    }

    public void setMajorGridX(boolean visible) {
        this.majorGridX = visible;
    }

    public void setMajorGridY(boolean visible) {
        this.majorGridY = visible;
    }

    public void setGridX(boolean visible) {
        this.gridX = visible;
    }

    public void setGridY(boolean visible) {
        this.gridY = visible;
    }

    public void setFrontGrid(boolean frontGrid) {
        this.frontGrid = frontGrid;
    }

    public void setShowLegend(boolean showLegend) {
        this.showLegend = showLegend;
    }

    public void setShowSignature(boolean showSignature) {
        this.drawSignature = showSignature;
    }

    public void setAntiAliasing(boolean aa) {
        this.antiAliasing = aa;
    }

    public void setChartLeftPadding(int lp) {
        this.chart_lpadding = lp;
    }

    public void setBackground(String fileName) {
        File bgFile = new File(fileName);
        if (bgFile.exists()) {
            this.background = bgFile;
        }
    }

    public void setOverlay(String fileName) {
        File ovFile = new File(fileName);
        if (ovFile.exists()) {
            this.overlay = ovFile;
        }
    }

    public void setBaseValue(double base) {
        this.baseValue = base;
    }

    public void setUnitsExponent(int e) {
        this.scaleIndex = 6 - e / 3;
    }

    int getUnitsExponent() {
        return (6 - this.scaleIndex) * 3;
    }

    public void setGridRange(double lower, double upper, boolean rigid) {
        this.gridRange = new GridRange(lower, upper, rigid);
    }

    public void setLowerLimit(double lower) {
        this.gridRange = new GridRange(lower, Double.NaN, false);
    }

    public void setValueAxis(double gridStep, double labelStep) {
        this.vAxis = new ValueAxisUnit(gridStep, labelStep);
    }

    public void setTimeAxis(int minGridTimeUnit, int minGridUnitSteps, int majGridTimeUnit, int majGridUnitSteps, String dateFormat, boolean centerLabels) {
        this.tAxis = new TimeAxisUnit(minGridTimeUnit, minGridUnitSteps, majGridTimeUnit, majGridUnitSteps, new SimpleDateFormat(dateFormat), centerLabels, this.firstDayOfWeek);
    }

    public void setFirstDayOfWeek(int day) {
        this.firstDayOfWeek = day;
    }

    public void line(String sourceName, Color color, String legend) throws RrdException {
        this.plotDefs.add(new Line(sourceName, color));
        this.addLegend(legend, color);
    }

    public void line(String sourceName, Color color, String legend, int lineWidth) throws RrdException {
        this.plotDefs.add(new Line(sourceName, color, lineWidth));
        this.addLegend(legend, color);
    }

    public void line(GregorianCalendar t1, double v1, GregorianCalendar t2, double v2, Color color, String legend, int lineWidth) throws RrdException {
        this.plotDefs.add(new CustomLine(t1.getTimeInMillis() / 1000L, v1, t2.getTimeInMillis() / 1000L, v2, color, lineWidth));
        this.addLegend(legend, color);
    }

    public void area(String sourceName, Color color, String legend) throws RrdException {
        this.plotDefs.add(new Area(sourceName, color));
        this.addLegend(legend, color);
    }

    public void area(GregorianCalendar t1, double v1, GregorianCalendar t2, double v2, Color color, String legend) throws RrdException {
        this.plotDefs.add(new CustomArea(t1.getTimeInMillis() / 1000L, v1, t2.getTimeInMillis() / 1000L, v2, color));
        this.addLegend(legend, color);
    }

    public void stack(String sourceName, Color color, String legend) throws RrdException {
        this.plotDefs.add(new Stack(sourceName, color));
        this.addLegend(legend, color);
    }

    public void hrule(double value, Color color, String legend) throws RrdException {
        this.plotDefs.add(new CustomLine(Long.MIN_VALUE, value, Long.MAX_VALUE, value, color));
        this.addLegend(legend, color);
    }

    public void hrule(double value, Color color, String legend, int lineWidth) throws RrdException {
        this.plotDefs.add(new CustomLine(Long.MIN_VALUE, value, Long.MAX_VALUE, value, color, lineWidth));
        this.addLegend(legend, color);
    }

    public void vrule(GregorianCalendar timestamp, Color color, String legend) throws RrdException {
        long timeSecs = timestamp.getTimeInMillis() / 1000L;
        this.plotDefs.add(new CustomLine(timeSecs, Double.MIN_VALUE, timeSecs, Double.MAX_VALUE, color));
        this.addLegend(legend, color);
    }

    public void vrule(GregorianCalendar timestamp, Color color, String legend, int lineWidth) throws RrdException {
        long timeSecs = timestamp.getTimeInMillis() / 1000L;
        this.plotDefs.add(new CustomLine(timeSecs, Double.MIN_VALUE, timeSecs, Double.MAX_VALUE, color, lineWidth));
        this.addLegend(legend, color);
    }

    public void comment(String text) throws RrdException {
        this.addComment(new Comment(text));
    }

    public void time(String text, String pattern) throws RrdException {
        this.addComment(new TimeText(text, pattern));
    }

    public void time(String text, DateFormat format) throws RrdException {
        this.addComment(new TimeText(text, format));
    }

    public void time(String text, String pattern, long timestamp) throws RrdException {
        this.addComment(new TimeText(text, pattern, timestamp));
    }

    public void time(String text, DateFormat format, long timestamp) throws RrdException {
        this.addComment(new TimeText(text, format, timestamp));
    }

    public void time(String text, String pattern, Date date) throws RrdException {
        this.addComment(new TimeText(text, pattern, date));
    }

    public void time(String text, DateFormat format, Date date) throws RrdException {
        this.addComment(new TimeText(text, format, date));
    }

    public void time(String text, String pattern, Calendar cal) throws RrdException {
        this.addComment(new TimeText(text, pattern, cal));
    }

    public void time(String text, DateFormat format, Calendar cal) throws RrdException {
        this.addComment(new TimeText(text, format, cal));
    }

    public void gprint(String sourceName, String consolFun, String format) throws RrdException {
        this.addComment(new Gprint(sourceName, consolFun, format));
    }

    public void gprint(String sourceName, String consolFun, String format, double base) throws RrdException {
        this.addComment(new Gprint(sourceName, consolFun, format, base));
    }

    public void exportXmlTemplate(OutputStream stream) {
        int i;
        XmlWriter xml = new XmlWriter(stream);
        xml.startTag("rrd_graph_def");
        xml.startTag("span");
        xml.writeTag("start", this.getStartTime());
        xml.writeTag("end", this.getEndTime());
        xml.closeTag();
        xml.startTag("options");
        xml.writeTag("anti_aliasing", this.antiAliasing);
        xml.writeTag("arrow_color", this.arrowColor);
        xml.writeTag("axis_color", this.axisColor);
        xml.writeTag("back_color", this.backColor);
        if (this.background != null) {
            xml.writeTag("background", this.background);
        }
        xml.writeTag("base_value", this.baseValue);
        xml.writeTag("canvas", this.canvasColor);
        xml.writeTag("left_padding", this.chart_lpadding);
        if (this.normalFont != null) {
            xml.writeTag("default_font", this.normalFont);
        }
        xml.writeTag("default_font_color", this.normalFontColor);
        xml.writeTag("frame_color", this.frameColor);
        xml.writeTag("front_grid", this.frontGrid);
        if (this.gridRange != null) {
            this.gridRange.exportXmlTemplate(xml);
        }
        xml.writeTag("grid_x", this.gridX);
        xml.writeTag("grid_y", this.gridY);
        if (this.borderStroke != null) {
            xml.startTag("border");
            xml.writeTag("color", this.borderColor);
            xml.writeTag("width", (int)this.borderStroke.getLineWidth());
            xml.closeTag();
        }
        xml.writeTag("major_grid_color", this.majorGridColor);
        xml.writeTag("major_grid_x", this.majorGridX);
        xml.writeTag("major_grid_y", this.majorGridY);
        xml.writeTag("minor_grid_color", this.minorGridColor);
        xml.writeTag("minor_grid_x", this.minorGridX);
        xml.writeTag("minor_grid_y", this.minorGridY);
        if (this.overlay != null) {
            xml.writeTag("overlay", this.overlay);
        }
        xml.writeTag("show_legend", this.showLegend);
        xml.writeTag("show_signature", this.drawSignature);
        if (this.tAxis != null) {
            this.tAxis.exportXmlTemplate(xml);
        }
        if (this.timeAxisLabel != null) {
            this.timeAxisLabel.exportXmlTemplate(xml);
        }
        if (this.title != null) {
            this.title.exportXmlTemplate(xml);
        }
        if (this.titleFont != null) {
            xml.writeTag("title_font", this.titleFont);
        }
        xml.writeTag("title_font_color", this.titleFontColor);
        if (this.scaleIndex != -1) {
            xml.writeTag("units_exponent", this.getUnitsExponent());
        }
        if (this.vAxis != null) {
            this.vAxis.exportXmlTemplate(xml);
        }
        if (this.valueAxisLabel != null) {
            xml.writeTag("vertical_label", this.valueAxisLabel);
        }
        xml.closeTag();
        xml.startTag("datasources");
        for (i = 0; i < this.fetchSources.size(); ++i) {
            this.fetchSources.get(i).exportXml(xml);
        }
        for (i = 0; i < this.cdefList.size(); ++i) {
            Cdef cdef = (Cdef)this.cdefList.get(i);
            cdef.exportXml(xml);
        }
        xml.closeTag();
        xml.startTag("graph");
        for (i = 0; i < this.comments.size(); ++i) {
            Comment cmt = (Comment)this.comments.get(i);
            if (cmt.commentType == 1 || cmt.commentType == 3) {
                PlotDef pDef = (PlotDef)this.plotDefs.get(((Legend)cmt).getPlofDefIndex());
                pDef.exportXmlTemplate(xml, cmt.text);
                continue;
            }
            if (cmt instanceof TimeAxisLabel) continue;
            cmt.exportXmlTemplate(xml);
        }
        xml.closeTag();
        xml.closeTag();
        xml.flush();
    }

    protected boolean isLazy() {
        return this.lazyGeneration;
    }

    protected Title getTitle() {
        return this.title;
    }

    protected String getVerticalLabel() {
        return this.valueAxisLabel;
    }

    protected Color getBackColor() {
        return this.backColor;
    }

    protected Color getCanvasColor() {
        return this.canvasColor;
    }

    protected Color getImageBorderColor() {
        return this.borderColor;
    }

    protected BasicStroke getImageBorderStroke() {
        return this.borderStroke;
    }

    protected Color getTitleFontColor() {
        return this.titleFontColor;
    }

    protected Color getDefaultFontColor() {
        return this.normalFontColor;
    }

    protected Font getTitleFont() {
        return this.titleFont;
    }

    protected Font getDefaultFont() {
        return this.normalFont;
    }

    protected Color getMajorGridColor() {
        return this.majorGridColor;
    }

    protected Color getMinorGridColor() {
        return this.minorGridColor;
    }

    protected Color getFrameColor() {
        return this.frameColor;
    }

    protected Color getAxisColor() {
        return this.axisColor;
    }

    protected Color getArrowColor() {
        return this.arrowColor;
    }

    protected Color getBorderColor() {
        return this.borderColor;
    }

    protected BasicStroke getBorderStroke() {
        return this.borderStroke;
    }

    protected boolean showMinorGridX() {
        return this.minorGridX;
    }

    protected boolean showMinorGridY() {
        return this.minorGridY;
    }

    protected boolean showMajorGridX() {
        return this.majorGridX;
    }

    protected boolean showMajorGridY() {
        return this.majorGridY;
    }

    protected boolean showGridX() {
        return this.gridX;
    }

    protected boolean showGridY() {
        return this.gridY;
    }

    protected boolean drawFrontGrid() {
        return this.frontGrid;
    }

    protected boolean showLegend() {
        return this.showLegend;
    }

    protected boolean showSignature() {
        return this.drawSignature;
    }

    protected boolean isFrontGrid() {
        return this.frontGrid;
    }

    protected boolean useAntiAliasing() {
        return this.antiAliasing;
    }

    protected int getChartLeftPadding() {
        return this.chart_lpadding;
    }

    protected File getBackground() {
        return this.background;
    }

    protected File getOverlay() {
        return this.overlay;
    }

    protected double getBaseValue() {
        return this.baseValue;
    }

    protected int getScaleIndex() {
        return this.scaleIndex;
    }

    protected GridRange getGridRange() {
        return this.gridRange;
    }

    protected ValueAxisUnit getValueAxis() {
        return this.vAxis;
    }

    protected TimeAxisUnit getTimeAxis() {
        return this.tAxis;
    }

    protected int getFirstDayOfWeek() {
        return this.firstDayOfWeek;
    }

    protected PlotDef[] getPlotDefs() {
        return this.plotDefs.toArray(new PlotDef[0]);
    }

    protected Comment[] getComments() {
        return this.comments.toArray(new Comment[0]);
    }

    protected int getCommentLineCount() {
        return this.comments.size() > 0 ? this.commentLines + this.commentLineShift : 0;
    }

    private void addComment(Comment cmt) {
        this.commentLines += cmt.getLineCount();
        this.commentLineShift = cmt.isCompleteLine() ? 0 : 1;
        this.comments.add(cmt);
    }

    private void addLegend(String legend, Color color) throws RrdException {
        this.addComment(new Legend(legend, color, this.plotDefs.size() - 1));
    }
}

