/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.graph;

import java.util.ArrayList;
import org.jrobin.core.RrdException;
import org.jrobin.core.Util;
import org.jrobin.graph.Cdef;
import org.jrobin.graph.Source;

class RpnCalculator {
    public static final byte TKN_CONSTANT = 0;
    public static final byte TKN_DATASOURCE = 1;
    public static final byte TKN_PLUS = 2;
    public static final byte TKN_MINUS = 3;
    public static final byte TKN_MULTIPLY = 4;
    public static final byte TKN_DIVIDE = 5;
    public static final byte TKN_MOD = 6;
    public static final byte TKN_SIN = 7;
    public static final byte TKN_COS = 8;
    public static final byte TKN_LOG = 9;
    public static final byte TKN_EXP = 10;
    public static final byte TKN_FLOOR = 11;
    public static final byte TKN_CEIL = 12;
    public static final byte TKN_ROUND = 13;
    public static final byte TKN_POW = 14;
    public static final byte TKN_ABS = 15;
    public static final byte TKN_SQRT = 16;
    public static final byte TKN_RANDOM = 17;
    public static final byte TKN_LT = 18;
    public static final byte TKN_LE = 19;
    public static final byte TKN_GT = 20;
    public static final byte TKN_GE = 21;
    public static final byte TKN_EQ = 22;
    public static final byte TKN_IF = 23;
    public static final byte TKN_MIN = 24;
    public static final byte TKN_MAX = 25;
    public static final byte TKN_LIMIT = 26;
    public static final byte TKN_DUP = 27;
    public static final byte TKN_EXC = 28;
    public static final byte TKN_POP = 29;
    public static final byte TKN_UN = 30;
    public static final byte TKN_UNKN = 31;
    public static final byte TKN_NOW = 32;
    public static final byte TKN_TIME = 33;
    public static final byte TKN_PI = 34;
    public static final byte TKN_E = 35;
    public static final byte TKN_AND = 36;
    public static final byte TKN_OR = 37;
    public static final byte TKN_XOR = 38;
    public static final byte TKN_SAMPLES = 39;
    public static final byte TKN_STEP = 40;
    private double step;
    private Source[] sources;
    private ArrayList stack = new ArrayList();

    RpnCalculator(Source[] sources, double step) {
        this.sources = sources;
        this.step = step;
    }

    public double evaluate(Cdef cdef, int row, long timestamp) throws RrdException {
        this.stack.clear();
        byte[] tokens = cdef.getTokens();
        int[] dsIndices = cdef.getDsIndices();
        double[] constants = cdef.getConstants();
        block43: for (int i = 0; i < tokens.length; ++i) {
            switch (tokens[i]) {
                case 0: {
                    this.push(constants[i]);
                    continue block43;
                }
                case 1: {
                    this.push(this.sources[dsIndices[i]].get(row));
                    continue block43;
                }
                case 2: {
                    this.push(this.pop() + this.pop());
                    continue block43;
                }
                case 3: {
                    double x2 = this.pop();
                    double x1 = this.pop();
                    this.push(x1 - x2);
                    continue block43;
                }
                case 4: {
                    this.push(this.pop() * this.pop());
                    continue block43;
                }
                case 5: {
                    double x2 = this.pop();
                    double x1 = this.pop();
                    this.push(x1 / x2);
                    continue block43;
                }
                case 6: {
                    double x2 = this.pop();
                    double x1 = this.pop();
                    this.push(x1 % x2);
                    continue block43;
                }
                case 7: {
                    this.push(Math.sin(this.pop()));
                    continue block43;
                }
                case 8: {
                    this.push(Math.cos(this.pop()));
                    continue block43;
                }
                case 9: {
                    this.push(Math.log(this.pop()));
                    continue block43;
                }
                case 10: {
                    this.push(Math.exp(this.pop()));
                    continue block43;
                }
                case 11: {
                    this.push(Math.floor(this.pop()));
                    continue block43;
                }
                case 12: {
                    this.push(Math.ceil(this.pop()));
                    continue block43;
                }
                case 13: {
                    this.push(Math.round(this.pop()));
                    continue block43;
                }
                case 14: {
                    double x2 = this.pop();
                    double x1 = this.pop();
                    this.push(Math.pow(x1, x2));
                    continue block43;
                }
                case 15: {
                    this.push(Math.abs(this.pop()));
                    continue block43;
                }
                case 16: {
                    this.push(Math.sqrt(this.pop()));
                    continue block43;
                }
                case 17: {
                    this.push(Math.random());
                    continue block43;
                }
                case 18: {
                    double x2 = this.pop();
                    double x1 = this.pop();
                    this.push(x1 < x2 ? 1.0 : 0.0);
                    continue block43;
                }
                case 19: {
                    double x2 = this.pop();
                    double x1 = this.pop();
                    this.push(x1 <= x2 ? 1.0 : 0.0);
                    continue block43;
                }
                case 20: {
                    double x2 = this.pop();
                    double x1 = this.pop();
                    this.push(x1 > x2 ? 1.0 : 0.0);
                    continue block43;
                }
                case 21: {
                    double x2 = this.pop();
                    double x1 = this.pop();
                    this.push(x1 >= x2 ? 1.0 : 0.0);
                    continue block43;
                }
                case 22: {
                    double x2 = this.pop();
                    double x1 = this.pop();
                    this.push(x1 == x2 ? 1.0 : 0.0);
                    continue block43;
                }
                case 23: {
                    double x3 = this.pop();
                    double x2 = this.pop();
                    double x1 = this.pop();
                    this.push(x1 != 0.0 ? x2 : x3);
                    continue block43;
                }
                case 24: {
                    this.push(Math.min(this.pop(), this.pop()));
                    continue block43;
                }
                case 25: {
                    this.push(Math.max(this.pop(), this.pop()));
                    continue block43;
                }
                case 26: {
                    double high = this.pop();
                    double low = this.pop();
                    double value = this.pop();
                    this.push(value < low || value > high ? Double.NaN : value);
                    continue block43;
                }
                case 27: {
                    double x = this.pop();
                    this.push(x);
                    this.push(x);
                    continue block43;
                }
                case 28: {
                    double x2 = this.pop();
                    double x1 = this.pop();
                    this.push(x2);
                    this.push(x1);
                    continue block43;
                }
                case 29: {
                    this.pop();
                    continue block43;
                }
                case 30: {
                    this.push(Double.isNaN(this.pop()) ? 1.0 : 0.0);
                    continue block43;
                }
                case 31: {
                    this.push(Double.NaN);
                    continue block43;
                }
                case 32: {
                    this.push(Util.getTime());
                    continue block43;
                }
                case 33: {
                    this.push(timestamp);
                    continue block43;
                }
                case 34: {
                    this.push(Math.PI);
                    continue block43;
                }
                case 35: {
                    this.push(Math.E);
                    continue block43;
                }
                case 36: {
                    double x2 = this.pop();
                    double x1 = this.pop();
                    this.push(x1 != 0.0 && x2 != 0.0 ? 1.0 : 0.0);
                    continue block43;
                }
                case 37: {
                    double x2 = this.pop();
                    double x1 = this.pop();
                    this.push(x1 != 0.0 || x2 != 0.0 ? 1.0 : 0.0);
                    continue block43;
                }
                case 38: {
                    double x2 = this.pop();
                    double x1 = this.pop();
                    this.push(x1 != 0.0 && x2 == 0.0 || x1 == 0.0 && x2 != 0.0 ? 1.0 : 0.0);
                    continue block43;
                }
                case 39: {
                    this.push(cdef.getSampleCount());
                    continue block43;
                }
                case 40: {
                    this.push(this.step);
                }
            }
        }
        if (this.stack.size() != 1) {
            throw new RrdException("RPN error, invalid stack length");
        }
        return this.pop();
    }

    private void push(double value) {
        this.stack.add(new Double(value));
    }

    private double pop() throws RrdException {
        int last = this.stack.size() - 1;
        if (last < 0) {
            throw new RrdException("POP failed, stack empty");
        }
        Double lastValue = (Double)this.stack.remove(last);
        return lastValue;
    }
}

