/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.icbm;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.LiveWritable;
import net.kano.joscar.MiscTools;
import net.kano.joscar.snaccmd.FullUserInfo;
import org.jetbrains.annotations.Nullable;

public class MissedMsgInfo
implements LiveWritable {
    public static final int REASON_TOO_LARGE = 1;
    public static final int REASON_TOO_FAST = 2;
    public static final int REASON_SENDER_WARNING_LEVEL = 3;
    public static final int REASON_YOUR_WARNING_LEVEL = 4;
    private final int channel;
    private final FullUserInfo userInfo;
    private final int number;
    private final int reason;
    private final int totalSize;

    @Nullable
    protected static MissedMsgInfo readMissedMsgInfo(ByteBlock block) {
        FullUserInfo userInfo;
        DefensiveTools.checkNull((Object)block, (String)"block");
        if (block.getLength() < 7) {
            return null;
        }
        int channel = BinaryTools.getUShort((ByteBlock)block, (int)0);
        ByteBlock userBlock = block.subBlock(2);
        ByteBlock rest = userBlock.subBlock((userInfo = FullUserInfo.readUserInfo(userBlock)).getTotalSize());
        if (rest.getLength() < 4) {
            return null;
        }
        int missed = BinaryTools.getUShort((ByteBlock)rest, (int)0) - 1;
        int reason = BinaryTools.getUShort((ByteBlock)rest, (int)2);
        ByteBlock next = rest.subBlock(4);
        return new MissedMsgInfo(channel, userInfo, missed, reason, next.getOffset() - block.getOffset());
    }

    public MissedMsgInfo(int channel, FullUserInfo userInfo, int number, int reason) {
        this(channel, userInfo, number, reason, -1);
    }

    private MissedMsgInfo(int channel, FullUserInfo userInfo, int number, int reason, int totalSize) {
        DefensiveTools.checkRange((int)channel, (String)"channel", (int)0);
        DefensiveTools.checkRange((int)number, (String)"number", (int)0);
        DefensiveTools.checkRange((int)reason, (String)"reason", (int)0);
        DefensiveTools.checkRange((int)totalSize, (String)"totalSize", (int)-1);
        this.channel = channel;
        this.userInfo = userInfo;
        this.number = number;
        this.reason = reason;
        this.totalSize = totalSize;
    }

    public final int getChannel() {
        return this.channel;
    }

    public final FullUserInfo getUserInfo() {
        return this.userInfo;
    }

    public final int getNumberMissed() {
        return this.number;
    }

    public final int getReasonCode() {
        return this.reason;
    }

    public final int getTotalSize() {
        return this.totalSize;
    }

    public void write(OutputStream out) throws IOException {
        BinaryTools.writeUShort((OutputStream)out, (int)this.channel);
        this.userInfo.write(out);
        BinaryTools.writeUShort((OutputStream)out, (int)(this.number + 1));
        BinaryTools.writeUShort((OutputStream)out, (int)this.reason);
    }

    public String toString() {
        String reasonValue = MiscTools.findIntField(MissedMsgInfo.class, this.reason, "REASON_.*");
        if (reasonValue == null) {
            reasonValue = "0x" + Integer.toHexString(this.reason);
        }
        return "MissedMsgInfo from " + this.userInfo.getScreenname() + ": " + this.number + " missed on channel " + this.channel + ", reason=" + reasonValue;
    }
}

