/*
 * Decompiled with CFR 0.152.
 */
package com.voxeo.utils;

import java.math.BigDecimal;
import java.math.RoundingMode;

public class BigDecimals {
    public static BigDecimal average(BigDecimal value, Number divisor, int scale) {
        value = value.setScale(scale);
        BigDecimal d = BigDecimals.valueOf(divisor, scale);
        if (d.equals(BigDecimals.zero(scale))) {
            if (!value.equals(BigDecimals.zero(scale))) {
                throw new IllegalArgumentException("Attempt to divide non-zero value by zero");
            }
            return BigDecimals.zero(scale);
        }
        return value.divide(d, scale, RoundingMode.HALF_UP);
    }

    public static BigDecimal zero(int ... scale) {
        if (scale.length > 0) {
            return BigDecimal.ZERO.setScale(scale[0]);
        }
        return BigDecimal.ZERO;
    }

    public static BigDecimal valueOf(Number value) {
        if (value == null) {
            return (BigDecimal)value;
        }
        if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        if (value instanceof Long) {
            return new BigDecimal(value.intValue());
        }
        if (value instanceof Integer) {
            return new BigDecimal(value.intValue());
        }
        return new BigDecimal(value.toString());
    }

    public static BigDecimal valueOf(Number value, int scale) {
        BigDecimal result = BigDecimals.valueOf(value);
        return result != null ? result.setScale(scale, RoundingMode.HALF_UP) : null;
    }
}

