/*
 * Decompiled with CFR 0.152.
 */
package org.jugbb.ant.iconcodegen;

import java.io.File;
import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.jugbb.ant.iconcodegen.IconCodeGenerator;

public class ImageCodeGenTask
extends Task {
    private String iconPackage = null;
    private String sourceDir = null;
    private String iconFileExtensions = "jpg png gif";
    private String encoding = "UTF-8";

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getImageFileExtensions() {
        return this.iconFileExtensions;
    }

    public void setImageFileExtensions(String iconFileExtensions) {
        this.iconFileExtensions = iconFileExtensions;
    }

    public String getImagePackage() {
        return this.iconPackage;
    }

    public void setImagePackage(String iconPackage) {
        this.iconPackage = iconPackage;
    }

    public String getSourceDir() {
        return this.sourceDir;
    }

    public void setSourceDir(String sourceDir) {
        this.sourceDir = sourceDir;
    }

    public void execute() throws BuildException {
        if (this.sourceDir == null || this.sourceDir.isEmpty()) {
            throw new BuildException("sourceDir cannot be null or empty");
        }
        if (this.iconPackage == null || this.iconPackage.isEmpty()) {
            throw new BuildException("iconPackage cannot be null or empty");
        }
        if (this.iconFileExtensions == null || this.iconFileExtensions.isEmpty()) {
            throw new BuildException("iconFileExtensions cannot be null or empty");
        }
        this.log("creating ApplicationIcons class in src-dir: " + this.sourceDir + " in package: " + this.iconPackage + " and use only icon files with extension: " + this.iconFileExtensions);
        try {
            IconCodeGenerator.createImageProvider(new File(this.sourceDir), this.iconPackage, this.iconFileExtensions, "UTF-8");
            this.log("Java code successfully created");
        }
        catch (IOException e) {
            throw new BuildException("failed: " + e.getMessage(), (Throwable)e);
        }
    }
}

