/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl.client;

import com.hazelcast.cache.impl.CacheEventData;
import com.hazelcast.cache.impl.CacheEventListener;
import com.hazelcast.cache.impl.CacheEventSet;
import com.hazelcast.cache.impl.CachePortableHook;
import com.hazelcast.cache.impl.CacheService;
import com.hazelcast.client.ClientEndpoint;
import com.hazelcast.client.impl.client.CallableClientRequest;
import com.hazelcast.client.impl.client.RetryableRequest;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.DefaultData;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import java.io.IOException;
import java.security.Permission;
import java.util.Set;

public class CacheAddEntryListenerRequest
extends CallableClientRequest
implements RetryableRequest {
    private String name;

    public CacheAddEntryListenerRequest() {
    }

    public CacheAddEntryListenerRequest(String name) {
        this.name = name;
    }

    public Object call() {
        final ClientEndpoint endpoint = this.getEndpoint();
        CacheService service = (CacheService)this.getService();
        CacheEventListener entryListener = new CacheEventListener(){

            @Override
            public void handleEvent(Object eventObject) {
                if (endpoint.isAlive()) {
                    Data partitionKey = CacheAddEntryListenerRequest.this.getPartitionKey(eventObject);
                    endpoint.sendEvent(partitionKey, eventObject, CacheAddEntryListenerRequest.this.getCallId());
                }
            }
        };
        return service.registerListener(this.name, entryListener);
    }

    private Data getPartitionKey(Object eventObject) {
        Data partitionKey = null;
        if (eventObject instanceof CacheEventSet) {
            Set<CacheEventData> events = ((CacheEventSet)eventObject).getEvents();
            if (events.size() > 1) {
                partitionKey = new DefaultData();
            } else if (events.size() == 1) {
                partitionKey = events.iterator().next().getDataKey();
            }
        } else if (eventObject instanceof CacheEventData) {
            partitionKey = ((CacheEventData)eventObject).getDataKey();
        }
        return partitionKey;
    }

    @Override
    public String getServiceName() {
        return "hz:impl:cacheService";
    }

    @Override
    public int getFactoryId() {
        return CachePortableHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 22;
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        super.write(writer);
        writer.writeUTF("n", this.name);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        super.read(reader);
        this.name = reader.readUTF("n");
    }

    @Override
    public Permission getRequiredPermission() {
        return null;
    }
}

