/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.conn;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.conn.ConnCommand;

public class RateAck
extends ConnCommand {
    private final int[] classes;

    protected RateAck(SnacPacket snacPacket) {
        super(8);
        DefensiveTools.checkNull(snacPacket, "packet");
        ByteBlock byteBlock = snacPacket.getData();
        this.classes = new int[byteBlock.getLength() / 2];
        for (int i = 0; i < this.classes.length; ++i) {
            this.classes[i] = BinaryTools.getUShort(byteBlock, i * 2);
        }
    }

    public RateAck(int[] nArray) {
        super(8);
        this.classes = (int[])(nArray == null ? null : nArray.clone());
    }

    public final int[] getClasses() {
        return (int[])(this.classes == null ? null : this.classes.clone());
    }

    public void writeData(OutputStream outputStream) throws IOException {
        if (this.classes != null) {
            for (int i = 0; i < this.classes.length; ++i) {
                BinaryTools.writeUShort(outputStream, this.classes[i]);
            }
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("RateAck for classes: ");
        if (this.classes != null) {
            for (int i = 0; i < this.classes.length; ++i) {
                stringBuffer.append(this.classes[i]).append(", ");
            }
        }
        return stringBuffer.toString();
    }
}

