/*
 * Decompiled with CFR 0.152.
 */
package com.voxeo.moho.conference;

import com.voxeo.moho.Call;
import com.voxeo.moho.MediaException;
import com.voxeo.moho.Participant;
import com.voxeo.moho.State;
import com.voxeo.moho.conference.Conference;
import com.voxeo.moho.conference.ConferenceController;
import com.voxeo.moho.conference.ConferenceFullException;
import com.voxeo.moho.conference.ConferencePasswordNoMatchException;
import com.voxeo.moho.event.InputCompleteEvent;
import com.voxeo.moho.event.Observer;
import com.voxeo.moho.media.Prompt;
import com.voxeo.moho.media.input.Grammar;
import com.voxeo.moho.media.input.InputCommand;
import com.voxeo.moho.media.output.AudibleResource;
import com.voxeo.moho.media.output.OutputCommand;
import java.util.concurrent.ExecutionException;

public class SimpleConferenceController
implements ConferenceController {
    protected OutputCommand _enter;
    protected InputCommand _pass;
    protected OutputCommand _exit;
    protected InputCommand _term;
    protected int _repeat = 0;

    public SimpleConferenceController() {
    }

    public SimpleConferenceController(AudibleResource enterAnnouncement, AudibleResource exitAnnoucement, Grammar term) {
        this(enterAnnouncement == null ? null : new OutputCommand(enterAnnouncement), null, 0, term == null ? null : new InputCommand(term), exitAnnoucement == null ? null : new OutputCommand(exitAnnoucement));
    }

    public SimpleConferenceController(OutputCommand enterAnnouncement, InputCommand pass, int repeat, InputCommand term, OutputCommand exitAnnouncement) {
        this._enter = enterAnnouncement;
        this._exit = exitAnnouncement;
        this._term = term;
        this._repeat = repeat;
        this._pass = pass;
    }

    @Override
    public void preJoin(Participant p, Conference f) {
        block12: {
            if (f.getOccupiedSeats() >= f.getMaxSeats()) {
                throw new ConferenceFullException();
            }
            if (p instanceof Call && (this._enter != null || this._pass != null)) {
                if (p.getMediaObject() == null) {
                    try {
                        ((Call)p).join().get();
                    }
                    catch (Exception e) {
                        throw new MediaException(e);
                    }
                }
                Prompt prompt = ((Call)p).prompt(this._enter, this._pass, this._repeat);
                if (this._pass != null) {
                    try {
                        if (!((InputCompleteEvent)prompt.getInput().get()).hasMatch()) {
                            throw new ConferencePasswordNoMatchException();
                        }
                        break block12;
                    }
                    catch (InterruptedException e) {
                        throw new MediaException(e);
                    }
                    catch (ExecutionException e) {
                        throw new MediaException(e);
                    }
                }
                try {
                    prompt.getOutput().get();
                }
                catch (Exception e) {
                    throw new MediaException(e);
                }
            }
        }
    }

    @Override
    public void postJoin(final Participant p, final Conference f) {
        if (p instanceof Call && this._term != null) {
            Call call = (Call)p;
            Observer observer = new Observer(){

                @State
                public void handleEvent(InputCompleteEvent<Call> event) {
                    if (event.hasMatch()) {
                        f.unjoin(p);
                    }
                }
            };
            call.addObserver(observer);
            try {
                call.input(this._term);
            }
            catch (MediaException e) {
                call.removeObserver(observer);
                throw e;
            }
        }
    }

    @Override
    public void preUnjoin(Participant p, Conference f) {
    }

    @Override
    public void postUnjoin(Participant p, Conference f) {
        if (p instanceof Call && this._exit != null) {
            Call call = (Call)p;
            try {
                call.output(this._exit).get();
            }
            catch (InterruptedException e) {
                throw new MediaException(e);
            }
            catch (ExecutionException e) {
                throw new MediaException(e);
            }
        }
    }
}

