/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.receipts;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.PacketExtensionFilter;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smackx.ServiceDiscoveryManager;
import org.jivesoftware.smackx.packet.DiscoverInfo;
import org.jivesoftware.smackx.receipts.DeliveryReceipt;
import org.jivesoftware.smackx.receipts.DeliveryReceiptRequest;
import org.jivesoftware.smackx.receipts.ReceiptReceivedListener;

public class DeliveryReceiptManager
implements PacketListener {
    private static Map<Connection, DeliveryReceiptManager> instances = Collections.synchronizedMap(new WeakHashMap());
    private Connection connection;
    private boolean auto_receipts_enabled = false;
    private Set<ReceiptReceivedListener> receiptReceivedListeners = Collections.synchronizedSet(new HashSet());

    private DeliveryReceiptManager(Connection connection) {
        ServiceDiscoveryManager sdm = ServiceDiscoveryManager.getInstanceFor(connection);
        sdm.addFeature("urn:xmpp:receipts");
        this.connection = connection;
        instances.put(connection, this);
        connection.addPacketListener(this, new PacketExtensionFilter("urn:xmpp:receipts"));
    }

    public static synchronized DeliveryReceiptManager getInstanceFor(Connection connection) {
        DeliveryReceiptManager receiptManager = instances.get(connection);
        if (receiptManager == null) {
            receiptManager = new DeliveryReceiptManager(connection);
        }
        return receiptManager;
    }

    public boolean isSupported(String jid) {
        try {
            DiscoverInfo result = ServiceDiscoveryManager.getInstanceFor(this.connection).discoverInfo(jid);
            return result.containsFeature("urn:xmpp:receipts");
        }
        catch (XMPPException e) {
            return false;
        }
    }

    @Override
    public void processPacket(Packet packet) {
        DeliveryReceiptRequest drr;
        DeliveryReceipt dr = (DeliveryReceipt)packet.getExtension("received", "urn:xmpp:receipts");
        if (dr != null) {
            for (ReceiptReceivedListener l : this.receiptReceivedListeners) {
                l.onReceiptReceived(packet.getFrom(), packet.getTo(), dr.getId());
            }
        }
        if (this.auto_receipts_enabled && (drr = (DeliveryReceiptRequest)packet.getExtension("request", "urn:xmpp:receipts")) != null) {
            Message ack = new Message(packet.getFrom(), Message.Type.normal);
            ack.addExtension(new DeliveryReceipt(packet.getPacketID()));
            this.connection.sendPacket(ack);
        }
    }

    public void setAutoReceiptsEnabled(boolean new_state) {
        this.auto_receipts_enabled = new_state;
    }

    public void enableAutoReceipts() {
        this.setAutoReceiptsEnabled(true);
    }

    public void disableAutoReceipts() {
        this.setAutoReceiptsEnabled(false);
    }

    public boolean getAutoReceiptsEnabled() {
        return this.auto_receipts_enabled;
    }

    public void addReceiptReceivedListener(ReceiptReceivedListener listener) {
        this.receiptReceivedListeners.add(listener);
    }

    public void removeReceiptReceivedListener(ReceiptReceivedListener listener) {
        this.receiptReceivedListeners.remove(listener);
    }

    public static boolean hasDeliveryReceiptRequest(Packet p) {
        return p.getExtension("request", "urn:xmpp:receipts") != null;
    }

    public static void addDeliveryReceiptRequest(Message m) {
        m.addExtension(new DeliveryReceiptRequest());
    }

    static {
        Connection.addConnectionCreationListener(new ConnectionCreationListener(){

            @Override
            public void connectionCreated(Connection connection) {
                new DeliveryReceiptManager(connection);
            }
        });
    }
}

