/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.stack;

import com.sun.stun.StunClient;
import com.sun.stun.StunServer;
import gov.nist.core.HostPort;
import gov.nist.core.InternalErrorHandler;
import gov.nist.core.ThreadAuditor;
import gov.nist.javax.sip.stack.MessageChannel;
import gov.nist.javax.sip.stack.MessageProcessor;
import gov.nist.javax.sip.stack.SIPTransactionStack;
import gov.nist.javax.sip.stack.StunServerFactory;
import gov.nist.javax.sip.stack.UDPMessageChannel;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.LinkedList;

public class UDPMessageProcessor
extends MessageProcessor {
    private static final int HIGHWAT = 100;
    private static final int LOWAT = 50;
    private int port;
    protected LinkedList messageQueue;
    protected LinkedList messageChannels;
    protected int threadPoolSize;
    protected static final int MAX_DATAGRAM_SIZE = 8192;
    protected SIPTransactionStack sipStack;
    protected DatagramSocket sock;
    protected boolean isRunning;
    private static StunServer stunServer;
    private static InetAddress registrarAddress;
    private static int registrarPort;
    private InetSocketAddress publicAddress;

    public InetSocketAddress getPublicAddress() {
        return this.publicAddress;
    }

    protected UDPMessageProcessor(InetAddress inetAddress, SIPTransactionStack sIPTransactionStack, int n) throws IOException {
        super(inetAddress, n, "udp");
        this.sipStack = sIPTransactionStack;
        this.messageQueue = new LinkedList();
        this.port = n;
        try {
            this.sock = sIPTransactionStack.getNetworkLayer().createDatagramSocket(n, inetAddress);
            this.sock.setReceiveBufferSize(8192);
            if (registrarAddress != null) {
                try {
                    StunClient stunClient = new StunClient(new InetSocketAddress(registrarAddress, registrarPort), this.sock);
                    this.publicAddress = stunClient.getMappedAddress();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.publicAddress == null) {
                this.publicAddress = new InetSocketAddress(inetAddress, n);
            }
            if (sIPTransactionStack.getThreadAuditor().isEnabled()) {
                this.sock.setSoTimeout((int)sIPTransactionStack.getThreadAuditor().getPingIntervalInMillisecs());
            }
            if (inetAddress.getHostAddress().equals("0.0.0.0") || inetAddress.getHostAddress().equals("::0")) {
                super.setIpAddress(this.sock.getLocalAddress());
            }
        }
        catch (SocketException socketException) {
            throw new IOException(socketException.getMessage());
        }
    }

    public int getPort() {
        return this.port;
    }

    public void start() throws IOException {
        this.isRunning = true;
        Thread thread = new Thread(this);
        thread.setDaemon(true);
        thread.setName("UDPMessageProcessorThread");
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void run() {
        this.messageChannels = new LinkedList();
        if (this.sipStack.threadPoolSize != -1) {
            for (int i = 0; i < this.sipStack.threadPoolSize; ++i) {
                UDPMessageChannel uDPMessageChannel = new UDPMessageChannel(this.sipStack, this);
                this.messageChannels.add(uDPMessageChannel);
            }
        }
        ThreadAuditor.ThreadHandle threadHandle = this.sipStack.getThreadAuditor().addCurrentThread();
        while (this.isRunning) {
            Object object;
            try {
                threadHandle.ping();
                int n = this.sock.getReceiveBufferSize();
                object = new byte[n];
                DatagramPacket datagramPacket = new DatagramPacket((byte[])object, n);
                this.sock.receive(datagramPacket);
                if (object[0] == 0 && object[1] == 1) {
                    if (stunServer == null) {
                        System.out.println("Ignoring STUN request from " + datagramPacket.getAddress());
                        continue;
                    }
                    stunServer.processStunRequest(this.sock, datagramPacket);
                    continue;
                }
                if (this.messageQueue.size() >= 100) {
                    if (!this.sipStack.logWriter.isLoggingEnabled()) continue;
                    this.sipStack.logWriter.logDebug("Dropping message -- queue length exceeded");
                    continue;
                }
                if (this.messageQueue.size() > 50 && this.messageQueue.size() < 100) {
                    boolean bl;
                    float f = (float)(this.messageQueue.size() - 50) / 50.0f;
                    boolean bl2 = bl = Math.random() > 1.0 - (double)f;
                    if (bl) {
                        if (!this.sipStack.logWriter.isLoggingEnabled()) continue;
                        this.sipStack.logWriter.logDebug("Dropping message with probability \t" + (1.0 - (double)f));
                        continue;
                    }
                }
                if (this.sipStack.threadPoolSize != -1) {
                    LinkedList linkedList = this.messageQueue;
                    // MONITORENTER : linkedList
                    this.messageQueue.addLast(datagramPacket);
                    this.messageQueue.notify();
                    // MONITOREXIT : linkedList
                    continue;
                }
                new UDPMessageChannel(this.sipStack, this, datagramPacket);
            }
            catch (SocketTimeoutException socketTimeoutException) {
            }
            catch (SocketException socketException) {
                if (this.sipStack.isLoggingEnabled()) {
                    this.getSIPStack().logWriter.logDebug("UDPMessageProcessor: Stopping");
                }
                this.isRunning = false;
                LinkedList linkedList = this.messageQueue;
                object = linkedList;
                // MONITORENTER : linkedList
                this.messageQueue.notifyAll();
                // MONITOREXIT : object
            }
            catch (IOException iOException) {
                this.isRunning = false;
                iOException.printStackTrace();
                if (!this.sipStack.isLoggingEnabled()) continue;
                this.getSIPStack().logWriter.logDebug("UDPMessageProcessor: Got an IO Exception");
            }
        }
        return;
        {
            catch (Exception exception) {
                if (this.sipStack.isLoggingEnabled()) {
                    this.getSIPStack().logWriter.logDebug("UDPMessageProcessor: Unexpected Exception - quitting");
                }
                InternalErrorHandler.handleException(exception);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        LinkedList linkedList = this.messageQueue;
        synchronized (linkedList) {
            this.isRunning = false;
            this.messageQueue.notifyAll();
            this.sock.close();
        }
    }

    public String getTransport() {
        return "udp";
    }

    public SIPTransactionStack getSIPStack() {
        return this.sipStack;
    }

    public MessageChannel createMessageChannel(HostPort hostPort) throws UnknownHostException {
        return new UDPMessageChannel(hostPort.getInetAddress(), hostPort.getPort(), this.sipStack, this);
    }

    public MessageChannel createMessageChannel(InetAddress inetAddress, int n) throws IOException {
        return new UDPMessageChannel(inetAddress, n, this.sipStack, this);
    }

    public int getDefaultTargetPort() {
        return 5060;
    }

    public boolean isSecure() {
        return false;
    }

    public int getMaximumMessageSize() {
        return 8192;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean inUse() {
        LinkedList linkedList = this.messageQueue;
        synchronized (linkedList) {
            return this.messageQueue.size() != 0;
        }
    }

    static {
        registrarPort = 5060;
        stunServer = StunServerFactory.getInstance();
        String string = System.getProperty("com.sun.mc.softphone.sip.REGISTRAR_ADDRESS");
        int n = -1;
        if (string != null) {
            n = string.indexOf(";sip-stun");
        }
        if (string != null && string.length() != 0 && n >= 0) {
            string = string.substring(0, n);
            try {
                registrarAddress = InetAddress.getByName(string);
            }
            catch (UnknownHostException unknownHostException) {
                System.out.println("UDPMessageProcessor: unable to resolve registrar address " + string + " " + unknownHostException.getMessage());
            }
        }
        if ((string = System.getProperty("com.sun.mc.softphone.sip.REGISTRAR_UDP_PORT")) != null && string.length() > 0) {
            try {
                registrarPort = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("Invalid registrar port " + string + ".  Defaulting to " + registrarPort);
            }
        }
    }
}

