/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.stack;

import gov.nist.core.GenericObject;
import gov.nist.core.InternalErrorHandler;
import gov.nist.core.ThreadAuditor;
import gov.nist.javax.sip.header.CSeq;
import gov.nist.javax.sip.header.CallID;
import gov.nist.javax.sip.header.From;
import gov.nist.javax.sip.header.ParametersHeader;
import gov.nist.javax.sip.header.RequestLine;
import gov.nist.javax.sip.header.RetryAfter;
import gov.nist.javax.sip.header.Server;
import gov.nist.javax.sip.header.StatusLine;
import gov.nist.javax.sip.header.To;
import gov.nist.javax.sip.header.Via;
import gov.nist.javax.sip.header.ViaList;
import gov.nist.javax.sip.message.SIPMessage;
import gov.nist.javax.sip.message.SIPRequest;
import gov.nist.javax.sip.message.SIPResponse;
import gov.nist.javax.sip.parser.ParseExceptionListener;
import gov.nist.javax.sip.parser.StringMsgParser;
import gov.nist.javax.sip.stack.MessageChannel;
import gov.nist.javax.sip.stack.SIPClientTransaction;
import gov.nist.javax.sip.stack.SIPServerTransaction;
import gov.nist.javax.sip.stack.SIPTransaction;
import gov.nist.javax.sip.stack.SIPTransactionStack;
import gov.nist.javax.sip.stack.UDPMessageProcessor;
import java.io.IOException;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.Socket;
import java.text.ParseException;
import java.util.LinkedList;

public class UDPMessageChannel
extends MessageChannel
implements ParseExceptionListener,
Runnable {
    protected SIPTransactionStack sipStack;
    protected StringMsgParser myParser;
    private InetAddress peerAddress;
    private String myAddress;
    private int peerPacketSourcePort;
    private InetAddress peerPacketSourceAddress;
    private int peerPort;
    private String peerProtocol;
    protected int myPort;
    private DatagramPacket incomingPacket;
    private long receptionTime;

    protected UDPMessageChannel(SIPTransactionStack sIPTransactionStack, UDPMessageProcessor uDPMessageProcessor) {
        this.messageProcessor = uDPMessageProcessor;
        this.sipStack = sIPTransactionStack;
        Thread thread = new Thread(this);
        this.myAddress = uDPMessageProcessor.getIpAddress().getHostAddress();
        this.myPort = uDPMessageProcessor.getPort();
        thread.setName("UDPMessageChannelThread");
        thread.setDaemon(true);
        thread.start();
    }

    protected UDPMessageChannel(SIPTransactionStack sIPTransactionStack, UDPMessageProcessor uDPMessageProcessor, DatagramPacket datagramPacket) {
        this.incomingPacket = datagramPacket;
        this.messageProcessor = uDPMessageProcessor;
        this.sipStack = sIPTransactionStack;
        this.myAddress = uDPMessageProcessor.getIpAddress().getHostAddress();
        this.myPort = uDPMessageProcessor.getPort();
        Thread thread = new Thread(this);
        thread.setDaemon(true);
        thread.start();
    }

    protected UDPMessageChannel(InetAddress inetAddress, int n, SIPTransactionStack sIPTransactionStack, UDPMessageProcessor uDPMessageProcessor) {
        this.peerAddress = inetAddress;
        this.peerPort = n;
        this.peerProtocol = "UDP";
        this.messageProcessor = uDPMessageProcessor;
        this.myAddress = uDPMessageProcessor.getIpAddress().getHostAddress();
        this.myPort = uDPMessageProcessor.getPort();
        this.sipStack = sIPTransactionStack;
        if (sIPTransactionStack.isLoggingEnabled()) {
            this.sipStack.logWriter.logDebug("Creating message channel " + inetAddress.getHostAddress() + "/" + n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        ThreadAuditor.ThreadHandle threadHandle = null;
        do {
            DatagramPacket datagramPacket;
            if (this.myParser == null) {
                this.myParser = new StringMsgParser();
                this.myParser.setParseExceptionListener(this);
            }
            if (this.sipStack.threadPoolSize != -1) {
                LinkedList linkedList = ((UDPMessageProcessor)this.messageProcessor).messageQueue;
                synchronized (linkedList) {
                    while (((UDPMessageProcessor)this.messageProcessor).messageQueue.isEmpty()) {
                        if (!((UDPMessageProcessor)this.messageProcessor).isRunning) {
                            return;
                        }
                        try {
                            if (threadHandle == null) {
                                threadHandle = this.sipStack.getThreadAuditor().addCurrentThread();
                            }
                            threadHandle.ping();
                            ((UDPMessageProcessor)this.messageProcessor).messageQueue.wait(threadHandle.getPingIntervalInMillisecs());
                        }
                        catch (InterruptedException interruptedException) {
                            if (((UDPMessageProcessor)this.messageProcessor).isRunning) continue;
                            return;
                        }
                    }
                    datagramPacket = (DatagramPacket)((UDPMessageProcessor)this.messageProcessor).messageQueue.removeFirst();
                }
                this.incomingPacket = datagramPacket;
            } else {
                datagramPacket = this.incomingPacket;
            }
            try {
                this.processIncomingDataPacket(datagramPacket);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.sipStack.logWriter.logError("Error while processing incoming UDP packet", exception);
            }
        } while (this.sipStack.threadPoolSize != -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processIncomingDataPacket(DatagramPacket datagramPacket) throws Exception {
        Object object;
        GenericObject genericObject;
        Object object2;
        this.peerAddress = datagramPacket.getAddress();
        int n = datagramPacket.getLength();
        byte[] byArray = datagramPacket.getData();
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.logWriter.logDebug("UDPMessageChannel: peerAddress = " + this.peerAddress.getHostAddress() + "/" + datagramPacket.getPort());
            this.sipStack.logWriter.logDebug("Length = " + n);
            object2 = new String(byArray2, 0, n);
            this.sipStack.logWriter.logDebug((String)object2);
        }
        object2 = null;
        try {
            this.receptionTime = System.currentTimeMillis();
            object2 = this.myParser.parseSIPMessage(byArray2);
            this.myParser = null;
        }
        catch (ParseException parseException) {
            String string;
            this.myParser = null;
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.logWriter.logDebug("Rejecting message !  " + new String(byArray2));
                this.sipStack.logWriter.logDebug("error message " + parseException.getMessage());
                this.sipStack.logWriter.logException(parseException);
            }
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.getLogWriter().logDebug(new String(byArray2));
            }
            if (!(string = new String(byArray2, 0, n)).startsWith("SIP/") && !string.startsWith("ACK ")) {
                String string2 = this.createBadReqRes(string, parseException);
                if (string2 != null) {
                    if (this.sipStack.isLoggingEnabled()) {
                        this.sipStack.getLogWriter().logDebug("Sending automatic 400 Bad Request:");
                        this.sipStack.getLogWriter().logDebug(string2);
                    }
                    try {
                        this.sendMessage(string2.getBytes(), this.peerAddress, this.peerPort, this.peerProtocol, false);
                    }
                    catch (IOException iOException) {
                        this.sipStack.logWriter.logException(iOException);
                    }
                } else if (this.sipStack.isLoggingEnabled()) {
                    this.sipStack.getLogWriter().logDebug("Could not formulate automatic 400 Bad Request");
                }
            }
            return;
        }
        if (object2 == null) {
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.logWriter.logDebug("Rejecting message !  " + new String(byArray2));
                this.sipStack.logWriter.logDebug("Null message parsed.");
            }
            return;
        }
        ViaList viaList = ((SIPMessage)object2).getViaHeaders();
        if (((SIPMessage)object2).getFrom() == null || ((SIPMessage)object2).getTo() == null || ((SIPMessage)object2).getCallId() == null || ((SIPMessage)object2).getCSeq() == null || ((SIPMessage)object2).getViaHeaders() == null) {
            String string = new String(byArray2);
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.logWriter.logError("bad message " + string);
                this.sipStack.logWriter.logError(">>> Dropped Bad Msg From = " + ((SIPMessage)object2).getFrom() + "To = " + ((SIPMessage)object2).getTo() + "CallId = " + ((SIPMessage)object2).getCallId() + "CSeq = " + ((SIPMessage)object2).getCSeq() + "Via = " + ((SIPMessage)object2).getViaHeaders());
            }
            this.sipStack.logWriter.logError("BAD MESSAGE!");
            this.sipStack.logWriter.logError(string);
            return;
        }
        if (object2 instanceof SIPRequest) {
            genericObject = (Via)viaList.getFirst();
            object = this.sipStack.addressResolver.resolveAddress(((Via)genericObject).getHop());
            this.peerPort = object.getPort();
            this.peerProtocol = ((Via)genericObject).getTransport();
            this.peerPacketSourceAddress = datagramPacket.getAddress();
            this.peerPacketSourcePort = datagramPacket.getPort();
            try {
                this.peerAddress = datagramPacket.getAddress();
                boolean bl = ((ParametersHeader)genericObject).hasParameter("rport");
                if (bl || !object.getHost().equals(this.peerAddress.getHostAddress())) {
                    ((ParametersHeader)genericObject).setParameter("received", this.peerAddress.getHostAddress());
                }
                if (bl) {
                    ((ParametersHeader)genericObject).setParameter("rport", Integer.toString(this.peerPacketSourcePort));
                }
            }
            catch (ParseException parseException) {
                InternalErrorHandler.handleException(parseException);
            }
        } else {
            this.peerPacketSourceAddress = datagramPacket.getAddress();
            this.peerPacketSourcePort = datagramPacket.getPort();
            this.peerAddress = datagramPacket.getAddress();
            this.peerPort = datagramPacket.getPort();
            this.peerProtocol = ((Via)viaList.getFirst()).getTransport();
        }
        if (object2 instanceof SIPRequest) {
            genericObject = (SIPRequest)object2;
            if (this.sipStack.logWriter.isLoggingEnabled(16)) {
                this.sipStack.serverLog.logMessage((SIPMessage)object2, this.getPeerHostPort().toString(), this.getHost() + ":" + this.myPort, false, this.receptionTime);
            }
            if ((object = this.sipStack.newSIPServerRequest((SIPRequest)genericObject, this)) == null) {
                if (this.sipStack.isLoggingEnabled()) {
                    this.sipStack.logWriter.logWarning("Null request interface returned -- dropping request");
                }
                if (!((SIPRequest)genericObject).getMethod().equals("ACK")) {
                    SIPResponse sIPResponse = ((SIPRequest)genericObject).createResponse(503);
                    sIPResponse.addHeader(this.sipStack.createServerHeaderForStack());
                    RetryAfter retryAfter = new RetryAfter();
                    try {
                        retryAfter.setRetryAfter((int)(10.0 * Math.random()));
                        sIPResponse.setHeader(retryAfter);
                        this.sendMessage(sIPResponse);
                    }
                    catch (Exception exception) {
                        this.sipStack.logWriter.logError("Exception while sending service_unavailable", exception);
                    }
                }
                return;
            }
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.logWriter.logDebug("About to process " + ((SIPRequest)genericObject).getFirstLine() + "/" + object);
            }
            try {
                object.processRequest((SIPRequest)genericObject, this);
            }
            finally {
                SIPServerTransaction sIPServerTransaction;
                if (object instanceof SIPTransaction && !(sIPServerTransaction = (SIPServerTransaction)object).passToListener()) {
                    ((SIPTransaction)object).releaseSem();
                }
            }
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.logWriter.logDebug("Done processing " + ((SIPRequest)genericObject).getFirstLine() + "/" + object);
            }
        } else {
            genericObject = (SIPResponse)object2;
            try {
                ((SIPResponse)genericObject).checkHeaders();
            }
            catch (ParseException parseException) {
                if (this.sipStack.isLoggingEnabled()) {
                    this.sipStack.logWriter.logError("Dropping Badly formatted response message >>> " + genericObject);
                }
                return;
            }
            object = this.sipStack.newSIPServerResponse((SIPResponse)genericObject, this);
            if (object != null) {
                try {
                    if (object instanceof SIPClientTransaction && !((SIPClientTransaction)object).checkFromTag((SIPResponse)genericObject)) {
                        if (this.sipStack.isLoggingEnabled()) {
                            this.sipStack.logWriter.logError("Dropping response message with invalid tag >>> " + genericObject);
                        }
                        return;
                    }
                    object.processResponse((SIPResponse)genericObject, this);
                }
                finally {
                    if (object instanceof SIPTransaction && !((SIPTransaction)object).passToListener()) {
                        ((SIPTransaction)object).releaseSem();
                    }
                }
            } else if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.logWriter.logDebug("null sipServerResponse!");
            }
        }
    }

    public void handleException(ParseException parseException, SIPMessage sIPMessage, Class clazz, String string, String string2) throws ParseException {
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.logWriter.logException(parseException);
        }
        if (clazz != null && (clazz.equals(From.class) || clazz.equals(To.class) || clazz.equals(CSeq.class) || clazz.equals(Via.class) || clazz.equals(CallID.class) || clazz.equals(RequestLine.class) || clazz.equals(StatusLine.class))) {
            this.sipStack.logWriter.logError("BAD MESSAGE!");
            this.sipStack.logWriter.logError(string2);
            throw parseException;
        }
        sIPMessage.addUnparsed(string);
    }

    public void sendMessage(SIPMessage sIPMessage) throws IOException {
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.logWriter.logStackTrace();
        }
        byte[] byArray = sIPMessage.encodeAsBytes();
        long l = System.currentTimeMillis();
        this.sendMessage(byArray, this.peerAddress, this.peerPort, this.peerProtocol, sIPMessage instanceof SIPRequest);
        if (this.sipStack.logWriter.isLoggingEnabled(16)) {
            this.logMessage(sIPMessage, this.peerAddress, this.peerPort, l);
        }
    }

    protected void sendMessage(byte[] byArray, InetAddress inetAddress, int n, boolean bl) throws IOException {
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.logWriter.logStackTrace();
        }
        if (n == -1) {
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.logWriter.logDebug(this.getClass().getName() + ":sendMessage: Dropping reply!");
            }
            throw new IOException("Receiver port not set ");
        }
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.logWriter.logDebug(this.getClass().getName() + ":sendMessage " + inetAddress.getHostAddress() + "/" + n + "\n" + new String(byArray));
            this.sipStack.logWriter.logDebug("*******************\n");
        }
        DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length, inetAddress, n);
        try {
            DatagramSocket datagramSocket;
            boolean bl2 = false;
            if (this.sipStack.udpFlag) {
                datagramSocket = ((UDPMessageProcessor)this.messageProcessor).sock;
            } else {
                datagramSocket = new DatagramSocket();
                bl2 = true;
            }
            datagramSocket.send(datagramPacket);
            if (bl2) {
                datagramSocket.close();
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            InternalErrorHandler.handleException(exception);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void sendMessage(byte[] byArray, InetAddress inetAddress, int n, String string, boolean bl) throws IOException {
        if (n == -1) {
            if (!this.sipStack.isLoggingEnabled()) throw new IOException("Receiver port not set ");
            this.sipStack.logWriter.logDebug(this.getClass().getName() + ":sendMessage: Dropping reply!");
            throw new IOException("Receiver port not set ");
        }
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.logWriter.logDebug(this.getClass().getName() + ":sendMessage " + inetAddress.getHostAddress() + "/" + n + "\n" + new String(byArray));
            this.sipStack.logWriter.logDebug("*******************\n");
        }
        if (string.compareToIgnoreCase("UDP") == 0) {
            DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length, inetAddress, n);
            try {
                DatagramSocket datagramSocket = this.sipStack.udpFlag ? ((UDPMessageProcessor)this.messageProcessor).sock : this.sipStack.getNetworkLayer().createDatagramSocket();
                if (this.sipStack.isLoggingEnabled()) {
                    this.sipStack.logWriter.logDebug("sendMessage " + inetAddress.getHostAddress() + "/" + n + "\n" + new String(byArray));
                }
                datagramSocket.send(datagramPacket);
                if (this.sipStack.udpFlag) return;
                datagramSocket.close();
                return;
            }
            catch (IOException iOException) {
                throw iOException;
            }
            catch (Exception exception) {
                InternalErrorHandler.handleException(exception);
                return;
            }
        } else {
            Socket socket = this.sipStack.ioHandler.sendBytes(this.messageProcessor.getIpAddress(), inetAddress, n, "tcp", byArray, bl);
            OutputStream outputStream = socket.getOutputStream();
            outputStream.write(byArray, 0, byArray.length);
            outputStream.flush();
        }
    }

    public SIPTransactionStack getSIPStack() {
        return this.sipStack;
    }

    public String getTransport() {
        return "udp";
    }

    public String getHost() {
        return this.messageProcessor.getIpAddress().getHostAddress();
    }

    public int getPort() {
        return ((UDPMessageProcessor)this.messageProcessor).getPort();
    }

    public String getPeerName() {
        return this.peerAddress.getHostName();
    }

    public String getPeerAddress() {
        return this.peerAddress.getHostAddress();
    }

    protected InetAddress getPeerInetAddress() {
        return this.peerAddress;
    }

    public boolean equals(Object object) {
        boolean bl;
        if (object == null) {
            return false;
        }
        if (!this.getClass().equals(object.getClass())) {
            bl = false;
        } else {
            UDPMessageChannel uDPMessageChannel = (UDPMessageChannel)object;
            bl = this.getKey().equals(uDPMessageChannel.getKey());
        }
        return bl;
    }

    public String getKey() {
        return UDPMessageChannel.getKey(this.peerAddress, this.peerPort, "UDP");
    }

    public int getPeerPacketSourcePort() {
        return this.peerPacketSourcePort;
    }

    public InetAddress getPeerPacketSourceAddress() {
        return this.peerPacketSourceAddress;
    }

    public String getViaHost() {
        return this.myAddress;
    }

    public int getViaPort() {
        return this.myPort;
    }

    public boolean isReliable() {
        return false;
    }

    public boolean isSecure() {
        return false;
    }

    public int getPeerPort() {
        return this.peerPort;
    }

    public String getPeerProtocol() {
        return this.peerProtocol;
    }

    public void close() {
    }

    private final String createBadReqRes(String string, ParseException parseException) {
        StringBuffer stringBuffer = new StringBuffer(512);
        stringBuffer.append("SIP/2.0 400 Bad Request (" + parseException.getLocalizedMessage() + ')');
        if (!UDPMessageChannel.copyViaHeaders(string, stringBuffer)) {
            return null;
        }
        if (!UDPMessageChannel.copyHeader("CSeq", string, stringBuffer)) {
            return null;
        }
        if (!UDPMessageChannel.copyHeader("Call-ID", string, stringBuffer)) {
            return null;
        }
        if (!UDPMessageChannel.copyHeader("From", string, stringBuffer)) {
            return null;
        }
        if (!UDPMessageChannel.copyHeader("To", string, stringBuffer)) {
            return null;
        }
        int n = stringBuffer.indexOf("To");
        if (n != -1 && stringBuffer.indexOf("tag", n) == -1) {
            stringBuffer.append(";tag=badreq");
        }
        Server server = this.sipStack.createServerHeaderForStack();
        stringBuffer.append("\r\n" + server.toString());
        return stringBuffer.toString();
    }

    private static final boolean copyHeader(String string, String string2, StringBuffer stringBuffer) {
        int n;
        int n2 = string2.indexOf(string);
        if (n2 != -1 && (n = string2.indexOf("\r\n", n2)) != -1) {
            stringBuffer.append(string2.subSequence(n2 - 2, n));
            return true;
        }
        return false;
    }

    private static final boolean copyViaHeaders(String string, StringBuffer stringBuffer) {
        int n = string.indexOf("Via");
        boolean bl = false;
        while (n != -1) {
            int n2 = string.indexOf("\r\n", n);
            if (n2 != -1) {
                stringBuffer.append(string.subSequence(n - 2, n2));
                bl = true;
                n = string.indexOf("Via", n2);
                continue;
            }
            return false;
        }
        return bl;
    }
}

