/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.core;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Properties;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.SimpleLayout;

public class LogWriter {
    private Logger logger;
    private String stackName;
    public static final int TRACE_NONE = 0;
    public static final int TRACE_MESSAGES = 16;
    public static final int TRACE_EXCEPTION = 17;
    public static final int TRACE_DEBUG = 32;
    private String logFileName;
    private volatile boolean needsLogging;
    private int lineCount;
    protected int traceLevel;

    public void logStackTrace() {
        if (this.needsLogging) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            StackTraceElement[] stackTraceElementArray = new Exception().getStackTrace();
            for (int i = 1; i < stackTraceElementArray.length; ++i) {
                String string = "[" + stackTraceElementArray[i].getFileName() + ":" + stackTraceElementArray[i].getLineNumber() + "]";
                printWriter.print(string);
            }
            printWriter.close();
            String string = stringWriter.getBuffer().toString();
            this.logDebug(string);
        }
    }

    public int getLineCount() {
        return this.lineCount;
    }

    private Logger getLogger() {
        return this.logger;
    }

    public void addAppender(Appender appender) {
        this.logger.addAppender(appender);
    }

    public void logException(Throwable throwable) {
        if (this.needsLogging) {
            this.getLogger().error((Object)throwable.getMessage(), throwable);
        }
    }

    private void countLines(String string) {
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] != '\n') continue;
            ++this.lineCount;
        }
    }

    private String enhanceMessage(String string) {
        StackTraceElement[] stackTraceElementArray = new Exception().getStackTrace();
        StackTraceElement stackTraceElement = stackTraceElementArray[2];
        String string2 = stackTraceElement.getClassName();
        String string3 = stackTraceElement.getMethodName();
        String string4 = stackTraceElement.getFileName();
        int n = stackTraceElement.getLineNumber();
        String string5 = string2 + "." + string3 + "(" + string4 + ":" + n + ") [" + string + "]";
        return string5;
    }

    public void logDebug(String string) {
        if (this.needsLogging) {
            String string2 = this.enhanceMessage(string);
            this.countLines(string2);
            this.getLogger().debug((Object)string2);
        }
    }

    private void setTraceLevel(int n) {
        this.traceLevel = n;
    }

    public int getTraceLevel() {
        return this.traceLevel;
    }

    public void logFatalError(String string) {
        Logger logger = this.getLogger();
        String string2 = this.enhanceMessage(string);
        this.countLines(string2);
        logger.fatal((Object)string2);
    }

    public void logError(String string) {
        Logger logger = this.getLogger();
        String string2 = this.enhanceMessage(string);
        this.countLines(string2);
        logger.error((Object)string2);
    }

    public LogWriter(Properties properties) {
        block17: {
            this.logFileName = null;
            this.needsLogging = false;
            this.traceLevel = 0;
            String string = properties.getProperty("gov.nist.javax.sip.TRACE_LEVEL");
            this.logFileName = properties.getProperty("gov.nist.javax.sip.DEBUG_LOG");
            String string2 = this.stackName = properties.getProperty("javax.sip.STACK_NAME");
            this.logger = Logger.getLogger((String)string2);
            if (string != null) {
                try {
                    int n = 0;
                    n = string.equals("DEBUG") ? 32 : (string.equals("TRACE") || string.equals("INFO") ? 16 : (string.equals("ERROR") ? 17 : (string.equals("NONE") || string.equals("OFF") ? 0 : Integer.parseInt(string))));
                    this.setTraceLevel(n);
                    this.needsLogging = true;
                    if (this.traceLevel == 32) {
                        this.logger.setLevel(Level.DEBUG);
                    } else if (this.traceLevel == 16) {
                        this.logger.setLevel(Level.INFO);
                    } else if (this.traceLevel == 17) {
                        this.logger.setLevel(Level.ERROR);
                    } else if (this.traceLevel == 0) {
                        this.logger.setLevel(Level.OFF);
                        this.needsLogging = false;
                    }
                    if (!this.needsLogging || this.logFileName == null) break block17;
                    FileAppender fileAppender = null;
                    try {
                        fileAppender = new FileAppender((Layout)new SimpleLayout(), this.logFileName);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        File file = new File(this.logFileName);
                        file.getParentFile().mkdirs();
                        file.delete();
                        try {
                            fileAppender = new FileAppender((Layout)new SimpleLayout(), this.logFileName);
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    if (fileAppender != null) {
                        this.logger.addAppender((Appender)fileAppender);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    numberFormatException.printStackTrace();
                    System.out.println("LogWriter: Bad integer " + string);
                    System.out.println("logging dislabled ");
                    this.needsLogging = false;
                }
            } else {
                this.needsLogging = false;
            }
        }
    }

    public boolean isLoggingEnabled() {
        return this.needsLogging;
    }

    public boolean isLoggingEnabled(int n) {
        return this.needsLogging && n <= this.traceLevel;
    }

    public void logError(String string, Exception exception) {
        Logger logger = this.getLogger();
        logger.error((Object)string, (Throwable)exception);
    }

    public void logWarning(String string) {
        this.getLogger().warn((Object)string);
    }

    public void logInfo(String string) {
        this.getLogger().info((Object)string);
    }

    public void disableLogging() {
        this.needsLogging = false;
    }

    public void enableLogging() {
        this.needsLogging = true;
    }
}

